require('game/objects/Villager');

Objects.SaciVillagerObject = class SaciVillagerObject extends Objects.Villager {
  setEventTypeData() {
    this._forceSequentialAnimation = true;
  }

  preventMovement() {
    return false;
  }

  hasStepAnime() {
    return true;
  }

  despawn() {
    const bitmap = Managers.Images.loadCharacter('villagers/$saci-despawn');
    this._pattern = 0;
    this._direction = Direction.DOWN;
    this._lockPattern = true;
    this._stepAnime = false;

    bitmap.addLoadListener(() => {
      this._characterName = 'villagers/$saci-despawn';

      Switches.holdPlayer = true;

      const frames = 5;
      const animation = [
        { frames, pattern: 0 },
        { frames, pattern: 1 },
        { frames, pattern: 2 },
        { frames, pattern: 0, direction: 4 },
        { frames, pattern: 1 },
        { frames, pattern: 2 },
        { frames, pattern: 0, direction: 6 },
        { frames, pattern: 1 },
        { frames, pattern: 2 },
        { frames, pattern: 0, direction: 8 },
        { frames, method: () => {
          this.erase();

          Switches.holdPlayer = false;
        }}
      ];

      $gameTemp.playAnimationStep(animation, this, 0);
    });
  }
};