require('game/managers/Content');

class SaciContent {
  static contentId() {
    return 'saci';
  }

  static checkCutscenes(mapId) {
    if (this.checkCutsceneChloeFoodRuined(mapId)) return true;
    if (this.checkCutsceneSaciIntroduction(mapId)) return true;

    return false;
  }

  static checkCutsceneChloeFoodRuined(mapId) {
    if (Switches.playedChloesFoodBurntEvent) return false;
    if (mapId !== Maps.RESTAURANT) return false;
    if ($gameMap._mapId !== Maps.ORANGE_TOWN) return false;
    if ($gameParty.hasCompanion()) return false;
    if (!Switches.canShowChloeFoodBurntEvent) return false;

    if (Managers.Time.hour < 10) return false;
    if (Managers.Time.hour > 20) return false;

    if (!$gameSystem.isCharacterKnown('Chloe')) return false;

    //Reserve the cutscene
    $gameTemp.reserveCutscene('chloe_food_ruined');

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 10, 18, Direction.UP, 0, false);

    return true;
  }

  static checkCutsceneSaciIntroduction(mapId) {
    if (!Switches.playedChloesFoodBurntEvent) return false;
    if (Switches.playedSaciIntroduction) return false;

    if (mapId !== Maps.MOUNTAIN) return false;
    if ($gameMap._mapId !== Maps.ORANGE_TOWN) return false;
    if ($gameParty.hasCompanion()) return false;

    if (Managers.Time.hour < 6) return false;
    if (Managers.Time.hour > 20) return false;

    $gameTemp.reserveCutscene('saci_introduction');

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 52, 43, Direction.UP, 0, false);

    return true;
  }

  static getVillagerObjectClass(villagerName) {
    if (villagerName.toLowerCase() == 'saci') {
      return Objects.SaciVillagerObject;
    }
    if (villagerName.toLowerCase().includes('sacikid')) {
      return Objects.SaciVillagerObject;
    }
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'SACI') {
      return;
    }

    const name = parser.name.toUpperCase();
    if (name === 'DESPAWN') {
      const villager = Managers.Villagers.getVillagerData('Saci');
      if (!villager || !villager.despawn) {
        return;
      }

      villager.despawn();
      return true;
    }
  }

  static getStampValue(stampId) {
    if (stampId === 'sacisFound') {
      return Variables.sacisFound;
    }
  }

  static getMaxStampValue(stampId) {
    if (stampId === 'sacisFound') {
      return 50;
    }
  }

  static isStampEnabled(stampId) {
    if (stampId === 'sacisFound') {
      return Variables.sacisFound >= 50;
    }
  }

  static getCustomDatabaseSummaryLines() {
    return [{
      weight: 5,
      title: Switches.playedSaciIntroduction ? t("Sacis Found") : '???',
      dataFn: function() {
        return [Variables.sacisFound, 50];
      }
    }];
  }
}

Managers.Content.registerContentClass(SaciContent);