require('game/managers/Content');

class PlaceholderItemsContent {
  static contentId() {
    return 'placeholder-items';
  }

  static pickItem(item, amount) {
    if (item['placeholder-for']) {
      const placeholderId = item['placeholder-for'];
      const placeholderQuantity = item['placeholder-quantity'] || 1;
      return Managers.Items.pickItemId(placeholderId, amount * placeholderQuantity);
    }

    return false;
  }

  static gainItem(item, amount, reverse, isNew) {
    if (item['placeholder-for']) {
      const placeholderId = item['placeholder-for'];
      const placeholderQuantity = item['placeholder-quantity'] || 1;
      //Use "force" to make sure the item isn't lost, but in theory the placeholder item can't be received if there's no space
      return Managers.Items.forceGainItemId(placeholderId, amount * placeholderQuantity);
    }

    return false;
  }

  static canGainItem(item) {
    if (item['placeholder-for']) {
      return Managers.Items.canGainItemId(item['placeholder-for']);
    }
  }
}

Managers.Content.registerContentClass(PlaceholderItemsContent);