require('game/managers/Content');

function GeneralStoreContent() {
}

GeneralStoreContent.contentId = function() {
  return 'orange-town#GeneralStore';
};

GeneralStoreContent.getLetterList = function() {
  var letters = [];

  if (!Switches.canSellSuperBag && Switches.gotFirstBag) {
    if (Managers.History.daysSinceEvent('got_first_bag') > 10) {
      letters.push('mailbox_super_bag');
      Switches.canSellSuperBag = true;
    }
  }

  if (!Switches.canSellMushroomSeeds && $gameSystem.isMapInitialized(Maps.CAVE_FARM)) {
    letters.push('mailbox_mushroom_seeds');
    Switches.canSellMushroomSeeds = true;
  }

  if (this.checkStrawberrySeeds()) {
    letters.push('mailbox_strawberry_seeds');
    Switches.canBuyStrawberrySeeds = true;
  }

  if (this.checkWatermelonSeeds()) {
    letters.push('mailbox_watermelon_seeds');
    Switches.canBuyWatermelonSeeds = true;
  }

  if (this.checkPumpkinSeeds()) {
    letters.push('mailbox_pumpkin_seeds');
    Switches.canBuyPumpkinSeeds = true;
  }

  if (!Switches.canBuyChillipepperSeeds) {
    if (Managers.Time.year >= 3 || (Managers.Time.year == 2 && Managers.Time.month == 2)) {
      letters.push('mailbox_chillipepper_seeds');
      Switches.canBuyChillipepperSeeds = true;
    }
  }

  if (!Switches.canBuyCassavaSeeds) {
    if (Managers.Time.year >= 3 || (Managers.Time.year == 2 && Managers.Time.month == 2 && Managers.Time.day >= 7)) {
      letters.push('mailbox_cassava_seeds');
      Switches.canBuyCassavaSeeds = true;
    }
  }

  if (!Switches.canBuyGrapeSeeds) {
    if (Managers.Time.year >= 4 || (Managers.Time.year == 3 && Managers.Time.month == 2)) {
      letters.push('mailbox_grape_seeds');
      Switches.canBuyGrapeSeeds = true;
    }
  }

  if (!Switches.canBuyBeetSeeds) {
    if (Managers.Time.year >= 3 || (Managers.Time.year == 2 && Managers.Time.month == 3)) {
      letters.push('mailbox_beet_seeds');
      Switches.canBuyBeetSeeds = true;
    }
  }

  if (!Switches.canBuyBellpepperSeeds) {
    if (Managers.Time.year >= 3 || (Managers.Time.year == 2 && Managers.Time.month == 3 && Managers.Time.day >= 7)) {
      letters.push('mailbox_bellpepper_seeds');
      Switches.canBuyBellpepperSeeds = true;
    }
  }

  if (!Switches.canBuyBroccoliSeeds) {
    if (Managers.Time.year >= 3 || (Managers.Time.year == 2 && Managers.Time.month == 3 && Managers.Time.day >= 14)) {
      letters.push('mailbox_broccoli_seeds');
      Switches.canBuyBroccoliSeeds = true;
    }
  }

  if (!Switches.canBuyRadishSeeds) {
    if (Managers.Time.year >= 3 || (Managers.Time.year == 2 && Managers.Time.month == 3 && Managers.Time.day >= 21)) {
      letters.push('mailbox_radish_seeds');
      Switches.canBuyRadishSeeds = true;
    }
  }

  if (!Switches.canBuyPeanutSeeds) {
    if (Managers.Time.year >= 4 || (Managers.Time.year == 3 && Managers.Time.month == 3)) {
      letters.push('mailbox_peanut_seeds');
      Switches.canBuyPeanutSeeds = true;
    }
  }

  if (!Switches.canBuySpinachSeeds) {
    if (Managers.Time.year >= 4 || (Managers.Time.year == 3 && Managers.Time.month == 3 && Managers.Time.day >= 7)) {
      letters.push('mailbox_spinach_seeds');
      Switches.canBuySpinachSeeds = true;
    }
  }

  return letters;
};

GeneralStoreContent.checkStrawberrySeeds = function() {
  if (Switches.canBuyStrawberrySeeds) return false;

  var turnipCount = Managers.History.getShippedItems('turnip');
  if (turnipCount < 100) return false;

  var potatoCount = Managers.History.getShippedItems('potato');
  if (potatoCount < 100) return false;

  var cucumberCount = Managers.History.getShippedItems('cucumber');
  if (cucumberCount < 100) return false;

  return true;
};

GeneralStoreContent.checkWatermelonSeeds = function() {
  if (Switches.canBuyWatermelonSeeds) return false;

  var tomatoCount = Managers.History.getShippedItems('tomato');
  if (tomatoCount < 100) return false;

  var onionCount = Managers.History.getShippedItems('onion');
  if (onionCount < 100) return false;

  var cornCount = Managers.History.getShippedItems('corn');
  if (cornCount < 100) return false;

  return true;
};

GeneralStoreContent.checkPumpkinSeeds = function() {
  if (Switches.canBuyPumpkinSeeds) return false;

  var eggplantCount = Managers.History.getShippedItems('eggplant');
  if (eggplantCount < 100) return false;

  var carrotCount = Managers.History.getShippedItems('carrot');
  if (carrotCount < 100) return false;

  var sweetPotatoCount = Managers.History.getShippedItems('sweet-potato');
  if (sweetPotatoCount < 100) return false;

  return true;
};

Managers.Content.registerContentClass(GeneralStoreContent);