class OrangeTownMap {
  static winterCompatibleSpriteName(spriteName) {
    if (Managers.Time.month == Seasons.WINTER) {
      return `${ spriteName }_snow`;
    }

    return spriteName;
  }

  static createBenjaminAnimals() {
    $gameMap.createNormalEventAt(Creatures.Cow3._spriteName, Creatures.Cow3._spriteIndex, 58, 9, Direction.LEFT, 0, true, Objects.WildCreature);
    $gameMap.createNormalEventAt(Creatures.Goat._spriteName, Creatures.Goat._spriteIndex, 53, 12, Direction.UP, 0, true, Objects.WildCreature);

    $gameMap.createNormalEventAt(Creatures.Bunny._spriteName, Creatures.Bunny._spriteIndex, 59, 12, Direction.RIGHT, 0, true, Objects.WildCreature);
        
    $gameMap.createNormalEventAt(Creatures.Sheep._spriteName, Creatures.Sheep._spriteIndex, 58, 13, Direction.UP, 0, true, Objects.WildCreature);
    
    $gameMap.createNormalEventAt(Creatures.SmallTurtle._spriteName, Creatures.SmallTurtle._spriteIndex, 40, 6, Direction.RIGHT, 0, true, Objects.WildCreature);

    $gameMap.createNormalEventAt(Creatures.CinnamonChicken._spriteName, Creatures.CinnamonChicken._spriteIndex, 60, 7, Direction.RIGHT, 0, true, Objects.WildCreature);
  }


  static createBrittanyAnimals() {
    $gameMap.createNormalEventAt(Creatures.Cow._spriteName, Creatures.Cow._spriteIndex, 30, 62, Direction.LEFT, 0, true, Objects.RanchAnimal);
    $gameMap.createNormalEventAt(Creatures.Cow2._spriteName, Creatures.Cow2._spriteIndex, 31, 63, Direction.DOWN, 0, true, Objects.RanchAnimal);
    // $gameMap.createNormalEventAt(Creatures.Pig._spriteName, Creatures.Pig._spriteIndex, 29, 64, Direction.RIGHT, 0, true, Objects.RanchAnimal);
    
    $gameMap.createNormalEventAt(Creatures.Chicken._spriteName, Creatures.Chicken._spriteIndex, 33, 60, Direction.RIGHT, 0, true, Objects.RanchAnimal);
    $gameMap.createNormalEventAt(Creatures.DarkChicken._spriteName, Creatures.DarkChicken._spriteIndex, 32, 61, Direction.UP, 0, true, Objects.RanchAnimal);
  }

  static createMiaAnimals() {

  }

  static createSpaEvents() {
    const x = 34;
    const y = 39;

    $gameMap.createDoorEvent('houses/doors', 2, 2, x, y, 'SPA', 0, -1);
    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/$$$spa_entrance'), x, y, 1, 0, 0, true);

    $gameMap.createCollisionArea(x - 1, y, 1, 1);
    $gameMap.createCollisionArea(x + 1, y, 1, 1);
  }

  static createStoreBuildingEvents() {
    const x = 4;
    const y = 38;

    $gameMap.createSingleSpriteEventAt('houses/store/$$$base1', x, y, 0, 16);
    $gameMap.createSingleSpriteEventAt('houses/store/$$$base2', x - 4, y, 0, 16);
    $gameMap.createSingleSpriteEventAt('houses/store/$$$base3', x, y + 1, 0, 16);
    $gameMap.createSingleSpriteEventAt('houses/store/$$$base4', x + 4, y - 3, 0, 16);
    $gameMap.createSingleSpriteEventAt('houses/store/$$$objects1', x + 4, y, 1, 16);
    $gameMap.createSingleSpriteEventAt('houses/store/$$$objects2', x - 4, y, 1, 16);
    $gameMap.createSingleSpriteEventAt('houses/store/$$$above1', x, y, 2, 16);
    $gameMap.createSingleSpriteEventAt('houses/store/$$$above2', x + 4, y - 3, 2, 16);
    $gameMap.createSingleSpriteEventAt('houses/store/$$$above3', x - 4, y - 2, 2, 16);
    $gameMap.createSingleSpriteEventAt('houses/store/$$$roof', x, y - 2, 2, 16);
    $gameMap.createDoorEvent('houses/doors', 2, 1, x + 1, y, 'Serge');

    $gameMap.createCollisionArea(x + 5, y - 1, 0.5, 2);

    $gameMap.createSingleSpriteEventAt('houses/store/$$$boxes', x - 3, y + 2, 0, 16);
    $gameMap.createCollisionArea(x - 3, y + 1, 0.75, 1.25);
    $gameMap.createCollisionArea(x - 2.25, y + 1, 0.5, 0.5);

    $gameMap.createStaticEventAt('objects/$signs', 0, x + 2, y + 1, 2, 1, 1, true, false, false, 'store_sign')._lockPattern = true;
  }

  static createInnBuildingEvents() {
    const x = 41;
    const y = 37;

    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/$$$inn'), x, y, 1, 0, 0, true);
    $gameMap.createDoorEvent('houses/doors2', 0, 0, x, y, 'Chloe');

    $gameMap.createStaticEventAt('objects/$signs', 0, x - 2, y + 1, 2, 1, 1, true, false, false, 'restaurant_sign')._lockPattern = true;
  }

  static createLucasBuildingEvents() {
    const x = 64;
    const y = 34;

    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/lucas/$$$base'), x + 1, y, 0);
    $gameMap.createSingleSpriteEventAt('houses/lucas/$$$above', x + 1, y - 1, 2);

    $gameMap.createDoorEvent('houses/doors', 0, 0, x, y, 'Lucas', 0, -2);

    $gameMap.createCollisionArea(x + 4, y -3, 0.25, 4);
    $gameMap.createCollisionArea(x - 1.5, y -3, 0.5, 4);
  }

  static createAmandaBuildingEvents() {
    const x = 54;
    const y = 34;

    $gameMap.createSingleSpriteEventAt('houses/amanda/$$$base', x, y + 1, 0, 16);
    $gameMap.createSingleSpriteEventAt('houses/amanda/$$$above', x, y - 2, 2, 16, 4);

    const door = $gameMap.createDoorEvent('houses/doors2', 0, 1, x, y, 'Amanda', 15);
    door.hitboxWidth = 2;

    $gameMap.createSingleSpriteEventAt('houses/amanda/$$$junk', x, y - 5, 0, 16);
    $gameMap.createCollisionArea(x - 0.5, y - 4.5, 2.75, 0.5);

    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/amanda/$$$plants'), x + 2, y + 1, 0, 16);
    $gameMap.createCollisionArea(x + 3, y + 1, 1, 1);
    $gameMap.createCollisionArea(x + 2.5, y + 1, 0.5, 1);

    const createEvent = (tileId, x, y, { hitboxX, hitboxY, hitboxWidth, hitboxHeight, offsetX }) => {
      const event = $gameMap.createStaticTileEventAt(tileId, x, y, 1, true);
      
      if (hitboxX) {
        event.hitboxX = hitboxX;
      }

      if (hitboxY) {
        event.hitboxY = hitboxY;
      }

      if (hitboxWidth) {
        event.hitboxWidth = hitboxWidth;
      }

      if (hitboxHeight) {
        event.hitboxHeight = hitboxHeight;
      }
    };

    createEvent(574, x - 2, y + 3, {
      hitboxY: 0.75,
      hitboxHeight: 0.25,
    });

    createEvent(576, x - 1, y + 3, {
      hitboxY: 0.75,
      hitboxHeight: 0.25,
      hitboxWidth: 0.75,
    });

    createEvent(574, x + 2, y + 3, {
      hitboxY: 0.75,
      hitboxHeight: 0.25,
      hitboxX: 0.25,
      offsetX: 8,
    });

    createEvent(573, x + 3, y + 3, {
      hitboxY: 0.75,
      hitboxHeight: 0.25,
      hitboxX: 0.25,
      hitboxWidth: 0.75,
      offsetX: 8,
    });
    $gameMap.createCollisionArea(x + 3.75, y + 3, 0.25, 1);

    createEvent(565, x + 3, y + 2, {
      hitboxX: 0.75,
      hitboxWidth: 0.25,
      offsetX: 8,
    });

    createEvent(594, x + 3, y + 1, {
      hitboxX: 0.75,
      hitboxWidth: 0.25,
      offsetX: 8,
    });

    createEvent(586, x + 3, y, {
      hitboxX: 0.75,
      hitboxWidth: 0.25,
      offsetX: 8,
    });
  }

  static createJuliaBuildingEvents() {
    const x = 60;
    const y = 25;

    $gameMap.createSingleSpriteEventAt('houses/julia/$$$house', x, y, 1, 0, 0, true);
    $gameMap.createSingleSpriteEventAt('houses/julia/$$$stairs', x, y + 1, 0, 0, 0);
    $gameMap.createSingleSpriteEventAt('houses/julia/$$$pole', x - 3, y + 1, 1, 16, 0, true);

    const door = $gameMap.createDoorEvent('houses/doors2', 0, 1, x, y, 'Julia');

    door.hitboxX = -0.5;
    door.hitboxWidth = 2;

    $gameMap.createCollisionArea(x - 1, y, 0.5, 1);
    $gameMap.createCollisionArea(x + 1.5, y, 0.5, 1);
    $gameMap.createCollisionArea(x - 2.125, y + 1.75, 0.25, 0.25);

    const flag = $gameMap.createStaticEventAt('houses/julia/$flag', 0, x - 3, y -1, 2, 0, 2, true);
    flag._metaOffsetX = 6.5;
    flag._metaOffsetY = 12.5;
    flag._lockPattern = true;
    const animation = [];

    for (let i = 0; i < 4; i++) {
      animation.push({ pattern: 0, direction: 2 });
      animation.push({ pattern: 1, direction: 2 });
      animation.push({ pattern: 2, direction: 2 });
      animation.push({ pattern: 0, direction: 4 });
    }

    animation.push({ pattern: 1, direction: 4 });
    animation.push({ pattern: 2, direction: 4 });
    animation.push({ pattern: 0, direction: 6 });
    animation.push({ pattern: 1, direction: 6 });
    animation.push({ pattern: 2, direction: 6 });

    flag.animate(animation, { 
      avoidLock: true,
      loop: true,
      defaultStepLength: 12,
    });
  }

  static createBonnieBuildingEvents() {
    const x = 28;
    const y = 5;

    $gameMap.createSingleSpriteEventAt('houses/bonnie/$$$base', x + 1, y, 0, 0, 1);
    $gameMap.createSingleSpriteEventAt('houses/bonnie/$$$above', x + 1, y - 1, 2);

    const sign = $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/bonnie/$$$sign'), x + 2, y + 1, 1, 0, 0, false, 'clinic_sign');
    sign.hitboxY = -0.5;
    sign.hitboxHeight = 1.25;

    $gameMap.createDoorEvent('houses/doors', 1, 1, x, y, 'Bonnie');
  }

  static createGabrielBuildingEvents() {
    const x = 58;
    const y = 70;

    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/gabriel/$$$platform'), x, y + 1, 0, -3);
    $gameMap.createSingleSpriteEventAt('houses/gabriel/$$$house', x, y, 1, 0, 0, true);

    $gameMap.createDoorEvent('houses/doors', 0, 2, x, y, 'Gabriel');

    $gameMap.createCollisionArea(x - 2.5, y - 2, 6, 3);
  }

  static createLibraryBuildingEvents() {
    const x = 18;
    const y = 37;

    $gameMap.createSingleSpriteEventAt('houses/library/$$$base', x, y + 1, 0);
    $gameMap.createSingleSpriteEventAt('houses/library/$$$above', x, y - 1, 2);
    $gameMap.createSingleSpriteEventAt('houses/library/$$$stairs', x, y + 1, 0);

    $gameMap.createDoorEvent('houses/doors2', 0, 2, x, y, 'Nathalia');

    $gameMap.createCollisionArea(x - 1, y, 0.5, 1);
    $gameMap.createCollisionArea(x + 1.5, y, 0.5, 1);

    $gameMap.createStaticEventAt('objects/$signs', 0, x - 2, y + 1, 2, 2, 1, true, false, false, 'library_sign')._lockPattern = true;
  }

  static createBrittanyBuildingEvents() {
    const x = 12;
    const y = 69;

    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/brittany/$$$base'), x, y + 2, 0, 0, -2);
    $gameMap.createSingleSpriteEventAt('houses/brittany/$$$above', x, y, 2, 0, -2);

    $gameMap.createDoorEvent('houses/doors', 0, 0, x, y, 'Brittany', 0, -1);

    const event = $gameMap.createStaticEventAt('objects/$signs_wide', 0, x - 3, y + 2, 2, 0, 1, true, false, false, 'brittany_sign');
    event._lockPattern = true;
    event._hitboxWidth = 1.5;
    event._metaOffsetX = 16;
  }

  static createMiaBuildingEvents() {
    const x = 18;
    const y = 6;

    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/mia/$$$base'), x, y, 0, 24);
    $gameMap.createSingleSpriteEventAt('houses/mia/$$$objects', x + 1, y, 1, 8, 0, true);
    $gameMap.createSingleSpriteEventAt('houses/mia/$$$above1', x, y - 2, 2, 24);
    $gameMap.createSingleSpriteEventAt('houses/mia/$$$above2', x + 1, y - 1, 2, 8);

    // Right side
    $gameMap.createCollisionArea(x + 4, y - 5, 0.5, 6);
    // Near the door
    $gameMap.createCollisionArea(x + 2.5, y - 1, 0.5, 2);
    // Door frames
    $gameMap.createCollisionArea(x + 1, y - 1, 0.25, 1);
    $gameMap.createCollisionArea(x + 2.25, y - 1, 0.25, 1);

    $gameMap.createDoorEvent('houses/doors', 2, 0, x + 1, y - 1, 'Mia', 8);
  }

  static createKarlBuildingEvents() {
    const x = 44;
    const y = 60;

    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/karl/$$$base'), x, y, 0, 17);
    $gameMap.createSingleSpriteEventAt('houses/karl/$$$above', x, y - 1, 2, 17);
    
    $gameMap.createSingleSpriteEventAt('houses/karl/$$$stool', x - 1, y + 1, 0);
    $gameMap.createCollisionArea(x - 1.125, y + 1, 0.75, 0.5);
    $gameMap.createCollisionArea(x - 1.25, y - 2, 4.5, 3);

    $gameMap.createDoorEvent('houses/doors', 1, 0, x + 1, y, 'Karl');
  }

  static createBenjaminBuildingEvents() {
    const x = 46;
    const y = 19;

    $gameMap.createSingleSpriteEventAt('houses/benjamin/$$$base', x, y, 0);
    $gameMap.createSingleSpriteEventAt('houses/benjamin/$$$objects1', x - 3, y - 1, 1, 16);
    $gameMap.createSingleSpriteEventAt('houses/benjamin/$$$objects2', x + 2, y - 1, 1, 16);
    $gameMap.createSingleSpriteEventAt('houses/benjamin/$$$above1', x, y - 2, 2, 0);
    $gameMap.createSingleSpriteEventAt('houses/benjamin/$$$above2', x, y - 4, 2);

    $gameMap.createDoorEvent('houses/doors2', 1, 0, x, y - 2, 'Benjamin');

    $gameMap.createCollisionArea(x - 2, y - 0.125, 1, 0.25);
    $gameMap.createCollisionArea(x + 2, y - 0.125, 1, 0.25);
    $gameMap.createCollisionArea(x - 2, y - 2, 0.25, 1);
    $gameMap.createCollisionArea(x + 2.75, y - 2, 0.25, 1);
    $gameMap.createCollisionArea(x + 1.5, y -1, 0.5, 0.25);
    
    $gameMap.createSingleSpriteEventAt('houses/benjamin/$$$haystack', x + 7, y - 3, 1);
    $gameMap.createSingleSpriteEventAt('houses/benjamin/$$$boxes', x - 5, y, 1, 16);
  }

  static createDukeBuildingEvents() {
    const x = 30;
    const y = 74;

    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/duke/$$$base'), x, y, 0, 16);
    $gameMap.createSingleSpriteEventAt('houses/duke/$$$objects1', x - 3, y, 0, 16);
    $gameMap.createSingleSpriteEventAt('houses/duke/$$$objects2', x - 3, y - 1, 1, 0, 16, true);

    $gameMap.createSingleSpriteEventAt('houses/duke/$$$above1', x - 3, y - 1, 2, 16);
    $gameMap.createSingleSpriteEventAt('houses/duke/$$$above2', x, y - 2, 2, 16);

    $gameMap.createDoorEvent('houses/doors', 0, 0, x + 1, y - 1, 'Duke', -1);
    $gameMap.createCollisionArea(x - 2.25, y - 1, 1, 1);
  }

  static createRaphaelBuildingEvents() {
    const x = 69;
    const y = 58;

    $gameMap.createSingleSpriteEventAt('houses/raphael/$$$base', x, y, 0);
    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/raphael/$$$objects1'), x - 4, y - 1, 1, 16, 0, true);
    $gameMap.createSingleSpriteEventAt('houses/raphael/$$$objects2', x - 2, y - 1, 1, 0, 0, true);
    $gameMap.createSingleSpriteEventAt('houses/raphael/$$$objects3', x + 2, y - 1, 1, 0, 0, true);
    $gameMap.createSingleSpriteEventAt('houses/raphael/$$$above1', x, y - 2, 2);
    $gameMap.createSingleSpriteEventAt('houses/raphael/$$$above2', x - 4, y - 2, 2, 16);

    $gameMap.createDoorEvent('houses/doors', 1, 2, x, y - 2, 'Raphael');

    $gameMap.createCollisionArea(x - 2, y - 0.125, 2, 0.25);
    $gameMap.createCollisionArea(x + 1, y - 0.125, 2, 0.25);
    $gameMap.createCollisionArea(x - 2, y - 1, 0.25, 1);
    $gameMap.createCollisionArea(x + 2.75, y - 1, 0.25, 1);
    $gameMap.createCollisionArea(x - 3.25, y -3, 1, 3);

    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/raphael/$$$lumber'), x + 4, y - 1, 0);
    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/raphael/$$$stump'), x - 3, y + 1, 0);
    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/raphael/$$$fence'), x - 3, y + 3, 0, 12, -12);

    $gameMap.createCollisionArea(x - 3.75, y - 0.75, 2, 3);
    $gameMap.createCollisionArea(x - 3, y + 2, 2.25, 0.5);
    $gameMap.createCollisionArea(x + 3, y - 3.75, 2, 3.25);

    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/raphael/$$$junk'), x - 2, y, 1, 0, 0, true);
    $gameMap.createCollisionArea(x - 1.75, y, 1, 0.5);
    
    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/raphael/$$$junk2'), x + 2, y, 1, 0, -8, true);
    $gameMap.createCollisionArea(x + 2.5, y, 1, 0.5);

    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/raphael/$$$grass'), x + 2, y, 0, 16, 16, true);
    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/raphael/$$$lowgrass'), x - 1, y, 0, 16, 0, true);

    const event = $gameMap.createStaticEventAt('objects/$signs', 0, x - 1, y, 2, 0, 1, true, false, false, 'carpenter_sign');
    event._lockPattern = true;
    event._metaOffsetX = 8;
    event._metaOffsetY = 8;
  }

  static createRoryBuildingEvents() {
    const x = 32;
    const y = 29;

    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/rory/$$$base1'), x - 4, y - 2, 0, 0);
    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/rory/$$$base2'), x, y, 0, 0);
    $gameMap.createSingleSpriteEventAt('houses/rory/$$$above1', x - 2, y - 3, 2, 0);
    $gameMap.createSingleSpriteEventAt('houses/rory/$$$above2', x, y - 1, 2, 0);

    $gameMap.createDoorEvent('houses/doors', 0, 0, x - 4, y - 2, 'Rory', 0, -1);
    $gameMap.createDoorEvent('houses/doors', 0, 0, x, y, 'RoryFarm', 0, -1);

    $gameMap.createStaticEventAt('objects/$signs', 0, x - 3, y - 1, 4, 0, 1, true, false, false, 'rory_sign')._lockPattern = true;
  }

  static createIldaBuildingEvents() {
    const x = 65;
    const y = 50;

    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/ilda/$$$base1'), x - 4, y, 0);
    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/ilda/$$$base2'), x, y - 2, 0);
    $gameMap.createSingleSpriteEventAt('houses/ilda/$$$above1', x - 4, y - 1, 2);
    $gameMap.createSingleSpriteEventAt('houses/ilda/$$$above2', x - 2, y - 3, 2, 16);
    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/ilda/$$$objects'), x + 2, y - 1, 0);
    $gameMap.createCollisionArea(x + 2.5, y - 1, 0.5, 0.25);
    
    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/ilda/$$$mailbox'), x - 5, y + 1, 1, 0, 0, true);
    $gameMap.createCollisionArea(x - 4.5, y + 1, 0.25, 0.5);
    $gameMap.createCollisionArea(x - 5.25, y - 4, 0.25, 5);

    $gameMap.createDoorEvent('houses/doors', 0, 1, x - 4, y, 'Ilda', 0, -1);
  }

  static createViktorBuildingEvents() {
    const x = 6;
    const y = 20;

    $gameMap.createSingleSpriteEventAt('houses/viktor/$$$base1', x + 1, y + 3, 0);
    $gameMap.createSingleSpriteEventAt('houses/viktor/$$$base2', x - 4, y + 3, 0);
    $gameMap.createSingleSpriteEventAt('houses/viktor/$$$objects1', x - 5, y + 3, 1);
    $gameMap.createSingleSpriteEventAt('houses/viktor/$$$objects2', x - 3, y + 1, 1);
    $gameMap.createSingleSpriteEventAt('houses/viktor/$$$objects3', x - 1, y + 3, 1, 0, 0, true);
    $gameMap.createSingleSpriteEventAt('houses/viktor/$$$objects4', x + 1, y + 3, 1, 0, 0, true);

    $gameMap.createSingleSpriteEventAt('houses/viktor/$$$above1', x, y, 2);
    $gameMap.createSingleSpriteEventAt('houses/viktor/$$$above2', x - 4, y + 2, 2);
    $gameMap.createSingleSpriteEventAt('houses/viktor/$$$above3', x + 3, y, 2);
    $gameMap.createSingleSpriteEventAt('houses/viktor/$$$above4', x, y + 2, 2);

    $gameMap.createSingleSpriteEventAt('houses/viktor/$$$ground', x - 4, y + 4, 0);
    $gameMap.createSingleSpriteEventAt('houses/viktor/$$$box', x - 2, y + 3, 1, 16, 0, true);
    $gameMap.createSingleSpriteEventAt('houses/viktor/$$$boxes', x - 4, y + 6, 1, -16, 0, true);
    $gameMap.createCollisionArea(x - 1.25, y + 3, 0.5, 0.75);
    $gameMap.createCollisionArea(x - 5, y + 6, 1.5, 0.75);

    $gameMap.createCollisionArea(x - 0.5, y + 3, 0.25, 0.5);
    $gameMap.createCollisionArea(x + 1.25, y + 3, 0.25, 0.5);
    
    // House door, temporary
    $gameMap.createCollisionArea(x, y + 2, 1, 1);

    const chain = $gameMap.createDoorEvent('houses/viktor/$chain', 0, 0, x - 3, y + 2, 'Blacksmith', -8);
    chain.hitboxX = -0.5;
    chain.hitboxWidth = 2;

    $gameMap.createDoorEvent('houses/doors', 0, 0, x, y + 2, 'Viktor', 0);

    $gameMap.createStaticEventAt('objects/$signs', 0, x + 4, y + 1, 2, 0, 1, true, false, false, 'blacksmith_sign')._lockPattern = true;
  }

  static setupMapEvents() {
    Managers.Tasks.updateVariables();

    if (!Managers.Weather.isBadWeather()) {
      OrangeTownMap.createBenjaminAnimals();
      OrangeTownMap.createBrittanyAnimals();
      OrangeTownMap.createMiaAnimals();
    }

    OrangeTownMap.createStoreBuildingEvents();
    OrangeTownMap.createInnBuildingEvents();
    OrangeTownMap.createLibraryBuildingEvents();
    OrangeTownMap.createBrittanyBuildingEvents();
    OrangeTownMap.createDukeBuildingEvents();
    OrangeTownMap.createGabrielBuildingEvents();
    OrangeTownMap.createLucasBuildingEvents();
    OrangeTownMap.createAmandaBuildingEvents();
    OrangeTownMap.createJuliaBuildingEvents();
    OrangeTownMap.createBenjaminBuildingEvents();
    OrangeTownMap.createBonnieBuildingEvents();
    OrangeTownMap.createViktorBuildingEvents();
    OrangeTownMap.createMiaBuildingEvents();
    OrangeTownMap.createRaphaelBuildingEvents();
    OrangeTownMap.createRoryBuildingEvents();
    OrangeTownMap.createKarlBuildingEvents();
    OrangeTownMap.createIldaBuildingEvents();

    OrangeTownMap.createSpaEvents();
    OrangeTownMap.createBoardEvents();

    $gameMap.updateDoorsState();
    this.addSoundSources();
  }

  static addSoundSources() {
    // Moving Water
    $gameMap.addSoundSource(75, 5, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(68, 16, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(72, 25, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(72, 34, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(72, 44, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(73, 52, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(75, 66, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(75, 57, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(71, 73, 'WaterLoop', 0.4);
  }

  static checkTeleports() {
    if ($gamePlayer.right < 1) {
      if ($gamePlayer.top >= 45 && $gamePlayer.y < 49) {
        $gamePlayer.reserveTransfer(Maps.MOUNTAIN, 69, $gamePlayer.y + 26, $gamePlayer._direction, 0, true);
      }

      return;
    }

    if ($gamePlayer.top >= 79) {
      if ($gamePlayer.right <= 5) {
        $gamePlayer.reserveTransfer(Maps.FARM, $gamePlayer.x + 41, 1, $gamePlayer._direction, 0, true);
        return;
      }
      
      if ($gamePlayer.left >= 63) {
        $gamePlayer.reserveTransfer(Maps.PETTING_ZOO, $gamePlayer.x - 46, 1, $gamePlayer._direction, 0, true);
        return;
      }
    }

    if ($gamePlayer.left >= 75 && $gamePlayer.y <= 69) {
      $gamePlayer.reserveTransfer(Maps.FOREST, 1, $gamePlayer.y, $gamePlayer._direction, 0, true);
      return;
    }

    if ($gamePlayer.bottom <= 1) {
      if ($gamePlayer.left < 36 && $gamePlayer.right > 33) {
        if (Switches.isFestival) {
          if (Managers.Festivals.isFestivalPrepared()) {
            Managers.Festivals.teleportToFestival();
          } else {
            Managers.Festivals.leaveUnpreparedFestivalArea();
          }
        } else {
          Managers.Festivals.teleportToFestival();
        }
      }
    }

    if ($gamePlayer.x > 33 && $gamePlayer.x < 35 && $gamePlayer.y <= 39 && $gamePlayer.y >= 38) {
      this.enterSpa();
      return;
    }
  }

  static enterSpa() {
    if ($gamePlayer.isRiding() || $gameParty.hasCompanion()) {
      $gamePlayer.setDestination(34, 40);
      return;
    }

    if (!$gamePlayer.canMove()) {
      return;
    }

    // Don't let the player enter the SPA at this time to prevent any possible conflict at 6am
    if (Managers.Time.isBetweenTimes('04:40', '05:59')) {
      $gamePlayer.setDestination(34, 40);
      return;
    }

    Managers.CommonEvent.playEventAsync('enter_spa');
  }

  static enterStore() {
    Switches.waitingForTransfer = true;
    $gameMap._interpreter.doDoorAnimation();
    $gameTemp.setTimeout(() => {
      $gamePlayer.reserveTransfer(Maps.GENERAL_STORE, 12, 15, Direction.UP, 0, true);
    }, 18);
  }

  static doStoreDoor() {
    if ($gamePlayer.isRiding()) {
      return;
    }

    if (Managers.Time.isBetweenTimes('09:30', '15:59')) {
      OrangeTownMap.enterStore();
      return;
    }

    Managers.CommonEvent.playEvent('store_sign');
  }

  static enterLibrary() {
    Switches.waitingForTransfer = true;
    $gameMap._interpreter.doDoorAnimation();
    $gameTemp.setTimeout(() => {
      $gamePlayer.reserveTransfer(Maps.LIBRARY, 9, 13, Direction.UP, 0, true);
    }, 18);
  }

  static enterBenjaminsHouse() {
    Switches.waitingForTransfer = true;
    $gameMap._interpreter.doDoorAnimation();
    $gameTemp.setTimeout(() => {
      $gamePlayer.reserveTransfer(Maps.BENJAMINS_HOUSE, 22, 15, Direction.UP, 0, true);
    }, 18);
  }

  static doLibraryDoor() {
    if ($gamePlayer.isRiding()) {
      return;
    }

    if (Managers.Time.isBetweenTimes('10:45', '18:45')) {
      OrangeTownMap.enterLibrary();
      return;
    }

    if (Managers.Villagers.isVillagerScheduledAtMap('Nathalia', Maps.LIBRARY)) {
      Managers.CommonEvent.playEvent('nathalia_leave_house');
    } else {
      Managers.CommonEvent.playEvent('door_unanswered');
    }
  }

  static doSpaDoor() {
    // $gameMap.openVillagerDoor('SPA');
  }

  static doBenjaminDoor() {
    if ($gamePlayer.isRiding()) {
      return;
    }

    if (Managers.Villagers.isVillagerScheduledAtMap('Benjamin', Maps.BENJAMINS_HOUSE)) {
      Managers.CommonEvent.playEvent('benjamin_leave_house');
    } else {
      Managers.CommonEvent.playEvent('door_unanswered');
    }
  }

  static updateMapLights() {
    Switches.storeLightsOn = Managers.Villagers.wasVillagerScheduledAtMap(['Devin', 'Serge'], Maps.GENERAL_STORE);
    Switches.nathaliaLightsOn = Managers.Villagers.wasVillagerScheduledAtMap(['Nathalia', 'Annie', 'Devin', 'Viktor'], Maps.LIBRARY);
    Switches.benjaminLightsOn = Managers.Villagers.wasVillagerScheduledAtMap('Benjamin', Maps.BENJAMINS_HOUSE);
    Switches.brittanyLightsOn = Managers.Villagers.wasVillagerScheduledAtMap(['Brittany', 'Stella', 'Benjamin', 'Julia'], Maps.BRITTANYS_FARM);
    Switches.raphaelLightsOn = Managers.Villagers.wasVillagerScheduledAtMap('Raphael', Maps.CARPENTER_HOUSE);
    Switches.bonnieLightsOn = Managers.Villagers.wasVillagerScheduledAtMap(['Bonnie', 'Phi'], Maps.CLINIC);
    Switches.viktorLightsOn = Managers.Villagers.wasVillagerScheduledAtMap(['Viktor', 'Richard'], [Maps.BLACKSMITH, Maps.BLACKSMITH_ROOMS]);
    Switches.juliaLightsOn = Managers.Villagers.wasVillagerScheduledAtMap('Julia', Maps.CITY_HALL);
    Switches.lucasLightsOn = Managers.Villagers.wasVillagerScheduledAtMap('Lucas', Maps.LUCAS_HOUSE);
    Switches.restaurantLightsOn = Managers.Villagers.wasVillagerScheduledAtMap(['Chloe'], Maps.RESTAURANT);
    Switches.roryLightsOn = Managers.Villagers.wasVillagerScheduledAtMap(['Billy', 'Rory', 'Cindy'], Maps.RORYS_FARM);
    Switches.gabrielLightsOn = Managers.Villagers.wasVillagerScheduledAtMap(['Maya', 'Gabriel'], Maps.GABRIELS_HOUSE);
    Switches.amandaLightsOn = Managers.Villagers.wasVillagerScheduledAtMap('Amanda', Maps.AMANDAS_HOUSE);
    Switches.ildaLightsOn = Managers.Villagers.wasVillagerScheduledAtMap('Ilda', Maps.ILDAS_HOUSE);
    Switches.miaLightsOn = Managers.Villagers.wasVillagerScheduledAtMap('Mia', Maps.MIAS_HOUSE);
    Switches.karlLightsOn = Managers.Villagers.wasVillagerScheduledAtMap(['Karl'], Maps.KARLS_HOUSE);
    Switches.dukeLightsOn = Managers.Villagers.wasVillagerScheduledAtMap('Duke', Maps.DUKES_HOUSE);
  }

  static getHeightLevel(x, y) {
    if (y >= 30) return 0;
    if (x >= 26) return 0;
    if (x <= 13) return 3;
    if (y >= 28) return 0;
    if (x <= 21) return 3;
    if (y >= 17) return 0;
    return 3;
  }

  static isAvailableArea() {
    return true;
  }

  static doBrittanyFarmDoor() {
    if ($gamePlayer.isRiding()) {
      return;
    }

    if (Managers.Time.isBetweenTimes('07:30', '17:30')) {
      this.enterBrittanyFarm();
      return;
    }

    if (Managers.Villagers.isVillagerScheduledAtMap('Stella', Maps.BRITTANYS_FARM)) {
      Managers.CommonEvent.playEvent('stella_leave_house');
    } else if (Managers.Villagers.isVillagerScheduledAtMap('Brittany', Maps.BRITTANYS_FARM)) {
      Managers.CommonEvent.playEvent('brittany_leave_house');
    } else {
      Managers.CommonEvent.playEvent('door_unanswered');
    }
  }

  static enterBrittanyFarm() {
    Switches.waitingForTransfer = true;
    $gameMap._interpreter.doDoorAnimation();
    $gameTemp.setTimeout(() => {
      $gamePlayer.reserveTransfer(Maps.BRITTANYS_FARM, 12, 19, Direction.UP, 0, true);
    }, 18);
  }

  static enterCarpenter() {
    Switches.waitingForTransfer = true;
    $gameMap._interpreter.doDoorAnimation();
    $gameTemp.setTimeout(() => {
      $gamePlayer.reserveTransfer(Maps.CARPENTER_HOUSE, 11, 16, Direction.UP, 0, true);
    }, 18);
  }

  static doCarpenterDoor() {
    if ($gamePlayer.isRiding()) {
      return;
    }

    //Working hours
    if (!Switches.isExpandingHouse) {
      if (Managers.Time.isBetweenTimes('12:20', '21:00')) {
        OrangeTownMap.enterCarpenter();
        return;
      }
    }

    if (Managers.Villagers.isVillagerScheduledAtMap('Raphael', Maps.CARPENTER_HOUSE)) {
      Managers.CommonEvent.playEvent('raphael_leave_house');
    } else {
      Managers.CommonEvent.playEvent('door_unanswered');
    }
  }

  static enterBlacksmith() {
    Switches.waitingForTransfer = true;
    $gameMap._interpreter.doDoorAnimation(false);
    $gameTemp.setTimeout(() => {
      $gamePlayer.reserveTransfer(Maps.BLACKSMITH, 13, 12, Direction.UP, 0, true);
    }, 18);
  }

  static doViktorDoor() {
    if ($gamePlayer.isRiding()) {
      return;
    }

    if (Managers.Villagers.isVillagerScheduledAtMap('Richard', Maps.BLACKSMITH_ROOMS)) {
      Managers.CommonEvent.playEvent('richard_leave_house');
    } else if (Managers.Villagers.isVillagerScheduledAtMap('Viktor', Maps.BLACKSMITH_ROOMS)) {
      Managers.CommonEvent.playEvent('viktor_leave_house');
    } else if (Managers.Time.isBetweenTimes('08:00', '14:59')) {
      Managers.CommonEvent.playEvent('viktor_door_sign');
    } else {
      Managers.CommonEvent.playEvent('door_unanswered');
    }
  }

  static doBlacksmithDoor() {
    if ($gamePlayer.isRiding()) {
      return;
    }

    if (Managers.Time.isBetweenTimes('08:00', '14:59')) {
      this.enterBlacksmith();
      return;
    }

    Managers.CommonEvent.playEvent('blacksmith_chain');
  }

  static enterClinic() {
    Switches.waitingForTransfer = true;
    $gameMap._interpreter.doDoorAnimation();
    $gameTemp.setTimeout(() => {
      $gamePlayer.reserveTransfer(Maps.CLINIC, 7, 11, Direction.UP, 0, true);
    }, 18);
  }

  static doClinicDoor() {
    if ($gamePlayer.isRiding()) {
      return;
    }

    if ($gamePlayer.isRiding()) {
      return;
    }

    if (Managers.Time.isBetweenTimes('09:45', '18:59')) {
      this.enterClinic();
      return;
    }

    if (Managers.Villagers.isVillagerScheduledAtMap('Phi', Maps.CLINIC)) {
      Managers.CommonEvent.playEvent('phi_leave_house');
    } else if (Managers.Villagers.isVillagerScheduledAtMap('Bonnie', Maps.CLINIC)) {
      Managers.CommonEvent.playEvent('bonnie_leave_house');
    } else {
      Managers.CommonEvent.playEvent('door_unanswered');
    }
  }

  static enterCityHall() {
    Switches.waitingForTransfer = true;
    $gameMap._interpreter.doDoorAnimation();
    $gameTemp.setTimeout(() => {
      $gamePlayer.reserveTransfer(Maps.CITY_HALL, 12, 19, Direction.UP, 0, true);
    }, 18);
  }

  static doCityHallDoor() {
    if ($gamePlayer.isRiding()) {
      return;
    }

    if (Managers.Time.isBetweenTimes('08:45', '15:59')) {
      OrangeTownMap.enterCityHall();
      return;
    }
    
    if (Managers.Villagers.isVillagerScheduledAtMap('Julia', Maps.CITY_HALL)) {
      Managers.CommonEvent.playEvent('julia_leave_house');
    } else {
      Managers.CommonEvent.playEvent('door_unanswered');
    }
  }

  static doLucasDoor() {
    if ($gamePlayer.isRiding()) {
      return;
    }

    if (Managers.Villagers.isVillagerScheduledAtMap('Lucas', Maps.LUCAS_HOUSE)) {
      Managers.CommonEvent.playEvent('lucas_leave_house');
    } else {
      Managers.CommonEvent.playEvent('door_unanswered');
    }
  }

  static doRestaurantDoor() {
    if (Switches.isInsideFestival) return;
    if ($gamePlayer.isRiding()) {
      return;
    }


    if (Managers.Time.hour < 9) {
      Managers.CommonEvent.playEvent('restaurant_door_locked');
      return;
    }

    if (Managers.Time.hour >= 21) {
      // if (Managers.Time.dayName !== 'friday' && Managers.Time.dayName !== 'saturday') {
      Managers.CommonEvent.playEvent('restaurant_door_locked2');
      return;      
      // }
    }

    Switches.waitingForTransfer = true;
    $gameMap._interpreter.doDoorAnimation();
    $gameTemp.setTimeout(() => {
      $gamePlayer.reserveTransfer(Maps.RESTAURANT, 10, 18, Direction.UP, 0, true);
    }, 18);
  }

  static doGabrielDoor() {
    if ($gamePlayer.isRiding()) {
      return;
    }

    if (Managers.Villagers.isVillagerScheduledAtMap('Gabriel', Maps.GABRIELS_HOUSE)) {
      Managers.CommonEvent.playEvent('gabriel_leave_house');
    } else {
      Managers.CommonEvent.playEvent('door_unanswered');
    }
  }

  static doAmandaDoor() {
    if ($gamePlayer.isRiding()) {
      return;
    }

    if (Managers.Villagers.isVillagerScheduledAtMap('Amanda', Maps.AMANDAS_HOUSE)) {
      Managers.CommonEvent.playEvent('amanda_leave_house');
    } else {
      Managers.CommonEvent.playEvent('door_unanswered');
    }
  }

  static doIldaDoor() {
    if ($gamePlayer.isRiding()) {
      return;
    }

    if (Managers.Villagers.isVillagerScheduledAtMap('Ilda', Maps.ILDAS_HOUSE)) {
      Managers.CommonEvent.playEvent('ilda_leave_house');
    } else {
      Managers.CommonEvent.playEvent('door_unanswered');
    }
  }

  static enterRoryHouse() {
    Switches.waitingForTransfer = true;
    $gameMap._interpreter.doDoorAnimation();
    $gameTemp.setTimeout(() => {
      $gamePlayer.reserveTransfer(Maps.RORYS_FARM, 5, 9, Direction.UP, 0, true);
    }, 18);
  }

  static doRoryDoor() {
    if ($gamePlayer.isRiding()) {
      return;
    }

    if (Managers.Time.isBetweenTimes('11:00', '17:00')) {
      OrangeTownMap.enterRoryHouse();
      return;
    }

    if (Managers.Villagers.isVillagerScheduledAtMap('Billy', Maps.RORYS_FARM)) {
      Managers.CommonEvent.playEvent('billy_leave_house');
    } else if (Managers.Villagers.isVillagerScheduledAtMap('Cindy', Maps.RORYS_FARM)) {
      Managers.CommonEvent.playEvent('cindy_leave_house');
    } else if (Managers.Villagers.isVillagerScheduledAtMap('Rory', Maps.RORYS_FARM)) {
      Managers.CommonEvent.playEvent('rory_leave_house');
    } else {
      Managers.CommonEvent.playEvent('door_unanswered');
    }
  }

  static doDukeDoor() {
    if ($gamePlayer.isRiding()) {
      return;
    }

    if (Managers.Villagers.isVillagerScheduledAtMap('Duke', Maps.DUKES_HOUSE)) {
      Managers.CommonEvent.playEvent('duke_leave_house');
    } else if (Managers.Villagers.isVillagerScheduledAtMap('Gary', Maps.DUKES_HOUSE)) {
      Managers.CommonEvent.playEvent('gary_leave_house');
    } else {
      Managers.CommonEvent.playEvent('door_unanswered');
    }
  }

  static doKarlDoor() {
    if ($gamePlayer.isRiding()) {
      return;
    }

    if (Managers.Villagers.isVillagerScheduledAtMap('Karl', Maps.KARLS_HOUSE)) {
      Managers.CommonEvent.playEvent('karl_leave_house');
    } else {
      Managers.CommonEvent.playEvent('door_unanswered');
    }
  }

  static doMiaDoor() {
    if ($gamePlayer.isRiding()) {
      return;
    }

    if ($gamePlayer.isRiding()) {
      return;
    }

    if (Managers.Villagers.isVillagerScheduledAtMap('Mia', Maps.MIAS_HOUSE)) {
      Managers.CommonEvent.playEvent('mia_leave_house');
    } else {
      Managers.CommonEvent.playEvent('door_unanswered');
    }
  }

  static onChangeMinute() {
    $gameMap.updateDoorsState();
  }

  static createBoardEvents() {
    const event = $gameMap.createMultiSpriteActionEventAt(56, 25, [
      {
        characterName: 'objects/$signs_wide',
        characterIndex: 0,
        direction: 2,
        pattern: 2,
        condition: {
          variableName: 'month',
          value: 1
        }
      },
      {
        direction: 4,
        condition: {
          variableName: 'month',
          value: 2
        }
      },
      {
        direction: 6,
        condition: {
          variableName: 'month',
          value: 3
        }
      },
      {
        direction: 8,
        condition: {
          variableName: 'month',
          value: 4
        }
      }
    ], 'check_festival_board', 1, Objects.CustomStaticEvent);

    event._metaOffsetX = 16;
    event._metaOffsetY = 16;
    event._hitboxX = 0.5;
    event._hitboxY = 0.5;


    const requestsEvent = $gameMap.createMultiSpriteActionEventAt(43, 38, [
      {
        characterName: 'objects/$signs_wide',
        characterIndex: 0,
        direction: 4,
        pattern: 0,
        condition: {
          variableName: 'customTaskCount',
          value: 0
        }
      },
      {
        direction: 6,
        condition: {
          variableName: 'customTaskCount',
          value: 1
        }
      },
      {
        direction: 8,
        condition: {
          variableName: 'customTaskCount',
          value: 2
        }
      },
      {
        direction: 4,
        pattern: 1,
        condition: {
          variableName: 'customTaskCount',
          value: 3
        }
      },
      {
        direction: 6,
        condition: {
          variableName: 'customTaskCount',
          value: 4
        }
      },
    ], 'check_taskboard', 1, Objects.CustomStaticEvent);

    requestsEvent._metaOffsetY = -16;
    requestsEvent._metaOffsetX = 16;
    requestsEvent._hitboxY = -0.5;
    requestsEvent._hitboxX = 0.5;
  }
}

Managers.Map.registerMapClass(Maps.ORANGE_TOWN, OrangeTownMap);
module.exports = OrangeTownMap;