class RestaurantMap {
  static checkTeleports() {
    if ($gamePlayer.top > 19 && $gamePlayer.left >= 10 && $gamePlayer.left < 12) {
      $gamePlayer.reserveTransfer(Maps.ORANGE_TOWN, 41, 38, Direction.DOWN, 0, true);
      return;
    }

    if ($gamePlayer.y < 9.5 && $gamePlayer.left >= 18 && $gamePlayer.right <= 20) {
      const x = $gamePlayer.x + 1;
      $gamePlayer.reserveTransfer(Maps.INN, x.clamp(19, 20), 8, Direction.UP, 0, true);
      return;
    }
  }

  static removeChairForVillager(villagerName, x, y) {
    const villagerIsHere = Managers.Villagers.wasVillagerScheduledAtMap(villagerName, Maps.RESTAURANT);
    if (!villagerIsHere) {
      return;
    }

    for (let event of $gameMap._events) {
      if (!event || event._erased || event.x !== x || event.y !== y) {
        continue;
      }

      const data = event.event && event.event();
      if (!data) {
        continue;
      }

      if (data.name !== 'chair') {
        continue;
      }

      event.erase();
    }
  }

  static setupMapEvents() {
    this.removeChairForVillager('Ilda', 12, 19);
    this.removeChairForVillager('Annie', 13, 14);
    this.removeChairForVillager('Raphael', 1, 12);
    this.removeChairForVillager('Phi', 1, 15);
    this.removeChairForVillager('Richard', 3, 15);
    this.removeChairForVillager('Nathalia', 8, 16);
    this.removeChairForVillager('Serge', 4, 17);
    this.removeChairForVillager('Duke', 17, 17);
  }

  static isAvailableArea() {
    return true;
  }

  static isZoomOutEnabled() {
    return false;
  }
}

Managers.Map.registerMapClass(Maps.RESTAURANT, RestaurantMap);