class NewFestivalAreaMap {
  static update() {
    if ($gameMessage.isBusy()) return;

    if (!!this._festivalEndDelay && this._festivalEndDelay > 0) {
      this._festivalEndDelay--;
      return;
    }
  }

  static confirmFestivalEnd() {
    if (Switches.isFestivalEnding) {
      Managers.CommonEvent.playEvent('leave_festival');
      return;
    }

    if ($gameMessage.isBusy()) return;

    this._festivalEndDelay = 30;
    Managers.CommonEvent.playEvent('confirm_festival_end');
  }

  static checkTeleports() {
    if ($gamePlayer.top >= 34) {
      if (Switches.isInsideFestival) {
        this.confirmFestivalEnd();
        return;
      }

      $gamePlayer.reserveTransfer(Maps.ORANGE_TOWN, 34, 2, Direction.DOWN, 0, false, true);
    }
  }

  static getHeightLevel(x, y) {
    return 0;
  }

  static isAvailableArea() {
    return true;
  }
}

Managers.Map.registerMapClass(Maps.FESTIVAL_RECEPTION, NewFestivalAreaMap);