class GeneralStoreMap {
  static checkTeleports() {
    if ($gamePlayer.y >= 16) {
      $gamePlayer.reserveTransfer(Maps.ORANGE_TOWN, 5, 39, Direction.DOWN, 0, true);
      return;
    }
  }

  static setupMapEvents() {
    if (!Switches.gotFirstBag) {
      $gameMap.createStoreSwitchObjectEventAt(Switches._gotFirstBag, 'bag', 15, 13).offsetY = -5;
    } else {
      if (!Switches.gotSecondBag && Switches.canSellSuperBag) {
        $gameMap.createStoreSwitchObjectEventAt(Switches._gotSecondBag, 'super-bag', 15, 13).offsetY = -5;
      }
    }

    if (!Switches.hasMilker) {
      const milker = $gameMap.createStoreSwitchObjectEventAt(Switches._hasMilker, 'milker', 14, 13);
      milker.offsetX = 6;
      milker.offsetY = -5;
    }

    if (!Switches.hasClippers) {
      const clippers = $gameMap.createStoreSwitchObjectEventAt(Switches._hasClippers, 'clippers', 14, 14);
      clippers.offsetX = 6;
      clippers.offsetY = 2;
    }

    if (!Switches.hasMagnifier) {
      const magnifier = $gameMap.createStoreSwitchObjectEventAt(Switches._hasMagnifier, 'magnifier', 14, 15);
      magnifier.offsetX = 8;
      magnifier.offsetY = 5;
    }

    const addObject = (name, x, y, offsetX, offsetY) => {
      const obj = $gameMap.createActionItemEventAt(name, x, y, 'store_shelf');
      if (obj) {
        obj.offsetX = offsetX;
        obj.offsetY = offsetY;
      }
    };

    addObject('condensed-milk', 6, 9, 2, -2 );
    addObject('condensed-milk', 7, 9, -2, -2 );
    addObject('condensed-milk', 6, 10, 2, -6 );
    addObject('condensed-milk', 7, 10, -2, -6 );

    addObject('cereal-box', 8, 9, 2, -4 );
    addObject('cereal-box', 9, 9, -3, -4 );
    addObject('cereal-box', 8, 10, 2, -8 );
    addObject('cereal-box', 9, 10, -3, -8 );

    addObject('honey', 10, 9, 3, -3 );
    addObject('honey', 11, 9, -2, -3 );
    addObject('honey', 10, 10, 3, -6 );
    addObject('honey', 11, 10, -2, -6 );

    addObject('vinegar', 6, 5, 3, -3 );
    addObject('vinegar', 7, 5, -2, -3 );
    addObject('vinegar', 6, 6, 3, 1 - 8 );
    addObject('vinegar', 7, 6, -2, 1 - 8 );

    addObject('vinegar', 8, 5, 3, -3 );
    addObject('vinegar', 9, 5, -2, -3 );
    addObject('oil', 8, 6, 3, -6 );
    addObject('oil', 9, 6, -2, -6 );

    addObject('oil', 10, 5, 3, -3 );
    addObject('oil', 11, 5, -2, -3 );
    addObject('oil', 10, 6, 3, -6 );
    addObject('oil', 11, 6, -2, -6 );

    // $gameMap.createStoreObjectEventAt('sugar', 12, 5).offsetY = 8;
    const bread = $gameMap.createStoreObjectEventAt('bread', 13, 5);
    bread.hitboxHeight = 1.25;

    const addCrops = (crop1, crop2, crop3, crop4, crop5, crop6) => {
      $gameMap.createActionItemEventAt(crop1, 14, 8, 'crop_shop').offsetY = -6;
      $gameMap.createActionItemEventAt(crop2, 14, 9, 'crop_shop').offsetY = -6;
      $gameMap.createActionItemEventAt(crop3, 14, 10, 'crop_shop').offsetY = -6;
      $gameMap.createActionItemEventAt(crop4 || crop1, 15, 8, 'crop_shop').offsetY = -6;
      $gameMap.createActionItemEventAt(crop5 || crop2, 15, 9, 'crop_shop').offsetY = -6;
      $gameMap.createActionItemEventAt(crop6 || crop3, 15, 10, 'crop_shop').offsetY = -6;
    };

    let crops;
    switch(Managers.Time.month) {
      case Seasons.SPRING:
        crops = ['turnip', 'cucumber', 'potato'];

        if (Switches.canBuyStrawberrySeeds) {
          crops.push('strawberry');
        }

        addCrops(...crops);
        break;
      case Seasons.SUMMER:
        crops = ['onion', 'corn', 'tomato'];

        if (Switches.canBuyChillipepperSeeds) {
          crops.push('chillipepper');
        }

        if (Switches.canBuyCassavaSeeds) {
          crops.push('cassava');
        }

        if (Switches.canBuyGrapeSeeds) {
          crops.push('grape');
        }

        if (Switches.canBuyWatermelonSeeds) {
          crops.push('watermelon');
        }

        addCrops(...crops);
        break;
      case Seasons.FALL:
        crops = ['carrot', 'eggplant', 'sweet-potato'];

        if (Switches.canBuyBeetSeeds) {
          crops.push('beet');
        }

        if (Switches.canBuyBroccoliSeeds) {
          crops.push('broccoli');
        }

        if (Switches.canBuyPumpkinSeeds) {
          crops.push('pumpkin');
        }

        if (Switches.canBuySpinachSeeds) {
          crops.push('spinach');
        }

        if (Switches.canBuyRadishSeeds) {
          crops.push('radish');
        }

        if (Switches.canBuyBellpepperSeeds) {
          crops.push('bellpepper');
        }

        if (Switches.canBuyPeanutSeeds) {
          crops.push('peanut');
        }

        addCrops(...crops);
        break;
      case Seasons.WINTER:
        addCrops('lettuce', 'leek', 'cauliflower');
        break;
    }

    $gameMap.createEventCallAt(8, 13, 'seed_shop');
    $gameMap.createEventCallAt(9, 13, 'seed_shop');
    $gameMap.createEventCallAt(10, 13, 'seed_shop');
    $gameMap.createEventCallAt(11, 13, 'seed_shop');

    // $gameMap.createStoreObjectEventAt('peanut-butter', 11, 13);

    // $gameMap.createStoreObjectEventAt('food-bowl', 11, 8).offsetY = 10;
    // $gameMap.createStoreObjectEventAt('ball', 12, 8).offsetY = 10;

    // $gameMap.createStoreObjectEventAt('butter', 15, 7);    
  }

  static isAvailableArea() {
    return true;
  }

  static isZoomOutEnabled() {
    return false;
  }
}

Managers.Map.registerMapClass(Maps.GENERAL_STORE, GeneralStoreMap);