function BeachMap() {
}

BeachMap.checkTeleports = function() {
  if ($gamePlayer.bottom <= 1) {
    $gamePlayer.reserveTransfer(Maps.PETTING_ZOO, 18, 48, Direction.UP, 0, true);
    return;
  }
};

BeachMap.getHeightLevel = function(x, y) {
  return 0;
};

BeachMap.isAvailableArea = function() {
  return true;
};

BeachMap.updateFishes = function() {
  const { hour, minute } = Managers.Time;

  const smallFish = Managers.Fishing.getRandomFishId('small', Maps.BEACH);
  const mediumFish = Managers.Fishing.getRandomFishId('medium', Maps.BEACH);
  const bigFish = Managers.Fishing.getRandomFishId('big', Maps.BEACH);

  switch(minute) {
    case 0:
      if (hour % 3 === 1) {
        Managers.Fishing.addRandomItem(['shrimp', 'crab', 'blue-can', 'green-can'], 7, 20, 10, 35);
      }
      Managers.Fishing.addFishToMap(14, 27, smallFish, 20, 8, 8);
      
      break;
    case 1:
      Managers.Fishing.addFishToMap(15, 22, smallFish, 20, 4, 13);
      break;
    case 2:
      if (hour % 3 === 0) {
        if (Math.randomInt(2) == 1) {
          Managers.Fishing.addFishToMap(5, 24, mediumFish, 20, 6, 9);
        }
      }
      break;
    case 3:
      Managers.Fishing.addFishToMap(7, 28, smallFish, 20, 8, 8);

      // Level 3
      Managers.Fishing.addFishToMap(16, 27, bigFish, 60, 8, 7);
      break;
    case 4:
      if (hour % 2 == 1) {
        Managers.Fishing.addFishToMap(3, 23, smallFish, 20, 6, 7);
      }
      break;
    case 5:
      if (hour % 3 === 2) {
        Managers.Fishing.addRandomItem(['seaweed', 'seashell', 'clam', 'blue-can', 'green-can'], 14, 20, 10, 100);
      } else if (hour % 3 == 1) {
        Managers.Fishing.addRandomItem(['seaweed', 'seashell', 'clam', 'blue-can', 'green-can'], 23, 18, 10, 100);
      }
      break;
  }
};

BeachMap.setupMapEvents = function() {
  $gameTemp.setTimeout(BeachMap.updateSeagulls, 120, true);
};

BeachMap.updateSeagulls = function() {
  if ($gameMap._mapId !== Maps.BEACH) {
    return;
  }

  BeachMap.removeOutOfScreenSeagulls();

  switch (Math.randomInt(10)) {
    default:
      $gameMap.createSeagullEventAt(29, 17 + Math.randomInt(8), Direction.LEFT);
      $gameTemp.setTimeout(BeachMap.updateSeagulls, 360, true);
      break;
    case 1:
      $gameMap.createSeagullEventAt(29, 19, Direction.LEFT);

      $gameTemp.setTimeout(() => {
        $gameMap.createSeagullEventAt(29, 18, Direction.LEFT);
        $gameMap.createSeagullEventAt(29, 20, Direction.LEFT);

        $gameTemp.setTimeout(() => {
          $gameMap.createSeagullEventAt(29, 17, Direction.LEFT);
          $gameMap.createSeagullEventAt(29, 21, Direction.LEFT);

          $gameTemp.setTimeout(BeachMap.updateSeagulls, 600, true);
        }, 30, true);
      }, 30, true);

      break;
    case 2:
      $gameTemp.setTimeout(BeachMap.updateSeagulls, 120, true);
      break;
    case 3:
      $gameTemp.setTimeout(BeachMap.updateSeagulls, 60, true);
      break;
    case 4:
      $gameTemp.setTimeout(BeachMap.updateSeagulls, 180, true);
      break;
  }
};

BeachMap.removeOutOfScreenSeagulls = function() {
  // Erase any seagull who reached the end of the screen
  const events = $gameMap._events.filter(event => !!event && !event._erased && event.name === 'seagull' && !event.isMoving());
  for (let event of events) {
    event.erase();
  }
};

BeachMap.isZoomOutEnabled = function() {
  return true;
};

Managers.Map.registerMapClass(Maps.BEACH, BeachMap);