class MountainTopMap {
  static checkTeleports() {
    if (!$gamePlayer.isRiding()) {
      if ($gamePlayer.right < 19 && $gamePlayer.left > 16 && $gamePlayer.bottom <= 5) {
        $gamePlayer.reserveTransfer(Maps.GOLD_MINE, 57, 33, Direction.UP, 0, true);
        return;
      }
    }

    if ($gamePlayer.left >= 55 && $gamePlayer.top >= 19) {
      $gamePlayer.reserveTransfer(Maps.MOUNTAIN, $gamePlayer.x, 2, $gamePlayer._direction, 0, true);
      return;
    }

    if ($gamePlayer.left >= 17 && $gamePlayer.right <= 18 && $gamePlayer.top >= 19) {
      $gamePlayer.reserveTransfer(Maps.MOUNTAIN, $gamePlayer.x, 3, $gamePlayer._direction, 0, true);
      return;
    }
  }

  static getHeightLevel(x, y) {
    //Right side
    if (x > 64) {
      if (y >= 11) return 15;
      if (y >= 10) return 16;
      if (y >= 9) return 17;
    }

    return 18;
  }

  static setupMapEvents() {
    MountainTopMap.beaverEventId = 3;
    if (Math.randomInt(5) == 2) {
      MountainTopMap.changeBeaverState('A');
    } else {
      MountainTopMap.changeBeaverState();
    }

    // Show objects from the adjacent map on the bottom row
    Managers.FarmObjects.createAnotherMapEvents(Maps.MOUNTAIN, { bottom: 3 }, { y : 19 });


    // Waterfalls
    $gameMap.addSoundSource(45, 20, 'WaterLoop');
    // Moving Water
    $gameMap.addSoundSource(48, 12, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(34, 13, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(34, 13, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(23, 14, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(11, 13, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(5, 6, 'WaterLoop', 0.4);
  }

  static changeBeaverState(enabledSwitch) {
    $gameSelfSwitches.setValue([Maps.MOUNTAIN_TOP, this.beaverEventId, 'A'], false);
    $gameSelfSwitches.setValue([Maps.MOUNTAIN_TOP, this.beaverEventId, 'B'], false);
    $gameSelfSwitches.setValue([Maps.MOUNTAIN_TOP, this.beaverEventId, 'C'], false);

    if (enabledSwitch == 'A' || enabledSwitch == 'B' || enabledSwitch == 'C') {
      $gameSelfSwitches.setValue([Maps.MOUNTAIN_TOP, this.beaverEventId, enabledSwitch], true);
    }
  }

  static isAvailableArea() {
    return true;
  }

  static update() {
    MountainTopMap.checkBeaver();
  }

  static checkBeaver() {
    if ($gameSelfSwitches.value([Maps.MOUNTAIN_TOP, this.beaverEventId, 'A'])) {
      if ($gamePlayer.y <= 12 && $gamePlayer.x >= 31 && $gamePlayer.x <= 41) {
        $gameMap.event(this.beaverEventId)._waitCount = 0;
        this.changeBeaverState('B');
      }
    }
  }

  static updatePlayerSpritePosition(sprite) {
    if (sprite._character.isTouchingRegion(Region.BRIDGE)) {
      sprite.y -= 3;
      sprite.zOrder += 3;
    }
  }

  static updateFishes() {
    const { hour, minute } = Managers.Time;
    const mod4 = hour % 4;

    if (!Utils.chance(50)) {
      return;
    }

    const smallFish = Managers.Fishing.getRandomFishId('small', Maps.MOUNTAIN_TOP);
    const mediumFish = Managers.Fishing.getRandomFishId('medium', Maps.MOUNTAIN_TOP);
    const bigFish = Managers.Fishing.getRandomFishId('big', Maps.MOUNTAIN_TOP);

    switch(mod4) {
      case 0:
        switch (minute) {
          case 0:
            if (Utils.chance(50)) {
              // Level 2
              Managers.Fishing.addFishToMap(47, 11, mediumFish, 40, 6, 3);
            }
            break;
          case 2:
            Managers.Fishing.addFishToMap(49, 15, smallFish, 30, 8, 5);
            break;
          case 4:
            Managers.Fishing.addFishToMap(41, 15, smallFish, 20, 4, 8);
            break;
        }

        break;
      case 1:
        switch (minute) {
          case 0:
            Managers.Fishing.addFishToMap(50, 9, smallFish, 10, 6, 2);
            break;
          case 2:
            Managers.Fishing.addFishToMap(28, 11, smallFish, 70, 6, 9);
            break;
          case 4:
            Managers.Fishing.addFishToMap(24, 13, smallFish, 20, 6, 8);
            break;
        }
        break;
      case 2:
        switch (minute) {
          case 0:
            Managers.Fishing.addFishToMap(20, 13, smallFish, 20, 6, 4);
            break;
          case 2:
            if (Utils.chance(50)) {
              // Level 2
              Managers.Fishing.addFishToMap(36, 12, mediumFish, 40, 4, 7);
            }
            break;
          case 4:
            Managers.Fishing.addFishToMap(44, 12, smallFish, 20, 4, 8);
            break;
        }
        break;
      case 3:
        switch (minute) {
          case 0:
            Managers.Fishing.addFishToMap(33, 11, smallFish, 30, 2, 4);
            break;
          case 1:
            if (Utils.chance(15)) {
              // Level 3
              Managers.Fishing.addFishToMap(37, 13, bigFish, 25, 4, 4);
            }
            break;
          case 2:
            if (Utils.chance(15)) {
              // Level 3
              Managers.Fishing.addFishToMap(44, 14, bigFish, 20, 6, 3);
            }
            break;
          case 3:
            if (Utils.chance(15)) {
              // Level 3
              Managers.Fishing.addFishToMap(47, 12, bigFish, 5, 2, 1);
            }
            break;
          case 4:
            Managers.Fishing.addFishToMap(12, 12, smallFish, 20, 4, 6);
            break;
          case 5:
            Managers.Fishing.addFishToMap(0, 4, smallFish, 20, 6, 4);
            break;
        }
        break;
    }
  }
}

Managers.Map.registerMapClass(Maps.MOUNTAIN_TOP, MountainTopMap);