class MountainMap {
  static checkTeleports() {
    if ($gamePlayer.left >= 70 && $gamePlayer.bottom >= 71 && $gamePlayer.top < 75) {
      $gamePlayer.reserveTransfer(Maps.ORANGE_TOWN, 1, $gamePlayer.y - 26, $gamePlayer._direction, 0, true);
      return;
    }

    if ($gamePlayer.top >= 76 && $gamePlayer.left > 35 && $gamePlayer.right < 39) {
      $gamePlayer.reserveTransfer(Maps.FARM, $gamePlayer.x - 30, 1, $gamePlayer._direction, 0, true);
      return;
    }

    if ($gamePlayer.left >= 65 && $gamePlayer.bottom <= 1) {
      $gamePlayer.reserveTransfer(Maps.MOUNTAIN_TOP, $gamePlayer.x, 18, $gamePlayer._direction, 0, true);
      return;
    }

    if ($gamePlayer.left >= 17 && $gamePlayer.right <= 18 && $gamePlayer.bottom <= 1) {
      $gamePlayer.reserveTransfer(Maps.MOUNTAIN_TOP, $gamePlayer.x, 18, $gamePlayer._direction, 0, true);
      return;
    }

    if (!$gamePlayer.isRiding()) {
      if ($gamePlayer.left > 33 && $gamePlayer.left < 35 && $gamePlayer.top >= 68.5 && $gamePlayer.top < 69.5) {
        $gamePlayer.reserveTransfer(Maps.MAIN_MINE, 57, 71, Direction.UP, 0, true);
        return;
      }

      if ($gamePlayer.left > 7 && $gamePlayer.right < 9 && $gamePlayer.top >= 61 && $gamePlayer.top < 62) {
        $gamePlayer.reserveTransfer(Maps.TRAIN_STATION_CAVE, 57, 33, Direction.UP, 0, true);
        return;
      }

      if ($gamePlayer.left > 6 && $gamePlayer.left < 8 && $gamePlayer.top >= 46 && $gamePlayer.top < 47) {
        $gamePlayer.reserveTransfer(Maps.MOUNTAIN_S_SMALL_CAVE, 16, 15, Direction.UP, 0, true);
        return;
      }

      if ($gamePlayer.right > 37 && $gamePlayer.left < 39 && $gamePlayer.top <= 2.5) {
        $gamePlayer.reserveTransfer(Maps.SMALL_CAVE, 15, 15, Direction.UP, 0, true);
        return;
      }

      if ($gamePlayer.right > 40 && $gamePlayer.left < 42 && $gamePlayer.top <= 9.5 && $gamePlayer.top > 8) {
        $gamePlayer.reserveTransfer(Maps.CAVE_FARM, 10, 17, $gamePlayer._direction, 0, true);
        return;
      }
    }
  }

  static getHeightLevel(x, y) {
    //bottom
    if (y >= 71) return 0;

    //Right side
    if (x >= 64) {
      if (y >= 37) return 0;
      if (y >= 36) return 1;
      if (y >= 35) return 2;
      if (y >= 31) return 3;
      if (y >= 30) return 4;
      if (y >= 29) return 5;
      if (y >= 24) return 6;
      if (y >= 23) return 7;
      if (y >= 22) return 8;
      if (y >= 18) return 9;
      if (y >= 17) return 10;
      if (y >= 16) return 11;
      if (y >= 6) return 12;
      if (y >= 5) return 13;
      if (y >= 4) return 14;
      return 15;
    }

    if (x >= 44) {
      if (y >= 70) return 1;
      if (y >= 69) return 2;
      if (y >= 52) return 3;
    }

    if (y >= 69) return 1;
    if (y >= 68) return 2;

    if (y >= 64) {
      // 63,64 = 0
      if (y < 65 && x >= 63) return 0;

      return 3;
    }

    if (y <= 7) return 15;

    if (y <= 15) {
      if (x >= 23 && x < 28) return 15;

      if (y < 11) {
        if (x >= 10 && x < 15) return 15;
      }

      if (y <= 8) return 14;
      if (y <= 9) return 13;

      if (y == 15 && x == 18) return 11;
      return 12;
    }

    if (x == 18) {
      if (y == 16) return 10;
      if (y == 17) return 9;
    }

    if (y <= 18) {
      if (x >= 16 && x <= 20) return 9;
      return 12;
    }

    if (y <= 20 && x <= 5) {
      if (y == 19) return 11;
      return 10;
    }

    if (y <= 24) return 9;

    //Right side level 2
    if (x >= 58) {
      if (y <= 25) return 9;
      if (y <= 53) return 3;

      if (x >= 61 && y < 59) return 0;
      if (x == 63 && y < 65) return 0;

      return 3;
    }

    // Camping area
    if (x >= 42 && y <= 42) return 6;
    if (x >= 37 && y <= 35) return 9;
    if (y <= 27) return 9;

    if (x <= 30 && y <= 41) return 9;
    if (x <= 16 && y <= 43) return 9;

    if (y <= 28) return 8;
    if (y <= 29) return 7;
    if (y <= 41) return 6;

    if (x >= 45) {
      if (y <= 42) return 6;
      if (y <= 43) return 5;
      if (y <= 43) return 4;

      return 3;
    }

    if (x >= 36 && y >= 50) return 3;
    if (x == 42 && y == 49) return 3;
    if (x >= 38) return 6;
    if (x >= 33) return 3;

    if (x >= 19) {
      if (y <= 45) return 6;
      if (y <= 46) return 5;
      if (y <= 47) return 4;

      return 3;
    }

    if (x == 18 && y >= 54) return 3;
    if (x >= 17) return 6;

    if (x == 14) {
      if (y == 46) return 7;
      if (y == 45) return 8;
    }
    if (y <= 44) return 9;
    if (x <= 2) return 9;

    if (x == 15) {
      if (y == 62) return 4;
      if (y == 63) return 5;
    }

    if (x >= 6) {
      if (y <= 61) return 6;
    }

    if (x < 6) {
      if (y < 49) return 9;
      return 6;
    }

    return 3;
  }

  static setupMapEvents() {
    // Waterfalls
    $gameMap.addSoundSource(40, 69, 'WaterLoop');
    $gameMap.addSoundSource(24, 47, 'WaterLoop');
    $gameMap.addSoundSource(23, 41, 'WaterLoop');
    $gameMap.addSoundSource(53, 18, 'WaterLoop');
    $gameMap.addSoundSource(45, 9, 'WaterLoop');
    $gameMap.addSoundSource(45, 3, 'WaterLoop');

    // Moving water
    $gameMap.addSoundSource(41, 60, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(37, 56, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(47, 56, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(22, 58, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(7, 28, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(19, 25, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(35, 22, 'WaterLoop', 0.4);

  }

  static setupDailyItems() {
    const mapId = Maps.MOUNTAIN;
    const month = Managers.Time.month;
    const eraseTile = Managers.FarmObjects.eraseFarmObjectsXy.bind(Managers.FarmObjects, mapId);
    const createItem = Managers.FarmObjects.createItemAt.bind(Managers.FarmObjects, mapId);

    const addItem = function(x, y, itemId, condition) {
      eraseTile(x, y);
      if (condition === undefined || condition) {
        if (Array.isArray(itemId)) {
          var idx = Math.randomInt(itemId.length);
          return createItem(x, y, itemId[idx]);
        } else {
          return createItem(x, y, itemId);
        }
      }
    };

    const rng = Math.randomInt(10);

    switch(month) {
      case Seasons.SPRING:
        // Only add the honeycomb on sunny days
        addItem(14, 27, 'honeycomb', !Managers.Weather.isBadWeather());
        addItem(35, 46, 'honeycomb', !Managers.Weather.isBadWeather() && rng >= 5);
        addItem(68, 55, 'honeycomb', !Managers.Weather.isBadWeather() && rng >= 2 && rng <= 5);

        addItem(42, 49, ['cherry', 'peach']);

        break;
      case Seasons.SUMMER:
        addItem(42, 49, ['banana', 'coconut']);
        break;

      case Seasons.FALL:
        addItem(42, 49, ['plum', 'chestnut']);
        break;

      case Seasons.WINTER:
        addItem(42, 49, ['persimmon', 'starfruit']);
        break;
    }  
  }

  static isAvailableArea() {
    return true;
  }

  static update() {
    this.checkLizard();
  }

  static checkLizard() {
    if (Switches.playedMountainLizard) return;
    if ($gamePlayer.top < 49) return;
    if ($gamePlayer.top > 51) return;
    if ($gamePlayer.left < 47) return;
    if ($gamePlayer.left > 55) return;
    if ($gamePlayer._direction !== Direction.UP) return;

    Switches.playedMountainLizard = true;
    let timeout = 300;

    if (Math.randomInt(10) == 5) {
      Managers.CommonEvent.playEventAsync('lizard_running_map_2_async');
      timeout = 3000;
    }

    $gameTemp.setTimeout(() => {
      Switches.playedMountainLizard = false;
    }, timeout, true);
  }

  static updatePlayerSpritePosition(sprite) {
    if (sprite._character.isTouchingRegion(Region.BRIDGE)) {
      sprite.y -= 3;
      sprite.zOrder += 3;
    }
  }

  static updateFishingItemsLowerWaterfall() {
    if (Managers.Time.minute !== 0) return;

    const hour = Managers.Time.hour;

    // At midnight, there's a chance of getting a blue crystal
    if (hour === 0 && Utils.chance(30)) {
      Managers.Fishing.addFishToMap(40, 70, 'blue-crystal', 1, 0, 0, 100, true);
      return;
    }

    // At 4AM, there's a chance of getting a white crystal
    if (hour === 4 && Utils.chance(15)) {
      Managers.Fishing.addFishToMap(40, 70, 'white-crystal', 1, 0, 0, 100, true);
      return;
    }

    // Every four hours, there's a chance of a good item
    if (hour % 4 === 0 && Utils.chance(40)) {
      Managers.Fishing.addRandomGoodItem(40, 70, 1, 100);
      return;
    }

    Managers.Fishing.addRandomBadItem(40, 70, 1, 100);
  }

  static updateFishes() {
    const { hour, minute, month } = Managers.Time;
    const mod4 = hour % 4;

    if (!Utils.chance(50)) {
      return;
    }

    const smallFish = Managers.Fishing.getRandomFishId('small', Maps.MOUNTAIN);
    const mediumFish = Managers.Fishing.getRandomFishId('medium', Maps.MOUNTAIN);
    const bigFish = Managers.Fishing.getRandomFishId('big', Maps.MOUNTAIN);

    switch(mod4) {
      case 0:
        switch(minute) {
          case 0:
            Managers.Fishing.addFishToMap(48, 55, smallFish, 80, 2, 3);
            break;
          case 1:
            Managers.Fishing.addFishToMap(16, 24, smallFish, 100, 6, 5);
            Managers.Fishing.addFishToMap(35, 57, smallFish, 80, 6, 13);
            break;
          case 2:
            
            Managers.Fishing.addFishToMap(35, 56, smallFish, 70, 6, 4);
            break;
          case 3:
            if (Utils.chance(50)) {
              // Second Level
              Managers.Fishing.addFishToMap(21, 62, mediumFish, 10, 6, 2);
            }
            break;
          case 4:
            Managers.Fishing.addFishToMap(23, 29, smallFish, 50, 2, 2);
            break;
          case 5:
            Managers.Fishing.addFishToMap(21, 54, smallFish, 40, 2, 3);
            break;
        }
        break;
      case 1:
        switch(minute) {
          case 0:
            if (month === 3) {
              Managers.Fishing.addFishToMap(0, 39, 'walleye', 20, 2, 6);
            }
            Managers.Fishing.addFishToMap(35, 59, smallFish, 100, 2, 3);
            break;
          case 1:
            // Third Level
            Managers.Fishing.addFishToMap(45, 59, bigFish, 30, 4, 8);
            break;
          case 2:
            Managers.Fishing.addFishToMap(24, 52, smallFish, 40, 2, 10);
            break;
          case 3:
            Managers.Fishing.addFishToMap(7, 25, smallFish, 80, 2, 4);
            Managers.Fishing.addFishToMap(38, 56, smallFish, 70, 2, 7);
            break;
          case 4:
            if (Utils.chance(50)) {
              // Second Level
              Managers.Fishing.addFishToMap(22, 54, mediumFish, 70, 2, 4);
            }
            break;
          case 5:
            Managers.Fishing.addFishToMap(25, 58, smallFish, 30, 4, 3);
            break;
        }
        break;
      case 2:
        switch(minute) {
          case 0:
            Managers.Fishing.addFishToMap(33, 21, smallFish, 10, 2, 2);
            break;
          case 1:
            Managers.Fishing.addFishToMap(22, 60, smallFish, 30, 2, 3);
            break;
          case 2:
            Managers.Fishing.addFishToMap(46, 12, smallFish, 80, 6, 5);
            break;
          case 3:
            Managers.Fishing.addFishToMap(8, 24, smallFish, 70, 6, 4);
            Managers.Fishing.addFishToMap(40, 57, smallFish, 90, 6, 4);
            break;
          case 4:
            Managers.Fishing.addFishToMap(44, 4, smallFish, 40, 6, 3);
            break;
          case 5:
            Managers.Fishing.addFishToMap(20, 63, smallFish, 50, 6, 3);
            break;
        }
        break;
      case 3:
        switch(minute) {
          case 0:
            if (Utils.chance(50)) {
              // Second Level
              Managers.Fishing.addFishToMap(36, 58, mediumFish, 40, 6, 10);
            }
            break;
          case 1:
            Managers.Fishing.addFishToMap(9, 31, smallFish, 90, 8, 6);
            Managers.Fishing.addFishToMap(36, 63, smallFish, 50, 8, 7);
            break;
          case 2:
            if (Utils.chance(50)) {
              // Level 2
              Managers.Fishing.addFishToMap(42, 61, mediumFish, 80, 8, 3);
            }
            break;
          case 3:
            Managers.Fishing.addFishToMap(55, 20, smallFish, 20, 4, 4);
            Managers.Fishing.addFishToMap(22, 61, smallFish, 40, 6, 2);
            break;
          case 4:
            Managers.Fishing.addFishToMap(19, 24, smallFish, 70, 2, 3);
            break;
          case 5:
            Managers.Fishing.addFishToMap(27, 22, smallFish, 80, 6, 2);
            break;
        }
        break;
    }

    if (hour === 17 && minute === 5) {
      Managers.Fishing.addRandomItem(['diamond', 'pearl'], 24, Utils.chance(50) ? 49 : 43, 1, 20);
    }

    this.updateFishingItemsLowerWaterfall();
  }
}

Managers.Map.registerMapClass(Maps.MOUNTAIN, MountainMap);