function ForestSouthMap() {

}

ForestSouthMap.checkTeleports = function() {
  if ($gamePlayer.bottom <= 1) {
    $gamePlayer.reserveTransfer(Maps.FOREST_CENTER, $gamePlayer.x, 19, $gamePlayer._direction, 0, true);
    return;
  }

  if (Switches.forestSouthSolved) {
    if (!$gamePlayer.isRiding()) {
      if ($gamePlayer.top >= 16 && $gamePlayer.left >= 22 && $gamePlayer.right <= 23 && $gamePlayer.top <= 17.5) {
        $gamePlayer.reserveTransfer(Maps.CAVEPATH_TO_FALLFIELDS, 2, 10, Direction.UP, 0, true);
        return;
      }
    }
  }
};

ForestSouthMap.update = function() {
  if ($gameMessage.isBusy()) return;
  if (Graphics.frameCount % 10 > 0) return;

  this.checkButtons();
};

ForestSouthMap.checkButtons = function() {
  if (Switches.forestSouthSolved) return;
  if ($gameSystem.isPlayingCutscene()) return;

  if (this.delayCount > 0) {
    this.delayCount--;
  }

  if (Managers.FarmObjects.countStateOnMap($gameMap._mapId, FarmObjectState.BUTTON_PRESSED, true, FarmObjectState.BUTTON) >= 4) {
    Switches.forestSouthSolved = true;
    
    Managers.CommonEvent.playEvent('forest_south_puzzle_solved');
    return;
  }

  this.delayCount = Utils.getFrameCount(10);
};

ForestSouthMap.getHeightLevel = function(x, y) {
  if (y < 12) return 0;
  if (y >= 22) return 3;
  if (x < 21) return 0;
  if (x >= 31) return 3;

  if (x >= 29 && y < 14) return 0;
  if (x >= 24) return 3;

  if (y >= 18) return 0;
  if (x >= 23) return 3;
  if (y >= 13) return 3;

  return 0;
};

ForestSouthMap.isAvailableArea = function() {
  return true;
};

ForestSouthMap.isZoomOutEnabled = function() {
  return true;
};

Managers.Map.registerMapClass(Maps.FOREST_S, ForestSouthMap);