class ForestMap {
  static checkTeleports() {
    if ($gamePlayer.right <= 1) {
      $gamePlayer.reserveTransfer(Maps.ORANGE_TOWN, 74, $gamePlayer.y, $gamePlayer._direction, 0, true);
      return;
    }

    if ($gamePlayer.left >= 79) {
      if ($gamePlayer.top >= 50) {
        $gamePlayer.reserveTransfer(Maps.FOREST_CENTER, 1, $gamePlayer.y - 50, $gamePlayer._direction, 0, true);
      } else {
        $gamePlayer.reserveTransfer(Maps.MAZE, 1, $gamePlayer.y, $gamePlayer._direction, 0, true);
      }
      return;
    }
  }

  static updatePlayerSpritePosition(sprite) {
    if (Switches.onRaft) return;
    
    if (sprite._character.isTouchingRegion(Region.BRIDGE)) {
      sprite.y -= 6;
      sprite.zOrder += 6;
    }
  }

  static getHeightLevel(x, y) {
    return 0;
  }

  static isAvailableArea() {
    return true;
  }

  static updateFishes() {
    const { hour, minute } = Managers.Time;
    const mod4 = hour % 4;

    if (!Utils.chance(50)) {
      return;
    }

    const smallFish = Managers.Fishing.getRandomFishId('small', Maps.FOREST);
    const mediumFish = Managers.Fishing.getRandomFishId('medium', Maps.FOREST);
    const bigFish = Managers.Fishing.getRandomFishId('big', Maps.FOREST);

    switch(mod4) {
      case 0:
        switch(minute) {
          case 0:
            Managers.Fishing.addFishToMap(47, 49, smallFish, 40, 8, 6);
            break;
          case 1:
            Managers.Fishing.addFishToMap(14, 55, smallFish, 25, 2, 4);
            break;
          case 2:
            // Second level
            if (Utils.chance(50)) {
              Managers.Fishing.addFishToMap(15, 56, mediumFish, 40, 6, 12);
            }
            break;
          case 3:
            Managers.Fishing.addFishToMap(3, 56, smallFish, 30, 6, 5);
            break;
          case 4:
            Managers.Fishing.addFishToMap(8, 57, smallFish, 30, 6, 6);
            break;
          case 5:
            Managers.Fishing.addFishToMap(38, 50, smallFish, 25, 6, 8);
            break;
        }

        break;
      case 1:
        switch(minute) {
          case 0:
            Managers.Fishing.addFishToMap(40, 45, smallFish, 50, 6, 7);
            break;
          case 1:
            Managers.Fishing.addFishToMap(32, 54, smallFish, 25, 6, 5);
            break;
          case 2:
            // Second level
            if (Utils.chance(50)) {
              Managers.Fishing.addFishToMap(9, 55, mediumFish, 40, 4, 8);
            }
            break;
          case 3:
            Managers.Fishing.addFishToMap(4, 51, smallFish, 40, 2, 5);
            break;
          case 4:
            Managers.Fishing.addFishToMap(27, 57, smallFish, 40, 4, 12);
            break;
          case 5:
            // Third level
            if (Utils.chance(15)) {
              Managers.Fishing.addFishToMap(44, 42, bigFish, 20, 2, 6);
            }
            break;
        }      
        break;
      case 2:
        switch(minute) {
          case 0:
            Managers.Fishing.addFishToMap(46, 44, smallFish, 50, 2, 9);
            break;
          case 1:
            // Third level
            if (Utils.chance(15)) {
              Managers.Fishing.addFishToMap(22, 50, bigFish, 30, 2, 5);
            }
            break;
          case 2:
            Managers.Fishing.addFishToMap(33, 57, smallFish, 40, 8, 4);
            break;
          case 3:
            Managers.Fishing.addFishToMap(28, 57, smallFish, 30, 6, 5);
            break;
          case 4:
            Managers.Fishing.addFishToMap(0, 59, smallFish, 40, 8, 3);
            break;
          case 5:
            // Third level
            if (Utils.chance(15)) {
              Managers.Fishing.addFishToMap(0, 54, bigFish, 20, 6, 14);
            }
            break;
        }      
        break;
      case 3:
        switch(minute) {
          case 0:
            // Third level
            if (Utils.chance(15)) {
              Managers.Fishing.addFishToMap(27, 55, bigFish, 30, 4, 11);
            }
            break;
          case 1:
            Managers.Fishing.addFishToMap(39, 53, smallFish, 40, 8, 6);
            break;
          case 2:
            Managers.Fishing.addFishToMap(26, 60, smallFish, 30, 6, 2);
            break;
          case 3:
            // Third level
            if (Utils.chance(15)) {
              Managers.Fishing.addFishToMap(10, 52, bigFish, 5, 2, 3);
            }
            break;
          case 4:
            Managers.Fishing.addFishToMap(27, 54, smallFish, 40, 2, 6);
            break;
          case 5:
            Managers.Fishing.addFishToMap(1, 65, smallFish, 25, 2, 4);
            break;
        }
        break;
    }
  }

  static setupMapEvents() {
    // Moving Water
    $gameMap.addSoundSource(0, 66, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(1, 56, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(12, 56, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(22, 56, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(33, 55, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(40, 50, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(46, 44, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(46, 44, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(47, 58, 'WaterLoop', 0.3);
    $gameMap.addSoundSource(48, 34, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(51, 25, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(54, 16, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(58, 7, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(63, 0, 'WaterLoop', 0.4);

  }
}

Managers.Map.registerMapClass(Maps.FOREST, ForestMap);