class HomeMap {
  static setupMapEvents() {

  }

  static checkTeleports() {
    if (Managers.Time.totalDays === 1) {
      if ($gamePlayer.top >= 11) {
        if (!$gameTemp.isCommonEventReserved()) {
          Managers.CommonEvent.playEvent('day_1_cant_leave_yet', false, true);
        }
      }

      return;
    }

    if ($gamePlayer.top >= 11) {
      const farmMap = Managers.Map.getClass(Maps.FARM);
      farmMap.enterFromFarmDoor();
      return;
    }

    if (Switches.builtSecondFloor) {
      if ($gamePlayer.bottom <= 4 && $gamePlayer.right >= 16 && $gamePlayer.right <= 18) {
        $gamePlayer.reserveTransfer(Maps.HOME_3B, 12.5, 5, 2, 0, true);
        return;
      }
    }
  }

  static checkBed() {
    Managers.CommonEvent.playEvent('check_bed');
  }

  static confirmSleep() {
    const oldDateTime = Managers.Time.getDateTime();
    const newDateTime = Managers.Time.getNextMorningTime();

    Engine.Audio.fadeOutBgm(3);
    setTimeout(() => Managers.Sound.playBedEvent(), 100);
    $gameSystem.startSleep(HomeMap.sleep, oldDateTime, newDateTime);
  }

  static sleep() {
    Managers.Time.sleep();

    $gamePlayer._direction = Direction.DOWN;
    if ($gameMap.isHome()) {
      $gamePlayer.setPosition(19, 4);
    }

    if ($gameTemp.isAutoSaveLoadedSlotRequested()) {
      Engine.Data.autoSaveLoadedGame();
      $gameTemp.clearAutoSaveLoadedSlotRequest();
    } else {
      Engine.Data.autoSave();
    }

    $gameMap.autoplay();
    Engine.Audio.fadeInBgm(3);
  }

  static checkBookCase() {

  }

  static playTvChannel(channel) {
    if (!$gameMap.isHome()) {
      $gameTemp.setCurrentTvChannel(false);
      return;
    }

    var event = $gameMap._interpreter.character(0);
    if (event) {
      $gameTemp.setCurrentTvChannel(channel, event);
    }
  }

  static playTv() {
    if (!$gameMap.isHome()) {
      $gameTemp.setCurrentTvChannel(false);
      return;
    }

    if ($gameTemp.isPlayingTv()) {
      const event = $gameMap._interpreter.character(0);
      $gameTemp.setCurrentTvChannel('off', event);
      return;
    }

    if (Managers.Content.playCustomTvChannel(HomeMap.playTvChannel)) {
      return;
    }

    switch (Managers.Weather.nextDayWeather) {
      case WeatherType.SUN :
        if (Managers.Time.month == Seasons.WINTER) {
          this.playTvChannel('winter_sun');
        } else {
          this.playTvChannel('sun');
        }
        break;
      case WeatherType.RAIN :
        this.playTvChannel('rain');
        break;
      case WeatherType.SNOW :
        this.playTvChannel('snow');
        break;
      case WeatherType.STORM :
        this.playTvChannel('storm');
        break;
      case WeatherType.SNOWSTORM :
        this.playTvChannel('snowstorm');
        break;
      case WeatherType.HEAT :
        this.playTvChannel('heat');
        break;
    }
  }

  static enterHome() {
    $gamePlayer.goHome();
  }

  static openStorage(playSound, callback) {
    if (!$gameMap.isHome()) return;
    
    if (playSound) {
      Managers.Sound.playOpenStorage();
    }

    // $gameMap.event(1).doDoorAnimation(playSound, callback);
    callback();

    return true;
  }

  static closeStorage() {
    if (!$gameMap.isHome()) return;

    // $gameMap.event(1).doCloseDoorAnimation();
  }

  static isAvailableArea() {
    return true;
  }

  static isZoomOutEnabled() {
    return false;
  }

  static toggleBathroomDoor() {
    const event = $gameMap.getVillagerDoorEvent('Bathroom');
    if (!event) {
      return;
    }

    if (event._direction === Direction.DOWN) {
      event.doDoorAnimation();
      return;
    }

    if (event._direction === Direction.UP) {
      event.doCloseDoorAnimation();
      // When closing the door, make sure the player is not still on it's tile.
      $gamePlayer.leaveTile(event.x, event.y);
      return;
    }
  }
}

Managers.Map.registerMapClass(Maps.HOME, HomeMap);
Managers.Map.registerMapClass(Maps.HOME_2, HomeMap);
Managers.Map.registerMapClass(Maps.HOME_3, HomeMap);

class HomeMapContent {
  static contentId() {
    return 'home';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'HOME') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'BATHROOM':
        HomeMap.toggleBathroomDoor();
        return true;
      case 'BED':
        HomeMap.checkBed();
        return true;
      case 'SLEEP':
        HomeMap.confirmSleep();
        return true;
      case 'TV':
        {
          const channelName = parser.nextArg();
          if (channelName) {
            HomeMap.playTvChannel(channelName);
          } else {
            HomeMap.playTv();
          }
        }
        return true;
      case 'BOOKCASE':
        HomeMap.checkBookCase();
        return true;
    }
  }

  static tryPushingEvent(event, direction) {
    if (!$gameMap.isHome()) return;
    if (!$gameMap.eventIsVillagerDoor(event, 'Bathroom')) return;

    if (event._direction === Direction.DOWN) {
      event.doDoorAnimation();

      if (Engine.Input.dir4) {
        $gamePlayer.executeMove(Engine.Input.dir4);
      }

      return true;
    }

    if (Engine.Input.dir4) {
      $gamePlayer.executeMove(Engine.Input.dir4);
    }
  }

}

Managers.Content.registerContentClass(HomeMapContent);