class FarmMap {
  static setupMapEvents() {
    if (!Switches.canAccessCenterFarm) {
      const tileId = 565;
      for (let y = 2; y <= 42; y++) {
        $gameMap.createFenceEventAt(0, y, tileId);
      }
    }

    this.addMailboxBalloon();

    // Moving Water
    $gameMap.addSoundSource(10, 2, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(9, 11, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(7, 17, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(6, 22, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(6, 22, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(5, 36, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(5, 41, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(16, 45, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(27, 45, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(41, 45, 'WaterLoop', 0.4);
    $gameMap.addSoundSource(52, 45, 'WaterLoop', 0.4);

    this.createShippingBin();
  }

  static checkTeleports() {
    if ($gamePlayer.bottom <= 1 && $gamePlayer.left >= 43 && $gamePlayer.right <= 46) {
      $gamePlayer.reserveTransfer(Maps.ORANGE_TOWN, $gamePlayer.x - 41, 78, $gamePlayer._direction, 0, true);
      return;
    }

    if (Switches.canAccessCenterFarm) {
      if ($gamePlayer.right <= 1) {
        $gamePlayer.reserveTransfer(Maps.FARM_CENTER, 58, $gamePlayer.y, $gamePlayer._direction, 0, true);
        return;
      }
    }

    if ($gamePlayer.left >= 59 && $gamePlayer.top <= 10) {
      $gamePlayer.reserveTransfer(Maps.PETTING_ZOO, 1, $gamePlayer.y, $gamePlayer._direction, 0, true);
      return;
    }

    if ($gamePlayer.bottom <= 1 && $gamePlayer.left > 5 && $gamePlayer.right < 9) {
      $gamePlayer.reserveTransfer(Maps.MOUNTAIN, $gamePlayer.x + 30, 75, $gamePlayer._direction, 0, true);
      return;
    }
  }

  static createShippingBin() {
    let pattern = 0;
    if (Managers.Time.month === 4) {
      pattern = 1;
    }

    $gameMap.createSimpleEventAt('farm/$shipping[4]', 46, 2, {
      d: 2,
      pattern,
      priority: 1,
      customEventName: 'check_shipping_bin',
      lockPattern: true,
      offsetX: 8,
      hitboxWidth: 1.5,
      name: 'shipping_bin'
    });
  }

  static update() {
    if ($gameMessage.isBusy()) return;
    if (Graphics.frameCount % 10 > 0) return;

    // If there's new mail, check if the player read it to replace the mailbox graphic
    if (Switches.newMail) {
      Managers.Mailbox.updateMailboxSwitch();
    }

    this.addMailboxBalloon();
  }

  static addMailboxBalloon() {
    const mailboxEvent = $gameMap.event(2);
    if (!mailboxEvent) {
      return;
    }

    if (Switches.newMail) {
      mailboxEvent._itemIconBalloon = Constants.NEW_MAIL_ICON;
    } else {
      mailboxEvent._itemIconBalloon = false;
    }
  }

  static enterFromFarmDoor() {
    $gamePlayer.reserveTransfer(Maps.FARM, 34, 9, Direction.DOWN, 0, true);
  }

  static doFarmHouseDoor() {
    if ($gameSystem.isPlayingCutscene()) {
      return;
    }
    if ($gamePlayer.isRiding()) {
      return;
    }

    $gameMap._interpreter.doDoorAnimation();
    $gameTemp.setTimeout($gamePlayer.goHome.bind($gamePlayer), 18);
  }

  static getShippingBinEvent() {
    if ($gameMap._mapId !== Maps.FARM) return;

    return $gameMap.getEventByNameAt('shipping_bin', 46, 2);
  }

  static openShippingBin(playSound, callback) {
    if ($gameMap._mapId !== Maps.FARM) return;

    if (playSound) {
      Managers.Sound.playOpenShippingBin();
    }

    const event = this.getShippingBinEvent();
    if (event) {
      event.doDoorAnimation(false, callback);
    } else {
      callback();
    }
  }

  static closeShippingBin() {
    if ($gameMap._mapId !== Maps.FARM) return;

    const event = this.getShippingBinEvent();
    if (event) {
      event.doCloseDoorAnimation();
    }
  }

  static getHeightLevel(x, y) {
    return 0;
  }

  static isAvailableArea() {
    return true;
  }
}

Managers.Map.registerMapClass(Maps.FARM, FarmMap);