class CoopMap {
  // The coop is not flagged as available because you'll only access copies of the map
  static isAvailableArea() {
    return false;
  }

  static isZoomOutEnabled() {
    return false;
  }

  static setupMapEvents() {
    const mapId = $gameMap._mapId;
    const data = Managers.FarmObjects.findCoopData(mapId);
    if (data) {
      Variables.feedCount = data.feedCount || 0;
    } else {
      Variables.feedCount = 0;
    }

    // if (mapId < 1000) {
    //   return false;
    // }

    const createNestEvent = (x, y, d, pattern, extraOptions) => {
      return $gameMap.createSimpleEventAt('farm/$chicken-nests[4]', x, y, {
        d,
        pattern,
        priority: 0,
        stepAnime: false,
        walkAnime: false,
        directionFix: true,
        lockPattern: true,
        ...extraOptions,
      });
    };

    createNestEvent(7, 4, Direction.LEFT, 0, { offsetX: -2 });
    createNestEvent(8, 4, Direction.LEFT, 1);
    createNestEvent(9, 4, Direction.LEFT, 2);
    createNestEvent(10, 4, Direction.LEFT, 1);
    createNestEvent(11, 4, Direction.LEFT, 2);
    createNestEvent(12, 4, Direction.LEFT, 1);
    createNestEvent(13, 4, Direction.LEFT, 3, { offsetX: 2 });

    const foodSpriteData = {
      d: 2,
      pattern: 0,
      priority: 1,
      stepAnime: false,
      walkAnime: false,
      directionFix: true,
      lockPattern: true,
    };

    if (Variables.feedCount > 0) {
      foodSpriteData.d = 6;
      foodSpriteData.pattern = 1;
    }

    $gameMap.createSimpleEventAt('farm/$chicken-food', 5, 9, foodSpriteData);
    $gameMap.createCollisionArea(6, 4, 1, 0.25);
    $gameMap.createActionEventAt(6, 4, 0, undefined, 'coop_feeding_explanation');
    for (let y = 4; y <= 9; y++) {
      $gameMap.createActionEventAt(5, y, 0, undefined, 'coop_feeding_explanation');
    }

    this.createFeedBoxEvent();
    this.createStorageEvent();
    this.createEggEvents();
    this.createBellEvent();
  }

  static animateFeedingBin() {
    const events = $gameMap.eventsHardXy(5, 9);
    if (!events || !events.length) return;
    const event = events[0];

    const animation = [];

    animation.push({ pattern: 0, direction: 2 });
    animation.push({ pattern: 1, direction: 2 });
    animation.push({ pattern: 2, direction: 2 });
    animation.push({ pattern: 0, direction: 4 });
    animation.push({ pattern: 1, direction: 4 });
    animation.push({ pattern: 2, direction: 4 });
    animation.push({ pattern: 0, direction: 6 });
    animation.push({ pattern: 1, direction: 6 });

    event.animate(animation, { 
      avoidLock: true,
      loop: false,
      defaultStepLength: 6,
    });
  }

  static createBellEvent() {
    const eventData = {
      direction: 4,
      pattern: 1,
      priority: 1,
      stepAnime: false,
      walkAnime: false,
      directionFix: true,
      lockPattern: true,
      customEventName: 'use_bell_on_coop',
    };

    $gameMap.createSimpleEventAt('objects/$bells', 12, 8, eventData);
  }

  static checkFeedingBin() {
    Variables.maxFeedCount = 14;
    const data = Managers.FarmObjects.findCoopData($gameMap._mapId);
    if (!data) {
      return;
    }

    if (data.feedCount == Variables.maxFeedCount) {
      Managers.CommonEvent.playEvent('check_coop_feed_box_full');
      return;
    }

    if (Managers.Items.isHoldingItem('chicken-feed')) {
      const needsAnimation = !data.feedCount;
      const amountToDrop = Math.min(Variables.maxFeedCount - (data.feedCount || 0), Managers.Items.selectedItem.amount);

      data.feedCount = (data.feedCount || 0) + amountToDrop;
      Variables.feedCount = data.feedCount;
      Managers.Items.loseUnitOfSelectedItem(amountToDrop);
      Managers.CommonEvent.playEvent('player_drop_item');

      if (needsAnimation) {
        this.animateFeedingBin();
      }
      return;
    }

    Managers.CommonEvent.playEvent('check_coop_feed_box_sign');
  }

  static createFeedBoxEvent() {
    const event = $gameMap.createMultiSpriteActionEventAt(8, 8, [
      {
        characterName: 'farm/$$feed-boxes[5]',
        pattern: 0,
      },
      {
        pattern: 1,
        condition: {
          variableName: 'feedCount',
          value: 1
        }
      },
      {
        pattern: 2,
        condition: {
          variableName: 'feedCount',
          value: 2
        }
      },
      {
        pattern: 3,
        condition: {
          variableName: 'feedCount',
          value: 4
        }
      },
      {
        pattern: 4,
        condition: {
          variableName: 'feedCount',
          value: 7
        }
      }
    ], 'check_coop_feed_box', 1, Objects.CustomStaticEvent);

    event.hitboxY = 0.75;
    event.offsetY = 16;

    $gameMap.createActionEventAt(8, 8, 0, undefined, 'check_coop_feed_box');
  }

  static createStorageEvent() {
    const event = $gameMap.createStaticEventAt('farm/$storage[5]', 0, 15, 4, 2, 0, 1, true, Objects.CustomStaticEvent, false, 'check_storage');
    event.offsetY = -16;
    event.hitboxHeight = 0.5;
  }

  static createEggEvents() {
    // #ToDo: Replace RM events with better code.
    const mapId = $gameMap._mapId;
    const maxBirds = Managers.Map.getRealMapId(mapId) == Maps.COOP ? 7 : 14;

    const mapCreatures = Managers.Creatures.getHomeMapCreatures(mapId);
    if (mapCreatures.length >= maxBirds) return;

    const key = [mapId, 0, 'A'];
    const keyB = [mapId, 0, 'B'];
    const keyC = [mapId, 0, 'C'];

    for (let i = 1; i <= maxBirds; i++) {
      key[1] = i;
      keyB[1] = i;
      keyC[1] = i;

      // If it's not fertilized, ignore it
      if (!$gameSelfSwitches.value(keyC)) continue;
      // If there's two eggs, ignore it
      if ($gameSelfSwitches.value(keyB)) continue;

      const age = Managers.Creatures.getEggAge(mapId, i);
      if (age >= 5) {
        // Remove the egg.
        $gameSelfSwitches.setValue(key, false);
        $gameSelfSwitches.setValue(keyB, false);
        $gameSelfSwitches.setValue(keyC, false);

        // Add a chick to the map
        const momId = Managers.Creatures.getEggMom(mapId, i);
        let momType = 'chicken';
        let momData;
        let initialFriendship = 0;
        let momSpeed = Math.randomInt(3);
        let momEggChance = Math.randomInt(3);

        if (momId) {
          momData = Managers.Creatures.getCreatureById(momId);
          if (momData) {
            momType = momData.type;
            initialFriendship = Math.floor(momData.friendship * 0.2);
            momData._chickenEggChance += 0.05;
            momData.friendship += 100;

            momSpeed = momData._chickenSpeed;
            momEggChance = momData._chickenEggChance;
          }
        }

        // If there was no mother, pick a chicken type at random
        if (!momData) {
          const chickenTypes = ['chicken', 'dark-chicken', 'cinnamon-chicken', 'brown-chicken', 'pirate-chicken'];
          const chickenIdx = Math.randomInt(chickenTypes.length);
          momType = chickenTypes[chickenIdx];
        }

        const chickType = momType.replace(/\bchicken\b/, 'chick');
        const chick = Managers.Creatures.createCreatureAt(chickType, mapId, 7, 5, 'chick', false);
        chick._friendship = initialFriendship;

        chick._chickenSpeed = Math.max(0.1, Math.fix(momSpeed + Math.abs(Math.random() * 0.5 - 0.1)));
        chick._chickenEggChance = Math.max(0.1, Math.fix(momEggChance + Math.abs(Math.random() * 0.5 - 0.1)));
        chick._chickenLuck = Math.max(0.1, Math.floor(Math.random() * 500) / 100);

        if (chick._chickenSpeed > 5) {
          chick._chickenSpeed = 5;
        }
        if (chick._chickenEggChance > 5) {
          chick._chickenEggChance = 5;
        }
        if (chick._chickenLuck > 5) {
          chick._chickenLuck = 5;
        }

        Managers.Creatures._lastPreparedData = chick;
        $gameTemp.reserveCutscene('chick_is_born');
        return;
      }
    }
  }

  static checkTeleports() {
    if ($gamePlayer.top >= 9) {
      const coopData = Managers.FarmObjects.findCoopData($gameMap._mapId);
      if (coopData) {
        $gamePlayer.reserveTransfer(coopData.mapId, coopData.x, coopData.y + 1, Direction.DOWN, 0, true);
        return;
      }

      $gamePlayer.goHome();
      return;
    }
  }

  static getValidPositions(mapId) {
    const realMapId = Managers.Map.getRealMapId(mapId);
    const isExpanded = realMapId === Maps.EXPANDED_COOP;

    const positions = [];

    for (let x = 7; x <= 13; x++) {
      positions.push({ x, y: 5 });
    }

    if (isExpanded) {
      for (let x = 7; x <= 13; x++) {
        positions.push({ x, y: 10 });
      }
    }

    return positions;
  }

  static consumeAnimalFoodInMap(mapId) {
    // if (mapId < 1000) return false;
    // const realMapId = Managers.Map.getRealMapId(mapId);
    // const isExpanded = realMapId === Maps.EXPANDED_COOP;

    const data = Managers.FarmObjects.findCoopData(mapId);
    if (!data) {
      return false;
    }

    if (data.feedCount > 0) {
      data.feedCount--;
      return true;
    }

    return false;
  }

  static addEggToMap(mapId, creature) {
    if (mapId < 1000) return false;

    const realMapId = Managers.Map.getRealMapId(mapId);
    const isExpanded = realMapId === Maps.EXPANDED_COOP;
    const maxBirds = isExpanded ? 14 : 7;

    if (creature._chickenEggChance < 1) {
      if (Math.random() > (creature._chickenEggChance * Math.randomInt(10))) {
        return true;
      }
    }

    const key = [mapId, 0, 'A'];
    const keyB = [mapId, 0, 'B'];
    const keyC = [mapId, 0, 'C'];

    for (let i = 1; i <= maxBirds; i++) {
      key[1] = i;
      keyB[1] = i;
      keyC[1] = i;

      if ($gameSelfSwitches.value(key)) continue;
      if ($gameSelfSwitches.value(keyC)) continue;

      $gameSelfSwitches.setValue(key, true);

      // Random chance of adding a second egg the same day, based on the chicken's "eggchance" trait
      if (creature._chickenEggChance > 1) {
        if (Math.random() * 5  < creature._chickenEggChance) {
          $gameSelfSwitches.setValue(keyB, true);
        }
      }

      Managers.Creatures.registerEggMom(mapId, i, creature.id);
      return true;
    }

    // If there was no empty nest, then add a new egg to any nest that has only one and is not fertilized
    for (let i = 1; i <= maxBirds; i++) {
      keyB[1] = i;
      keyC[1] = i;

      if ($gameSelfSwitches.value(keyB)) continue;
      if ($gameSelfSwitches.value(keyC)) continue;

      $gameSelfSwitches.setValue(keyB, true);
      return true;
    }

    return false;    
  }
}

// CoopMap.update = function() {
//   if ($gameMessage.isBusy()) return;
//   if (Graphics.frameCount % 5 > 0) return;

//   this.updateBackgroundSE();
// };

// CoopMap.updateBackgroundSE = function() {
//   if (!!this._backgroundSEDelay && this._backgroundSEDelay > 0) {
//     this._backgroundSEDelay--;
//     return;
//   }

//   var qtd = Managers.Creatures.countChickenOnMap($gameMap._mapId);
//   if (Math.randomInt(100) < qtd) {
//     Managers.Sound.playRandomChickenSound();
//     this._backgroundSEDelay = Utils.getFrameCount(30);
//   }
// };

// CoopMap.checkEventTriggerThere = function() {
//   var frontTile = TileHelper.getSmartFrontTile(1);
//   if (frontTile) {
//     var events = $gameMap.eventsXy(frontTile.x, frontTile.y);

//     for (var i = 0; i < events.length; i++) {
//       if (events[i].event().name == 'chicken-feed') {
//         var key = [$gameMap._mapId, events[i]._eventId, 'A'];
//         if ($gameSelfSwitches.value(key)) {
//           Managers.CommonEvent.playEvent('chicken_feed_bin_full');
//         } else {
//           if (Managers.Items.isHoldingItem('chicken-feed')) return false;

//           Managers.CommonEvent.playEvent('chicken_feed_bin_empty');
//         }
//         return true;
//       }
//     }
//   }

//   return false;
// };

// CoopMap.openStorage = function(playSound, callback) {
//   if ($gameMap._realMapId !== Maps.COOP) return;

//   if (playSound) {
//     Managers.Sound.playOpenStorage();
//   }

//   $gameMap.event(29).doDoorAnimation(false, callback);

//   return true;
// };

// CoopMap.closeStorage = function() {
//   if ($gameMap._realMapId !== Maps.COOP) return;

//   $gameMap.event(29).doCloseDoorAnimation();
// };

// CoopMap.doFeedDispenser = function() {
//   if (Managers.Items.waiting) return;

//   if (!Managers.Items.canGainItemId('chicken-feed')) {
//     Managers.CommonEvent.playEvent('check_feed_dispenser');
//     return false;
//   }

//   if (Managers.Items.storageContainer.numItemsById('chicken-feed') > 0) {
//     var amountLost = Managers.Items.storageContainer.loseItemId('chicken-feed', 1);
//     if (amountLost > 0) {
//       Managers.Items.pickItemId('chicken-feed', amountLost);
//       return;
//     }
//   }

//   Managers.CommonEvent.playEvent('check_empty_chicken_feed_dispenser');
// };

Managers.Map.registerMapClass(Maps.COOP, CoopMap);