class BarnMap {
  static checkTeleports() {
    if ($gamePlayer.top >= 17) {
      var barnData = Managers.FarmObjects.findBarnData($gameMap._mapId);
      if (barnData) {
        $gamePlayer.reserveTransfer(barnData.mapId, barnData.x, barnData.y + 1, Direction.DOWN, 0, true);
        return;
      }

      $gamePlayer.goHome();
      return;
    }
  }

  static moveAnimalOut(animalEvent) {
    var animalData = animalEvent._creatureData;
    if (!animalData) return;

    var barnData = Managers.FarmObjects.findBarnData($gameMap._mapId);
    if (!barnData) return;

    Managers.Creatures.moveAnimal(animalData, barnData.mapId, barnData.x, barnData.y + 2, Direction.DOWN);
    animalEvent.erase();
  }

  static checkAnimalPosition(animalEvent) {
    if (animalEvent._y >= 17) {
      BarnMap.moveAnimalOut(animalEvent);
      return;
    }
  }

  static getValidPositions() {
    const positions = [];

    for (let y = 7; y <= 13; y += 2) {
      positions.push({x : 4, y, d: 6});
      positions.push({x : 11, y, d: 4});
    }

    return positions;
  }

  static consumeAnimalFoodInMap(mapId) {
    if (mapId < 1000) return false;
    const realMapId = Managers.Map.getRealMapId(mapId);
    if (realMapId !== Maps.BARN) return false;

    const key = [mapId, 0, 'A'];

    for (let i = 101; i <= 116; i++) {
      key[1] = i;

      if ($gameSelfSwitches.value(key)) {
        $gameSelfSwitches.setValue(key, false);
        return true;
      }
    }

    return false;
  }

  static checkEventTriggerThere() {
    const frontTile = TileHelper.getSmartFrontTile(1);
    if (!frontTile) {
      return false;
    }

    return this._checkEventTrigger(frontTile.x, frontTile.y);
  }

  static _checkEventTrigger(x, y) {
    const events = $gameMap.eventsXy(x, y);

    for (const event of events) {
      if (!event) continue;

      if (event._name == 'hay') {
        const key = [$gameMap._mapId, event._eventId, 'A'];
        if ($gameSelfSwitches.value(key)) {
          Managers.CommonEvent.playEvent('farm_animal_feed_bin_full');
        } else {
          if (Managers.Items.isHoldingItem('hay')) return false;

          Managers.CommonEvent.playEvent('farm_animal_feed_bin_empty');
        }

        return true;
      }
    }
  }

  static processTileTouch(x, y) {
    if (!TouchInput.isTriggered()) return false;

    return this._checkEventTrigger(x, y);
  }

  static openStorage(playSound, callback) {
    if ($gameMap._realMapId !== Maps.BARN) return;

    if (playSound) {
      Managers.Sound.playOpenStorage();
    }
    
    // $gameMap.event(17).doDoorAnimation(false, callback);
    callback();

    return true;
  }

  static closeStorage() {
    if ($gameMap._realMapId !== Maps.BARN) return;

    // $gameMap.event(17).doCloseDoorAnimation();
  }

  static checkHayPile() {
    if (Managers.Items.waiting) return;
    
    if (!Managers.Items.canGainItemId('hay')) {
      Managers.CommonEvent.playEvent('check_feed_dispenser');
      return false;
    }

    if (Managers.Items.storageContainer.numItemsById('hay') > 0) {
      let amountLost = Managers.Items.storageContainer.loseItemId('hay', 1);
      if (amountLost > 0) {
        Managers.Items.pickItemId('hay', amountLost);
        return;
      }
    }

    Managers.CommonEvent.playEvent('check_empty_animal_feed_dispenser');
  }

  static isAvailableArea() {
    return false;
  }

  static isZoomOutEnabled() {
    return false;
  }

  static setupMapEvents() {
    this.createHayPileEvent();
    this.createHayEvents();
    this.createStorageEvent();

    this.createBellEvent();
  }

  static createBellEvent() {
    const eventData = {
      direction: 4,
      pattern: 1,
      priority: 1,
      stepAnime: false,
      walkAnime: false,
      directionFix: true,
      lockPattern: true,
      customEventName: 'use_bell_on_barn',
    };

    $gameMap.createSimpleEventAt('objects/$bells', 11, 14, eventData);
  }

  static afterRefreshCreatures() {
    // Change the direction and move type of all animals so that they stay still inside ther areas
    const animals = $gameMap.creatureEvents();
    for (const animal of animals) {
      if (!animal) continue;

      if (animal.x < 7) {
        animal._direction = Direction.RIGHT;
        animal._x = 3.5;
        animal._realX = 3.5;
      } else {
        animal._direction = Direction.LEFT;
        animal._x = 10.5;
        animal._realX = 10.5;
      }
      animal._moveType = 0;
    }
  }

  static afterSetupEvents() {
    this.afterRefreshCreatures();
  }

  static createHayPileEvent() {
    const event = $gameMap.createMultiSpriteActionEventAt(4, 3, [
      {
        characterName: 'farm/$haypile[6]',
        hitboxWidth: 1.5,
        pattern: 0,
        direction: 8,
      },
      {
        direction: 6,
        hitboxWidth: 1.5,
        condition: {
          variableName: 'storageHayCount',
          value: 1
        }
      },
      {
        direction: 4,
        hitboxWidth: 1.75,
        condition: {
          variableName: 'storageHayCount',
          value: 8
        }
      },
      {
        direction: 2,
        hitboxWidth: 2,
        condition: {
          variableName: 'storageHayCount',
          value: 32
        }
      }
    ], 'check_barn_hay_pile', 1, Objects.CustomStaticEvent);

    event.hitboxY = -1;
    event.hitboxHeight = 2;
    event.offsetY = 16;
    event.offsetX = 16;
    event._dynamicHitbox = true;
  }

  static createHayEvents() {
    const addHay = (x, y, id, pattern) => {
      const event = $gameMap.createMultiSpriteActionEventAt(x, y, [
        {
          characterName: 'farm/$$barn-hay[4]',
          pattern: pattern + 2,
        },
        {
          pattern,
          condition: {
            selfSwitchIndex: 'A',
          }
        },
      ], undefined, 0, Objects.CustomStaticEvent, id);
      event._name = 'hay';
      event._lockPattern = true;
      event._hitboxY = -1.5;
      event._hitboxHeight = 2;
    };

    addHay(5, 8, 101, 0);
    addHay(5, 10, 102, 0);
    addHay(5, 12, 103, 0);
    addHay(5, 14, 104, 0);
    addHay(9, 8, 105, 1);
    addHay(9, 10, 106, 1);
    addHay(9, 12, 107, 1);
    addHay(9, 14, 108, 1);
  }

  static createStorageEvent() {
    const event = $gameMap.createStaticEventAt('farm/$storage[5]', 0, 3, 15, 2, 0, 1, true, Objects.CustomStaticEvent, false, 'check_storage');
    event.offsetY = -16;
    event.offsetX = 16;
    event.hitboxHeight = 0.5;
    event.hitboxX = 0.5;
  }
}

Managers.Map.registerMapClass(Maps.BARN, BarnMap);
module.exports = BarnMap;
window.BarnMap = BarnMap;