require('game/managers/Content');

const OrangeTownMap = require('./OrangeTown/Town');

//////////////////////////////
// Content Class
//////////////////////////////

class MapsContent {
  static contentId() {
    return 'maps';
  }

  static _parseTownDoorCommands(parser, args) {
    const name = parser.nextUpperArg(true);

    switch(name) {
      case 'GABRIEL':
        OrangeTownMap.doGabrielDoor();
        return;
      case 'KARL':
        OrangeTownMap.doKarlDoor();
        return;
      case 'MIA':
        OrangeTownMap.doMiaDoor();
        return;
      case 'BENJAMIN':
        OrangeTownMap.doBenjaminDoor();
        return;
      case 'RORY':
        OrangeTownMap.doRoryDoor();
        return;
      case 'BRITTANY':
        OrangeTownMap.doBrittanyFarmDoor();
        return;
      case 'ILDA':
        OrangeTownMap.doIldaDoor();
        return;
      case 'AMANDA':
        OrangeTownMap.doAmandaDoor();
        return;
      case 'DUKE':
        OrangeTownMap.doDukeDoor();
        return;
      case 'LIBRARY':
      case 'NATHALIA':
        OrangeTownMap.doLibraryDoor();
        return;
      case 'STORE':
      case 'SERGE':
        OrangeTownMap.doStoreDoor();
        return;
      case 'RESTAURANT':
      case 'CHLOE':
        OrangeTownMap.doRestaurantDoor();
        return;
      case 'CLINIC':
      case 'BONNIE':
        OrangeTownMap.doClinicDoor();
        return;
      case 'BLACKSMITH':
        OrangeTownMap.doBlacksmithDoor();
        return;
      case 'VIKTOR':
        OrangeTownMap.doViktorDoor();
        return;
      case 'CARPENTER':
      case 'RAPHAEL':
        OrangeTownMap.doCarpenterDoor();
        return;
      case 'LUCAS':
        OrangeTownMap.doLucasDoor();
        return;
      case 'JULIA':
        OrangeTownMap.doCityHallDoor();
        return;
      case 'SPA':
        OrangeTownMap.doSpaDoor();
        return;
    }
  }

  static _parseTownCommands(parser, args) {
    switch(parser.name.toUpperCase()) {
      case 'DOOR': 
        MapsContent._parseTownDoorCommands(parser, args);
        break;
    }

  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() === 'TOWN') {
      return MapsContent._parseTownCommands(parser, args);
    }
  }

}

Managers.Content.registerContentClass(MapsContent);
module.exports = MapsContent;