(function(){
  const skinColors = Managers.Player.getSkinList();
  const hairColors = Managers.Player.getHairColorList();
  const partialNames = [
    '$hero_riding_horse[4]',
    'hero',
    'hero_animations',
    'hero_extra',
    'hero_poses',
    'hero_pushing',
    'hero_light_tools[4]',
    'hero_metal_tools[4]',
    'hero_watering_can[4]',
    '$hero_goalkeeping[4]',
    'hero_dating_poses',
    'hero_games',
  ];

  const toolNames = [
    'hero_light_tools[4]',
    'hero_metal_tools[4]',
    'hero_watering_can[4]'
  ];

  const toolColors = [
    'iron',
    'copper',
    'silver',
    'gold'
  ];

  for (var p = 0; p < partialNames.length; p++) {
    var partialName = partialNames[p];
    var originalName = partialName;

    for (var s = 0; s < skinColors.length; s++) {
      for (var h = 0; h < hairColors.length; h++) {
        var hairName = String(hairColors[h]);
        var skinName = skinColors[s];

        var dollName = originalName.replace('hero', 'hero' + hairName + skinName);
        var dollHairName = partialName + '_hair_' + hairName;
        var dollSkinName = partialName + '_skin_' + skinName;

        var cards = [dollHairName, dollSkinName, 'main/hero/' + partialName + '/base'];
        if (toolNames.indexOf(partialName) >= 0) {
          if (partialName == 'hero_metal_tools[4]') {
            for (var t = 0; t < toolColors.length; t++) {
              var toolColorName = partialName + '_color_' + toolColors[t];
              Managers.PaperDolls.registerPaperDoll(dollName + '_' + toolColors[t], cards.concat([toolColorName]));
            }
          } else {
            cards.push('main/hero/' + partialName + '/tool');
            Managers.PaperDolls.registerPaperDoll(dollName, cards);
          }
        } else {
          Managers.PaperDolls.registerPaperDoll(dollName, cards);
        }

        var femaleDollName = dollName.replace('hero', 'heroine');
        var femaleCards = [];
        for (var c = 0; c < cards.length; c++) {
          femaleCards.push(cards[c].replace(/hero/g, 'heroine'));
        }

        if (partialName == 'hero_metal_tools[4]') {
          for (var t2 = 0; t2 < toolColors.length; t2++) {
            var femaleToolColorName = 'heroine_metal_tools[4]_color_' + toolColors[t2];
            Managers.PaperDolls.registerPaperDoll(femaleDollName + '_' + toolColors[t2], femaleCards.concat([femaleToolColorName]));
          }
        } else {
          Managers.PaperDolls.registerPaperDoll(femaleDollName, femaleCards);
        }
      }
    }
  }
})();
