(function(){
  const skinColors = Managers.Player.getSkinList();
  const hairColors = Managers.Player.getHairColorList();
  const partialNames = [
    '$hero_riding_horse[4]',
    'hero',
    'hero_animations',
    'hero_extra',
    'hero_metal_tools[4]',
    'hero_light_tools[4]',
    'hero_poses',
    'hero_pushing',
    'hero_watering_can[4]',
    '$hero_goalkeeping[4]',
    'hero_dating_poses',
    'hero_games'
  ];

  const toolNames = [
    'hero_metal_tools[4]'
  ];

  const toolColors = [
    'iron',
    'copper',
    'silver',
    'gold'
  ];

  for (var p = 0; p < partialNames.length; p++) {
    for (var s = 0; s < skinColors.length; s++) {
      var maleNameSkin = partialNames[p] + '_skin_' + skinColors[s];
      var femaleNameSkin = maleNameSkin.replace('hero', 'heroine');

      Managers.Palletes.registerPalleteCharacter(maleNameSkin, 'main/hero/' + partialNames[p] + '/skin', ['skin_' + skinColors[s]]);
      Managers.Palletes.registerPalleteCharacter(femaleNameSkin, 'main/heroine/' + partialNames[p].replace('hero', 'heroine') + '/skin', ['skin_' + skinColors[s]]);
    }

    for (var h = 0; h < hairColors.length; h++) {
      var maleNameHair = partialNames[p] + '_hair_' + String(hairColors[h]);
      var femaleNameHair = maleNameHair.replace('hero', 'heroine');

      Managers.Palletes.registerPalleteCharacter(maleNameHair, 'main/hero/' + partialNames[p] + '/hair', ['male_hair_' + String(hairColors[h])]);
      Managers.Palletes.registerPalleteCharacter(femaleNameHair, 'main/heroine/' + partialNames[p].replace('hero', 'heroine') + '/hair', ['female_hair_' + String(hairColors[h])]);
    }
  }

  for (var t = 0; t < toolNames.length; t++) {
    for (var c = 0; c < toolColors.length; c++) {
      var maleNameTool = toolNames[t] + '_color_' + String(toolColors[c]);
      var femaleNameTool = maleNameTool.replace('hero', 'heroine');


      Managers.Palletes.registerPalleteCharacter(maleNameTool, '/main/hero/' + toolNames[t] + '/tool', [toolColors[c] + '_tool']);
      Managers.Palletes.registerPalleteCharacter(femaleNameTool, '/main/heroine/' + toolNames[t].replace('hero', 'heroine') + '/tool', [toolColors[c] + '_tool']);
    }
  }

  for (let hair of hairColors) {
    for (let skin of skinColors) {
      const maleName = `hero${hair}${skin}`;
      const femaleName = `heroine${hair}${skin}`;

      Managers.Palletes.registerPalletePortrait(`small/${maleName}`, 'small/hero', [`portrait_skin_${skin}`, `portrait_hair_male_${hair}`]);
      Managers.Palletes.registerPalletePortrait(`small/${femaleName}`, 'small/heroine', [`portrait_skin_${skin}`, `portrait_hair_female_${hair}`]);

      Managers.Palletes.registerPalletePortrait(`default/${maleName}`, 'default/hero', [`portrait_skin_${skin}`, `portrait_hair_male_${hair}`]);
      Managers.Palletes.registerPalletePortrait(`default/${femaleName}`, 'default/heroine', [`portrait_skin_${skin}`, `portrait_hair_female_${hair}`]);
      
      Managers.Palletes.registerPalletePicture(`maps/player/pin-${femaleName}`, 'maps/pin-heroine', [`portrait_skin_${skin}`, `female_hair_${hair}`]);
      Managers.Palletes.registerPalletePicture(`maps/player/pin-${maleName}`, 'maps/pin-hero', [`portrait_skin_${skin}`, `male_hair_${hair}`]);
    }
  }
})();
