require('game/tools/Tool');

class FurnitureTool extends Tools.BaseTool {
  static doToolEffect() {
    const tile = TileHelper.getSmartFrontTile(1);
    const farmObjects = Managers.FarmObjects.getFarmObjectsXy($gameMap._mapId, tile.x, tile.y);

    for (let i = 0; i < farmObjects.length; i++) {
      const farmObject = farmObjects[i];
      if (!farmObject) {
        continue;
      }

      if (farmObject.isCropOrTree) return;
      if (farmObject.hasCollision()) {
        return;
      }
    }

    if (Managers.FarmObjects.isTileProtected($gameMap._mapId, tile.x, tile.y)) return;
    //Allow furniture objects on any tile even if they aren't soil
    if (!TileHelper.checkIfTileCanGetObject(tile.x, tile.y, true, this.toolName, false, false)) {
      return;
    }

    if ($gamePlayer) {
      $gamePlayer.delayItemSprite();
      $gamePlayer.doToolDelayAnimation(this.toolName);
    }

    for (let i = 0; i < farmObjects.length; i++) {
      const replacedFarmObject = farmObjects[i];
      if (!replacedFarmObject) continue;
      if (replacedFarmObject.tilled) {
        replacedFarmObject.tilled = false;
        replacedFarmObject.updateEvents(true, false);
      }
    }

    const furniture = Managers.FarmObjects.createFarmObjectAt($gameMap._mapId, tile.x, tile.y, this.toolName);
    furniture._modelState = DirectionHelper.getDirectionName($gamePlayer._direction) || 'down';

    Managers.Sound.playDropItem();
    furniture.updateEvents(true, false);
    Managers.Items.loseItemId(this.toolName);
    $gamePlayer.leaveTile(tile.x, tile.y);
  }

  static use(level, targetTile = null) {
    this.doToolEffect(level);
  }

  static getAffectedTiles(level, includeInvalid) {
    return [];
  }
}

module.exports = FurnitureTool;