require('game/models/BaseModel');

Models.BaseLightChair = class LightChairModel extends Models.BaseModel {
  static get modelName() {
    return 'light-chair';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'furniture-1x2',
      spriteIndex: 0,
      direction: 8,
      pattern: 1,
      priority: 1,
      hitboxHeight: 0.5,
      hitboxY: 0.5,
      hitboxWidth: 0.25,
      hitboxX: 0.25
    };
  }
};

Models.LightChairLeft = class LightChairLeftModel extends Models.BaseLightChair {
  static get modelName() {
    return 'light-chair-left';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'furniture-1x2',
      spriteIndex: 1,
      direction: 8,
      pattern: 0,
      priority: 1,
      hitboxHeight: 0.5,
      hitboxY: 0.5,
      hitboxWidth: 0.25,
      hitboxX: 0.25
    };
  }
};

Models.LightChairRight = class LightChairRightModel extends Models.BaseLightChair {
  static get modelName() {
    return 'light-chair-right';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'furniture-1x2',
      spriteIndex: 0,
      direction: 8,
      pattern: 2,
      priority: 1,
      hitboxHeight: 0.5,
      hitboxY: 0.5,
      hitboxWidth: 0.25,
      hitboxX: 0.5
    };
  }
};

Models.LightChairUp = class LightChairUpModel extends Models.BaseLightChair {
  static get modelName() {
    return 'light-chair-up';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'furniture-1x2',
      spriteIndex: 0,
      direction: 8,
      pattern: 0,
      priority: 1,
      hitboxHeight: 0.5,
      hitboxY: 0.5,
      hitboxWidth: 0.5,
      hitboxX: 0.25
    };
  }
};

Models.LightChairDown = class LightChairDownModel extends Models.BaseLightChair {
  static get modelName() {
    return 'light-chair-down';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'furniture-1x2',
      spriteIndex: 0,
      direction: 8,
      pattern: 1,
      priority: 1,
      hitboxHeight: 0.5,
      hitboxY: 0.5,
      hitboxWidth: 0.5,
      hitboxX: 0.25
    };
  }
};