require('game/models/BaseModel');

Models.BaseDarkChair = class DarkChairModel extends Models.BaseModel {
  static get modelName() {
    return 'dark-chair';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'furniture-1x2',
      spriteIndex: 4,
      direction: 2,
      pattern: 1,
      priority: 1,
      hitboxHeight: 0.5,
      hitboxY: 0.5,
      hitboxWidth: 0.25,
      hitboxX: 0.25
    };
  }
};

Models.DarkChairLeft = class DarkChairLeftModel extends Models.BaseDarkChair {
  static get modelName() {
    return 'dark-chair-left';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'furniture-1x2',
      spriteIndex: 5,
      direction: 2,
      pattern: 0,
      priority: 1,
      hitboxHeight: 0.5,
      hitboxY: 0.5,
      hitboxWidth: 0.25,
      hitboxX: 0.25
    };
  }
};

Models.DarkChairRight = class DarkChairRightModel extends Models.BaseDarkChair {
  static get modelName() {
    return 'dark-chair-right';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'furniture-1x2',
      spriteIndex: 4,
      direction: 2,
      pattern: 2,
      priority: 1,
      hitboxHeight: 0.5,
      hitboxY: 0.5,
      hitboxWidth: 0.25,
      hitboxX: 0.5
    };
  }
};

Models.DarkChairUp = class DarkChairUpModel extends Models.BaseDarkChair {
  static get modelName() {
    return 'dark-chair-up';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'furniture-1x2',
      spriteIndex: 4,
      direction: 2,
      pattern: 0,
      priority: 1,
      hitboxHeight: 0.5,
      hitboxY: 0.5,
      hitboxWidth: 0.5,
      hitboxX: 0.25
    };
  }
};

Models.DarkChairDown = class DarkChairDownModel extends Models.BaseDarkChair {
  static get modelName() {
    return 'dark-chair-down';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'furniture-1x2',
      spriteIndex: 4,
      direction: 2,
      pattern: 1,
      priority: 1,
      hitboxHeight: 0.5,
      hitboxY: 0.5,
      hitboxWidth: 0.5,
      hitboxX: 0.25
    };
  }
};