require('game/models/BaseModel');

Models.BaseChair = class ChairModel extends Models.BaseModel {
  static get modelName() {
    return 'chair';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'furniture-1x2',
      spriteIndex: 0,
      direction: 6,
      pattern: 1,
      priority: 1,
      hitboxHeight: 0.5,
      hitboxY: 0.5,
      hitboxWidth: 0.25,
      hitboxX: 0.25
    };
  }
};

Models.ChairLeft = class ChairLeftModel extends Models.BaseChair {
  static get modelName() {
    return 'chair-left';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'furniture-1x2',
      spriteIndex: 1,
      direction: 6,
      pattern: 0,
      priority: 1,
      hitboxHeight: 0.5,
      hitboxY: 0.5,
      hitboxWidth: 0.25,
      hitboxX: 0.25
    };
  }
};

Models.ChairRight = class ChairRightModel extends Models.BaseChair {
  static get modelName() {
    return 'chair-right';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'furniture-1x2',
      spriteIndex: 0,
      direction: 6,
      pattern: 2,
      priority: 1,
      hitboxHeight: 0.5,
      hitboxY: 0.5,
      hitboxWidth: 0.25,
      hitboxX: 0.5
    };
  }
};

Models.ChairUp = class ChairUpModel extends Models.BaseChair {
  static get modelName() {
    return 'chair-up';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'furniture-1x2',
      spriteIndex: 0,
      direction: 6,
      pattern: 0,
      priority: 1,
      hitboxHeight: 0.5,
      hitboxY: 0.5,
      hitboxWidth: 0.5,
      hitboxX: 0.25
    };
  }
};

Models.ChairDown = class ChairDownModel extends Models.BaseChair {
  static get modelName() {
    return 'chair-down';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'furniture-1x2',
      spriteIndex: 0,
      direction: 6,
      pattern: 1,
      priority: 1,
      hitboxHeight: 0.5,
      hitboxY: 0.5,
      hitboxWidth: 0.5,
      hitboxX: 0.25
    };
  }
};