const FurnitureObject = require('./objects/Furniture');

const furnitureList = [
  'chair',
  'light-chair',
  'dark-chair',
  'round-table',
  'light-round-table',
  'dark-round-table',
];

class FurnitureContent {
  static contentId() {
    return 'furniture';
  }

  static checkSpecialItemDrop(targetX, targetY) {
    if (!Managers.Items.selectedItem) return;

    const itemId = Managers.Items.selectedItem.id;

    if (furnitureList.indexOf(itemId) >= 0) {
      return Managers.Items.useSelectedItem(targetX, targetY);
    }
  }

  static getObjectClassType(object) {
    if (furnitureList.includes(object.modelName)) {
      return FurnitureObject;
    }
  }

  static hasAnythingToRun(event, farmObjectData, activatedByMouse) {
    if (furnitureList.indexOf(farmObjectData.modelName) >= 0) {
      return true;
    }
  }

  static touchObject(farmObjectData) {
    if (furnitureList.indexOf(farmObjectData.modelName) >= 0) {
      Managers.FarmObjects.touchFence(farmObjectData, farmObjectData.modelName);
      return true;
    }
  }

  static makeFurnitureProductList(container) {
    container.gainItemId('chair');
    container.gainItemId('light-chair');
    container.gainItemId('dark-chair');
    container.gainItemId('round-table');
    container.gainItemId('light-round-table');
    container.gainItemId('dark-round-table');
  }
}

Managers.Content.registerContentClass(FurnitureContent);