require('game/managers/Content');

class ForgeCraftContent {
  static contentId() {
    return 'forge-crafts';
  }

  static pickBoughtItem(item) {
    if (item.id == 'sprinkler') {
      Managers.Villagers.playDialogue('Viktor', 'trigger_sprinkler_craft');
      return true;
    }

    if (item.id == 'super-sprinkler') {
      Managers.Villagers.playDialogue('Viktor', 'trigger_super_sprinkler_craft');
      return true;
    }
  }

  static makeBlacksmithProductList(container) {
    if (Switches.unlockedSprinklers) {
      container.gainItemId('sprinkler', 1);
    }

    if (Switches.unlockedSuperSprinklers) {
      container.gainItemId('super-sprinkler', 1);
    }
  }

}

Managers.Content.registerContentClass(ForgeCraftContent);