require('game/managers/Content');

//////////////////////////////
// Content Class
//////////////////////////////

class FireCookingSystemContent {
  static contentId() {
    return 'fire-cooking';
  }

  static checkSpecialItemDrop(targetX, targetY) {
    if (!Managers.Items.selectedItem) return;

    // First of all, check if there's a firepit in the target tile
    const events = $gameMap._events.filter(event => !!event && !event._erased && event.x == targetX && event.y == targetY);
    if (!events || !events.length) {
      return;
    }

    let foundFirepit = false;

    for (const event of events) {
      if (!event || !event.event) continue;

      const data = event.event();
      if (!data || data.name !== 'firepit') continue;

      foundFirepit = true;
      break;
    }

    if (!foundFirepit) {
      return;
    }

    // If we are on the right position, then look for any recipe that uses a kitchen pot and only this item
    const itemId = Managers.Items.selectedItem.id;
    let newItemId = false;

    for (let recipe of $dataRecipes) {
      if (!recipe || !recipe.ingredients || !recipe.ingredients.length) continue;
      if (recipe.utensil !== 'kitchen-pot') continue;
      if (recipe.ingredients.length > 1) continue;
      if (recipe.ingredients[0] != itemId) continue;

      newItemId = recipe.itemId;
      break;
    }

    if (!newItemId) {
      return;
    }

    Variables.fireCookingOldItemId = itemId;
    Variables.fireCookingNewItemId = newItemId;
    Managers.CommonEvent.playEvent('cook_on_pit');
  }
}

Managers.Content.registerContentClass(FireCookingSystemContent);
module.exports = FireCookingSystemContent;

