require('game/managers/Content');
require('game/managers/Festivals');
require('game/core/Constants');
const Window_TomatoWarHud = require('./HudWindow');

function TomatoWarContent() {
}

TomatoWarContent.contentId = function() {
  return 'festival-tomato-war';
};

TomatoWarContent.startDay = function() {
  Variables.lastTomatoWarPosition = 0;
};

TomatoWarContent.setupMapEvents = function(firstOfTheDay) {
  if (!Switches.isTomatoFestival) return;

  if ($gameMap._mapId !== Maps.FESTIVAL_RECEPTION) return;
  //If the festival is over, don't generate the custom events
  if (Managers.Time.hour >= 18 && !Switches.isInsideFestival) return;

  if (Managers.Time.hour < 10) {
    Managers.Festivals.leaveUnpreparedFestivalArea();
    return;
  }

  if (!Switches.isInsideFestival) {
    Managers.Festivals.enterFestival();
  }

  this.createFestivalEvents();
};

TomatoWarContent.createTomatoBarrelAt = function(x, y, moveUp, moveRight, eventName, priority) {
  if (priority === undefined) priority = 1;

  var event = $gameMap.createStaticEventAt('$objects', 0, x, y, 8, 1, priority, true, undefined, false, eventName);
  event._directionFix = true;

  if (moveUp) {
    event._metaOffsetY = -16;
    event._hitboxY = -0.5;
  }

  if (moveRight) {
    event._metaOffsetX = 16;
    event._hitboxX = 0.5;
  }

  if (this._tomatoEvents) {
    this._tomatoEvents.push(event);
  }

  return event;
};

TomatoWarContent.createAllTomatoBarrels = function() {
  this._tomatoEvents = [];

  for (let y = 12; y <= 15; y++) {
    this.createTomatoBarrelAt(30, y, false, false);
    this.createTomatoBarrelAt(31, y, false, false);
  }
};

TomatoWarContent.createFestivalEvents = function() {
  Managers.Villagers.killAllVillagerEvents();

  this.createAllTomatoBarrels();

  //Food Icons
  $gameMap.createStaticIconEventAt(425, 6, 19, 1, true);
  $gameMap.createStaticIconEventAt(166, 7, 19, 1, true);
  $gameMap.createStaticIconEventAt(165, 8, 19, 1, true);
  $gameMap.createStaticIconEventAt(9, 6, 24, 1, true);
  $gameMap.createStaticIconEventAt(9, 7, 24, 1, true);
  $gameMap.createStaticIconEventAt(9, 8, 24, 1, true);

  $gameMap.createStaticIconEventAt(425, 30, 19, 1, true);
  $gameMap.createStaticIconEventAt(166, 31, 19, 1, true);
  $gameMap.createStaticIconEventAt(165, 32, 19, 1, true);
  $gameMap.createStaticIconEventAt(9, 30, 24, 1, true);
  $gameMap.createStaticIconEventAt(9, 31, 24, 1, true);
  $gameMap.createStaticIconEventAt(9, 32, 24, 1, true);

  // Rotten tomatoes
  $gameMap.createStaticIconEventAt(387, 33, 17, 0, true);
  $gameMap.createStaticIconEventAt(387, 23, 12, 0, true);
  $gameMap.createStaticIconEventAt(388, 28, 17, 0, true);  
  $gameMap.createStaticIconEventAt(388, 9, 28, 0, true);  

  //Non Players
  $gameMap.createVillagerByNameAt('Benjamin', 18, 12, Direction.DOWN);
  $gameMap.createVillagerByNameAt('Julia', 20, 12, Direction.DOWN);
  $gameMap.createVillagerByNameAt('Stella', 4, 15, Direction.DOWN);

  if (Managers.Relationship.isCharacterKnown('Annie')) {
    $gameMap.createVillagerByNameAt('Annie', 3, 20, Direction.RIGHT);
  }

  $gameMap.createVillagerByNameAt('Bonnie', 24, 28, Direction.RIGHT);
  $gameMap.createVillagerByNameAt('Serge', 35, 23, Direction.LEFT);
  $gameMap.createVillagerByNameAt('Chloe', 35, 21, Direction.LEFT);

  if (!Switches.isFestivalEnding) {
    $gameMap.createVillagerByNameAt('Richard', 26, 29, Direction.LEFT);
    $gameMap.createVillagerByNameAt('Phi', 26, 28, Direction.LEFT);

    $gameMap.createVillagerByNameAt('Billy', 9, 13, Direction.DOWN);
    $gameMap.createVillagerByNameAt('Cindy', 24, 29, Direction.RIGHT);
  }

  $gameMap.createVillagerByNameAt('Raphael', 36, 17, Direction.LEFT);

  // $gameMap.createVillagerByNameAt('Ilda', 12, 28, Direction.RIGHT);
  // $gameMap.createVillagerByNameAt('Gabriel', 13, 28, Direction.LEFT);
  // $gameMap.createVillagerByNameAt('Amanda', 28, 12, Direction.DOWN);

  //Players
  $gameMap.createVillagerByNameAt('Nathalia', 17, 17, Direction.UP);
  $gameMap.createVillagerByNameAt('Devin', 18, 17, Direction.UP);

  $gameMap.createVillagerByNameAt('Brittany', 21, 21, Direction.UP);
  $gameMap.createVillagerByNameAt('Viktor', 19, 21, Direction.UP);


  var suffix = '';
  if (Switches.isFestivalEnding) {
    suffix += '_ending';
  }

  Managers.Villagers.assignEvent('Benjamin', 'benjamin_tomato_festival' + suffix);
  Managers.Villagers.assignEvent('Julia', 'julia_tomato_festival' + suffix);
  Managers.Villagers.assignEvent('Stella', 'stella_tomato_festival' + suffix);
  Managers.Villagers.assignEvent('Annie', 'annie_tomato_festival' + suffix);
  Managers.Villagers.assignEvent('Bonnie', 'bonnie_tomato_festival' + suffix);
  Managers.Villagers.assignEvent('Serge', 'serge_tomato_festival' + suffix);
  Managers.Villagers.assignEvent('Chloe', 'chloe_tomato_festival' + suffix);
  Managers.Villagers.assignEvent('Lucas', 'lucas_tomato_festival' + suffix);
  Managers.Villagers.assignEvent('Richard', 'richard_tomato_festival' + suffix);
  Managers.Villagers.assignEvent('Phi', 'phi_tomato_festival' + suffix);
  Managers.Villagers.assignEvent('Raphael', 'raphael_tomato_festival' + suffix);
  Managers.Villagers.assignEvent('Nathalia', 'nathalia_tomato_festival' + suffix);
  Managers.Villagers.assignEvent('Brittany', 'brittany_tomato_festival' + suffix);
  Managers.Villagers.assignEvent('Devin', 'devin_tomato_festival' + suffix);
  Managers.Villagers.assignEvent('Viktor', 'viktor_tomato_festival' + suffix);
  Managers.Villagers.assignEvent('Billy', 'billy_tomato_festival' + suffix);
  Managers.Villagers.assignEvent('Cindy', 'cindy_tomato_festival' + suffix);
};

TomatoWarContent.startEvent = function() {
  TomatoWarContent.previousItem = Managers.Items._specialItem;
  TomatoWarContent.previousStamina = Managers.Health.stamina;

  Managers.Items._specialItem = undefined;
  Managers.Health.stamina = 100;

  this._hudWindow = false;
  this._paused = true;
  this._finished = false;
  this._winner = '';
  this._runnerUp = '';
  this._thirdPlace = '';
  this._fourthPlace = '';
  this._lastPlace = '';
  this._mouseDelay = 0;
  this._announcingWinners = false;

  Switches.isInsideFestivalCompetition = true;
  TomatoWarContent._thrownTomatoes = [];

  Variables.tomatoWarBrittanyScore = 0;
  Variables.tomatoWarNathaliaScore = 0;
  Variables.tomatoWarDevinScore = 0;
  Variables.tomatoWarViktorScore = 0;
  Variables.tomatoWarPlayerScore = 0;

  for (var x = 9; x <= 21; x++) {
    this.createTomatoBarrelAt(x, 4, false, false, 'tomato_war_pick_tomato');
  }

  for (var y = 5; y <= 11; y++) {
    this.createTomatoBarrelAt(9, y, false, false, 'tomato_war_pick_tomato');
    this.createTomatoBarrelAt(21, y, false, false, 'tomato_war_pick_tomato');
  }

  for (x = 9; x <= 21; x++) {
    this.createTomatoBarrelAt(x, 12, false, false, 'tomato_war_pick_tomato');
  }

  var nathaliaEvent = $gameMap.createVillagerByNameAt('Nathalia', 13, 7, Direction.UP);
  // nathaliaEvent.setThrough(true);
  nathaliaEvent.allowMovementOnFrozenTime = true;
  nathaliaEvent._moveSpeed = 3;

  var brittanyEvent = $gameMap.createVillagerByNameAt('Brittany', 17, 7, Direction.UP);
  // brittanyEvent.setThrough(true);
  brittanyEvent.allowMovementOnFrozenTime = true;
  brittanyEvent._moveSpeed = 3;

  var devinEvent = $gameMap.createVillagerByNameAt('Devin', 13, 9, Direction.DOWN);
  // devinEvent.setThrough(true);
  devinEvent.allowMovementOnFrozenTime = true;
  devinEvent._moveSpeed = 3;

  var viktorEvent = $gameMap.createVillagerByNameAt('Viktor', 17, 9, Direction.DOWN);
  // viktorEvent.setThrough(true);
  viktorEvent.allowMovementOnFrozenTime = true;
  viktorEvent._moveSpeed = 3;

  Managers.Villagers.assignEvent('Nathalia', 'null');
  Managers.Villagers.assignEvent('Brittany', 'null');
  Managers.Villagers.assignEvent('Devin', 'null');
  Managers.Villagers.assignEvent('Viktor', 'null');

  TomatoWarContent.nathaliaEvent = nathaliaEvent;
  TomatoWarContent.brittanyEvent = brittanyEvent;
  TomatoWarContent.devinEvent = devinEvent;
  TomatoWarContent.viktorEvent = viktorEvent;

  $gameMap.createVillagerByNameAt('Benjamin', 14, 3, Direction.DOWN);
  $gameMap.createVillagerByNameAt('Julia', 15, 3, Direction.DOWN);
  $gameMap.createVillagerByNameAt('Stella', 17, 3, Direction.DOWN);

  $gameMap.createVillagerByNameAt('Bonnie', 8, 7, Direction.RIGHT);
  $gameMap.createVillagerByNameAt('Serge', 8, 8, Direction.RIGHT);
  $gameMap.createVillagerByNameAt('Chloe', 8, 9, Direction.RIGHT);

  $gameMap.createVillagerByNameAt('Richard', 22, 7, Direction.LEFT);
  $gameMap.createVillagerByNameAt('Phi', 22, 8, Direction.LEFT);
  $gameMap.createVillagerByNameAt('Raphael', 22, 9, Direction.LEFT);

  $gameMap.centerCameraOn(15, 8, 0);
  this.pauseGame();

  Managers.CommonEvent.playEvent('tomato_festival_start_game');
};

TomatoWarContent.pauseGame = function() {
  this._paused = true;
};

TomatoWarContent.resumeGame = function() {
  this._paused = false;
  Managers.Sound.playWhistle();
  $gameMap.autoplay();
};

TomatoWarContent.updateScroll = function(lastScrolledX, lastScrolledY) {
  if (!Switches.isTomatoFestival) return false;
  if (!Switches.isInsideFestivalCompetition) return false;

  return true;
};

TomatoWarContent.checkEventTriggerHere = function() {
  if (!Switches.isInsideFestivalCompetition) return false;
  if (!Switches.isTomatoFestival) return false;
  if (!Managers.Items.isHoldingItem('tomato')) return false;

  TomatoWarContent.throwTomato($gamePlayer.x, $gamePlayer.top -1, $gamePlayer._direction, $gamePlayer);
  Managers.Items._specialItem = undefined;

  return true;
};

TomatoWarContent.processTileTouch = function(x, y) {
  if (!Switches.isInsideFestivalCompetition) return false;
  if (!Switches.isTomatoFestival) return false;
  if (this._mouseDelay > 0) return true;

  if ($gamePlayer.triggerButtonAction(true)) {
    this._mouseDelay = Utils.getFrameCount(30);
  }
  return true;
};

TomatoWarContent.throwTomato = function(x, y, d, villager) {
  var tomatoEvent = $gameMap.createStaticIconEventAt(9, x, y, 2, true, Objects.Projectile, true);
  tomatoEvent._direction = d;
  tomatoEvent._directionFix = true;
  tomatoEvent._villager = villager;

  TomatoWarContent._thrownTomatoes.push(tomatoEvent);
};

TomatoWarContent.squishTomato = function(tomatoEvent) {
  tomatoEvent._iconIndex = 388;
  tomatoEvent._priorityType = 0;
};

TomatoWarContent.changeParticipantScore = function(participant, scoreChange) {
  if (participant == $gamePlayer) {
    Variables.tomatoWarPlayerScore += scoreChange;
  } else if (participant == this.brittanyEvent) {
    Variables.tomatoWarBrittanyScore += scoreChange;
  } else if (participant == this.nathaliaEvent) {
    Variables.tomatoWarNathaliaScore += scoreChange;
  } else if (participant == this.devinEvent) {
    Variables.tomatoWarDevinScore += scoreChange;
  } else if (participant == this.viktorEvent) {
    Variables.tomatoWarViktorScore += scoreChange;
  }
};

TomatoWarContent.updateThrownTomatoes = function() {
  if (this._hitDelay) {
    this._hitDelay--;
  }

  var tomatoes = TomatoWarContent._thrownTomatoes;
  var len = tomatoes.length;
  for (var i = 0; i < len; i++) {
    if (!tomatoes[i]) continue;
    if (tomatoes[i]._erased) continue;

    var squish = false;

    switch(tomatoes[i]._direction) {
      case Direction.LEFT :
        tomatoes[i]._realX -= 0.15;
        tomatoes[i]._x = tomatoes[i]._realX;

        squish = tomatoes[i]._realX <= 9.5;
        break;
      case Direction.RIGHT :
        tomatoes[i]._realX += 0.15;
        tomatoes[i]._x = tomatoes[i]._realX;
        squish = tomatoes[i]._realX >= 20.3;
        break;
      case Direction.UP :
        tomatoes[i]._realY -= 0.15;
        tomatoes[i]._y = tomatoes[i]._realY;
        squish = tomatoes[i]._realY <= 4.5;
        break;
      case Direction.DOWN :
        tomatoes[i]._realY += 0.15;
        tomatoes[i]._y = tomatoes[i]._realY;
        squish = tomatoes[i]._realY >= 11.4;
        break;
    }

    if (squish) {
      TomatoWarContent.squishTomato(tomatoes[i]);
      tomatoes[i] = false;
      continue;
    }

    var villagers = this.getAllParticipantEvents();
    for (var v = 0; v < villagers.length; v++) {
      if (villagers[v] == tomatoes[i]._villager) continue;

      if (villagers[v] == $gamePlayer) {
        if (this._hitDelay > 0) {
          continue;
        }
      }

      var left = villagers[v].left;
      var top = villagers[v].top;
      var right = villagers[v].right;
      var bottom = villagers[v].bottom;

      top -= 0.75;
      bottom -= 1;

      if (tomatoes[i].realPosIn(left, top, right, bottom)) {
        TomatoWarContent.squishTomato(tomatoes[i]);

        var originalVillager = tomatoes[i]._villager;
        tomatoes[i] = false;

        villagers[v].jumpInPlace();

        if (villagers[v] === $gamePlayer) {
          Managers.Items._specialItem = undefined;
          this._hitDelay = Utils.getFrameCount(60);
        } else {
          villagers[v]._currentItem = undefined;
        }

        if (!this._finished) {
          TomatoWarContent.changeParticipantScore(villagers[v], -10);
          TomatoWarContent.changeParticipantScore(originalVillager, 30);
        }

        originalVillager._tomatoDelay = Utils.getFrameCount(30 + Math.randomInt(60));
        break;
      }
    }
    if (!tomatoes[i]) continue;
  }
};

TomatoWarContent.getAllParticipantEvents = function() {
  return [TomatoWarContent.brittanyEvent, TomatoWarContent.viktorEvent, TomatoWarContent.nathaliaEvent, TomatoWarContent.devinEvent, $gamePlayer];
};

TomatoWarContent.updateAI = function() {
  var participants = this.getAllParticipantEvents();

  for (var i = 0; i < participants.length; i++) {
    if (participants[i] == $gamePlayer) continue;

    TomatoWarContent.updateVillagerAI(participants[i]);
  }
};

TomatoWarContent.updateVillagerAI = function(villagerEvent) {
  if (villagerEvent._currentItem) {
    TomatoWarContent.updateVillagerAIWithTomato(villagerEvent);
    return;
  }

  if (villagerEvent._tomatoDelay) {
    villagerEvent._tomatoDelay--;
    return;
  }

  if (villagerEvent.isMoving()) return;

  if (this._finished) {
    // villagerEvent.moveRandom();
    return;
  }

  var pick = false;
  var distance = 0;

  var distanceLeft = villagerEvent._realX - 10;
  var distanceRight = 20 - villagerEvent._realX;
  var distanceUp = villagerEvent._realY - 5;
  var distanceDown = 11 - villagerEvent._realY;

  switch(villagerEvent._direction) {
    case Direction.LEFT :
      if (villagerEvent._realX <= 10) {
        pick = true;
      }
      distance = distanceLeft;
      break;
    case Direction.RIGHT :
      if (villagerEvent._realX >= 20) {
        pick = true;
      }
      distance = distanceRight;
      break;
    case Direction.UP :
      if (villagerEvent._realY <= 5) {
        pick = true;
      }
      distance = distanceUp;
      break;
    case Direction.DOWN :
      if (villagerEvent._realY >= 11) {
        pick = true;
      }
      distance = distanceDown;
      break;
  }

  if (pick) {
    villagerEvent._currentItem = Managers.Items.getItemData('tomato');
    villagerEvent._tomatoDelay = Utils.getFrameCount(30 + Math.randomInt(60));
  } else {

    if (distance <= 2) {
      if (Utils.chance(30)) {
        villagerEvent.moveRandom();
      } else {
        villagerEvent.moveStraight(villagerEvent._direction);
      }
    } else {
      if (distanceLeft < distanceRight && distanceLeft < distanceUp && distanceLeft < distanceDown) {
        villagerEvent.moveStraight(Direction.LEFT);
      } else if (distanceRight < distanceUp && distanceRight < distanceDown) {
        villagerEvent.moveStraight(Direction.RIGHT);
      } else if (distanceUp < distanceDown) {
        villagerEvent.moveStraight(Direction.UP);
      } else {
        villagerEvent.moveStraight(Direction.DOWN);
      }
    }
  }
};

TomatoWarContent.matchTargetAtDirection = function(origin, possibleTarget, direction) {
  switch(direction) {
    case Direction.LEFT :
      if (possibleTarget._realX > origin._realX - 2) return false;

      if (possibleTarget._realY < origin._realY - 1) return false;
      if (possibleTarget._realY > origin._realY + 1) return false;

      return true;


    case Direction.RIGHT :
      if (possibleTarget._realX < origin._realX + 2) return false;

      if (possibleTarget._realY < origin._realY - 1) return false;
      if (possibleTarget._realY > origin._realY + 1) return false;

      return true;


    case Direction.UP :
      if (possibleTarget._realY > origin._realY - 2) return false;

      if (possibleTarget._realX < origin._realX - 1) return false;
      if (possibleTarget._realX > origin._realX + 1) return false;
      return true;


    case Direction.BOTTOM :
      if (possibleTarget._realY < origin._realY + 2) return false;

      if (possibleTarget._realX < origin._realX - 1) return false;
      if (possibleTarget._realX > origin._realX + 1) return false;

      return true;
  }

  return false;
};

TomatoWarContent.updateVillagerAIWithTomato = function(villagerEvent) {
  var throwTomato = false;
  var throwUp = false;
  var throwDown = false;
  var throwLeft = false;
  var throwRight = false;


  if (villagerEvent._tomatoDelay) {
    villagerEvent._tomatoDelay--;
  }

  if (this._finished) {
    throwTomato = true;
  } else if (!villagerEvent._tomatoDelay) {
    var villagers = this.getAllParticipantEvents();
    for (var v = 0; v < villagers.length; v++) {
      if (villagers[v] == villagerEvent) continue;

      throwTomato = this.matchTargetAtDirection(villagerEvent, villagers[v], villagerEvent._direction);
      if (throwTomato) break;

      switch(villagerEvent._direction) {
        case Direction.RIGHT :
        case Direction.LEFT :
          throwUp = this.matchTargetAtDirection(villagerEvent, villagers[v], Direction.UP);
          throwDown = this.matchTargetAtDirection(villagerEvent, villagers[v], Direction.DOWN);
          break;

        case Direction.UP :
          throwLeft = this.matchTargetAtDirection(villagerEvent, villagers[v], Direction.LEFT);
          throwRight = this.matchTargetAtDirection(villagerEvent, villagers[v], Direction.RIGHT);
          break;
      }
    }

    if (!throwTomato && !villagerEvent.isMoving() && Utils.chance(30)) {
      if (throwLeft) {
        villagerEvent._direction = Direction.LEFT;
        throwTomato = true;
      } else if (throwRight) {
        villagerEvent._direction = Direction.RIGHT;
        throwTomato = true;
      } else if (throwUp) {
        villagerEvent._direction = Direction.UP;
        throwTomato = true;
      } else if (throwDown) {
        villagerEvent._direction = Direction.DOWN;
        throwTomato = true;
      }
    }
  }

  if (throwTomato) {
    TomatoWarContent.throwTomato(villagerEvent.x, villagerEvent.top -1, villagerEvent._direction, villagerEvent);
    villagerEvent._currentItem = undefined;
    return;
  }

  if (!villagerEvent.isMoving()) {
    villagerEvent.moveRandom();
  }
};

TomatoWarContent.prepareWinnersData = function() {
  var participants = [{
    name : 'player',
    score : Variables.tomatoWarPlayerScore
  }, {
    name : 'Viktor',
    score : Variables.tomatoWarViktorScore
  }, {
    name : 'Brittany',
    score : Variables.tomatoWarBrittanyScore
  }, {
    name : 'Nathalia',
    score : Variables.tomatoWarNathaliaScore
  }, {
    name : 'Devin',
    score : Variables.tomatoWarDevinScore
  }];

  participants.sort(function(item1, item2){ return item2.score - item1.score; });

  this._winner = participants[0].name.toLowerCase();
  this._runnerUp = participants[1].name.toLowerCase();
  this._thirdPlace = participants[2].name.toLowerCase();
  this._fourthPlace = participants[3].name.toLowerCase();
  this._lastPlace = participants[4].name.toLowerCase();

  Variables.tomatoWarThirdPlace = participants[2].name == 'player' ? Managers.Player.getName() : participants[2].name;
  Variables.tomatoWarFourthPlace = participants[3].name == 'player' ? Managers.Player.getName() : participants[3].name;
  Variables.tomatoWarLastPlace = participants[4].name == 'player' ? Managers.Player.getName() : participants[4].name;

  for (var i = 0; i < participants.length; i++) {
    if (participants[i].name == 'player') {
      Variables.lastTomatoWarPosition = i + 1;
    }
  }

  Switches.playerWonTomatoFestival = this._winner == 'player';
  Switches.brittanyWonTomatoFestival = this._winner == 'brittany';
  Switches.nathaliaWonTomatoFestival = this._winner == 'nathalia';
  Switches.viktorWonTomatoFestival = this._winner == 'viktor';
  Switches.devinWonTomatoFestival = this._winner == 'devin';
};

TomatoWarContent.isFinished = function() {
  if (Variables.tomatoWarPlayerScore >= 500) return true;
  if (Variables.tomatoWarNathaliaScore >= 500) return true;
  if (Variables.tomatoWarBrittanyScore >= 500) return true;
  if (Variables.tomatoWarDevinScore >= 500) return true;
  if (Variables.tomatoWarViktorScore >= 500) return true;

  return false;
};

TomatoWarContent.updateFestivalStatus = function() {
  if (this.isFinished()) {
    this.prepareWinnersData();
    if (!this._finished) {
      Managers.Sound.playWhistle();
    }
    this._finished = true;
  }

  if (!this._finished) return;

  var participants = this.getAllParticipantEvents();
  for (var i = 0; i < participants.length; i++) {
    if (participants[i].isMoving()) return;
  }

  this.announceWinners();
};

TomatoWarContent.updateHud = function() {
  if (!this._hudWindow) {
    this._hudWindow = new Window_TomatoWarHud();
    Managers.Scenes._scene.addWindow(this._hudWindow);
  }
};

TomatoWarContent.update = function() {
  if (!Switches.isTomatoFestival) return;
  if (this._paused) return;
  if (this._announcingWinners) return;

  if (this._mouseDelay > 0) {
    this._mouseDelay--;
  }

  if (Switches.isInsideFestivalCompetition) {
    this.updateHud();
    this.updateBackgroundSE();
    this.updateThrownTomatoes();
    this.updateAI();

    this.updateFestivalStatus();
  }
};

TomatoWarContent.canCheckInput = function() {
  if (!Switches.isTomatoFestival) return;
  if (!Switches.isInsideFestivalCompetition) return;

  if (this._paused) return false;
  if (this._finished) return false;
};

TomatoWarContent.updateBackgroundSE = function() {
};

TomatoWarContent.announceWinners = function() {
  this._announcingWinners = true;

  Managers.Items._specialItem = undefined;
  Managers.CommonEvent.playEvent('tomato_festival_announce_winners');
};

TomatoWarContent.goBackToSquare = function() {
  Managers.Time.hour = 18;
  Managers.Time.updateTime();
  $gameMap.autoplay();

  Switches.isFestivalEnding = true;
  Switches.isInsideFestivalCompetition = false;
  Switches.hidePlayer = false;

  Managers.Items._specialItem = TomatoWarContent.previousItem;
  Managers.Health.stamina = TomatoWarContent.previousStamina;

  $gamePlayer.reserveTransfer(Maps.FESTIVAL_RECEPTION, 19, 33, Direction.DOWN, 0, false, true);
};

TomatoWarContent.getPrizeLetter = function() {
  if (Managers.Time.yearDay !== Festivals.TOMATO + 1) return;

  if (Variables.lastTomatoWarPosition > 0) {
    switch(Variables.lastTomatoWarPosition) {
      case 1:
        return ['tomato_festival_first_prize_letter'];
      case 2:
        return ['tomato_festival_second_prize_letter'];
      case 3:
        return ['tomato_festival_third_prize_letter'];
      default:
        return ['tomato_festival_no_prize_letter'];
    }
  }

  return false;
};

TomatoWarContent.getNoticeLetter = function() {
  if (Managers.Time.yearDay !== Festivals.TOMATO - 3) return;

  return ['tomato_festival_notice_letter'];
};

TomatoWarContent.getLetterList = function() {
  var prizeLetter = TomatoWarContent.getPrizeLetter();
  if (prizeLetter) return prizeLetter;

  var noticeLetter = TomatoWarContent.getNoticeLetter();
  if (noticeLetter) return noticeLetter;

  return [];
};

TomatoWarContent.isFestivalPrepared = function() {
  if (Managers.Time.yearDay == Festivals.TOMATO) {
    return Managers.Time.hour >= 10;
    // return Managers.Time.hour >= 10 && Managers.Time.hour < 18;
  }
};

TomatoWarContent.triggerToolOnFestival = function() {
  if (Managers.Time.yearDay !== Festivals.TOMATO) return;

  if (!Managers.Items.isHoldingItem('tomato')) return false;

  //If the use or OK buttons were just pressed
  if (Engine.Input.isTriggered('use') || Engine.Input.isTriggered('ok')) {
    TomatoWarContent.throwTomato($gamePlayer.x, $gamePlayer.top -1, $gamePlayer._direction, $gamePlayer);
    Managers.Items._specialItem = undefined;
    return true;
  }
};

TomatoWarContent.playCustomTvChannel = function(playFn) {
  if (Managers.Time.yearDay == Festivals.TOMATO - 1) {
    playFn('tomato');
    return true;
  }
};

TomatoWarContent.getTvChannelFrameLength = function(channelName) {
  if (channelName == 'tomato') {
    return 28;
  }
};


Managers.Content.registerContentClass(TomatoWarContent);
Managers.Festivals.registerFestival('tomato', Festivals.TOMATO, TomatoWarContent, 'isTomatoFestival', 9, "Tomato War");