const Window_FestivalHud = require('game/windows/Window_FestivalHud');

class Window_TomatoWarHud extends Window_FestivalHud {
  drawHud() {
    const x = Graphics.width - 250;
    let y = 10;

    this.changeTextColor(this.textColor(12));
    this.contents.outlineColor = this.textColor(15);
    // this.contents.outlineWidth = 1;
    this.contents.fontSize = 45;
    this.drawText(t('Score:'), x, y, 250, 'left');
    y += 40;

    this.contents.fontSize = this.standardFontSize();
    this.resetFontSettings();

    this.drawText(t('You:'), x, y, 150, 'left');
    this.drawText(Variables.tomatoWarPlayerScore, x + 160, y, 80, 'right');

    y += 25;
    this.drawText(t("Brittany:"), x, y, 150, 'left');
    this.drawText(Variables.tomatoWarBrittanyScore, x + 160, y, 80, 'right');

    y += 25;
    this.drawText(t("Nathalia:"), x, y, 150, 'left');
    this.drawText(Variables.tomatoWarNathaliaScore, x + 160, y, 80, 'right');

    y += 25;
    this.drawText(t("Devin:"), x, y, 150, 'left');
    this.drawText(Variables.tomatoWarDevinScore, x + 160, y, 80, 'right');

    y += 25;
    this.drawText(t("Viktor:"), x, y, 150, 'left');
    this.drawText(Variables.tomatoWarViktorScore, x + 160, y, 80, 'right');

    this._lastPlayerScore = Variables.tomatoWarPlayerScore;
    this._lastBrittanyScore = Variables.tomatoWarBrittanyScore;
    this._lastNathaliaScore = Variables.tomatoWarNathaliaScore;
    this._lastViktorScore = Variables.tomatoWarViktorScore;
    this._lastDevinScore = Variables.tomatoWarDevinScore;
  }

  valuesChanged() {
    if (this._lastPlayerScore != Variables.tomatoWarPlayerScore) return true;
    if (this._lastBrittanyScore != Variables.tomatoWarBrittanyScore) return true;
    if (this._lastNathaliaScore != Variables.tomatoWarNathaliaScore) return true;
    if (this._lastDevinScore != Variables.tomatoWarDevinScore) return true;
    if (this._lastViktorScore != Variables.tomatoWarViktorScore) return true;

    return false;
  }

  standardFontSize() {
    return 32;
  }
}

module.exports = Window_TomatoWarHud;
