require('game/objects/Villager');

Objects.FlowerFestivalVillager = class FlowerFestivalVillager extends Objects.Villager {
  // Make villagers ignore tree hitboxes
  isCollidedWithEvents(x, y) {
    return $gameMap.events().some(event => {
      if (!event.isNormalPriority()) return false;
      if (event.isThrough()) return false;

      if (event._x !== x) return false;
      if (event._y !== y) return false;

      return true;
    });
  }

  moveTypeRandom() {
    switch (Math.randomInt(6)) {
      case 0: case 1: case 2:
        this.moveRandom();
        break;
      case 3: case 4:
        this.moveForward();
        break;
      case 5:
        this.resetStopCount();
        break;
      default :
        break;
    }
  }  
};