require('game/objects/CustomEvent');

Objects.ChickenFestivalRacer = class Racer extends Objects.CustomEvent {
  updateMove() {
    const distancePerFrame = this.distancePerFrame();

    switch(this._direction) {
      case Direction.UP:
        this._realY -= distancePerFrame;
        break;
      case Direction.DOWN:
        this._realY += distancePerFrame;
        break;
      case Direction.LEFT:
        this._realX -= distancePerFrame;
        break;
      case Direction.RIGHT:
        this._realX += distancePerFrame;
        break;
    }
  }

  characterName() {
    if (this.isMoving()) {
      return `${ this._characterName }_running`;
    }

    return this._characterName;
  }
};
