const Window_AnimalsToSend = require('game/windows/shop/AnimalsToSend');

class Window_ChickenPicker extends Window_AnimalsToSend {
  initialize() {
    super.initialize();
    this.setButtonText(t("Race"));
  }

  makeItemList() {
    this._animalList = Managers.Creatures.getAnimalList((animal) => {
      return animal._type.includes('chicken');
    });
  }

  drawItem(index) {
    super.drawItem(index);
    if (index < 0) return;

    const rect = this.itemRect(index);
    const animalData = this._animalList[index];
    if (!animalData) {
      return;
    }

    this.drawAnimalInfo(rect, animalData);
  }

  drawAnimalInfo(rect, animalData) {
    let { x, y } = rect;
    const zoom = Graphics.windowZoomLevel;

    x += 60 * zoom;
    const w = 150 * zoom;

    this.contents.fontSize = Utils.convertFontSize(24, zoom);
    this.changeTextColor(this.blackColor());

    this.drawText(t("Speed Score") + ':', x, y, w, 'left');
    const speed = Math.round(animalData._chickenSpeed * 20);
    this.drawText(speed, x, y, w, 'right');

    y += this.lineHeight();
    this.drawText(t("Luck Score") + ':', x, y, w, 'left');
    const luck = Math.round(animalData._chickenLuck * 20);
    this.drawText(luck, x, y, w, 'right');
  }
}

module.exports = Window_ChickenPicker;
