const Scene_AnimalsToSend = require('game/scenes/shops/AnimalsToSend');
const Window_ShopCommand = require('game/windows/shop/ShopCommand');
const Window_ChickenPicker = require('./ChickenPickerWindow');

class Scene_ChickenPicker extends Scene_AnimalsToSend {
  createAnimalListWindow() {
    this._animalListWindow = new Window_ChickenPicker(this._animalTypes);
    this._animalListWindow.setHandler('ok', this.onAnimalOk.bind(this));
    this._animalListWindow.setHandler('cancel', this.onAnimalCancel.bind(this));
    this.addWindow(this._animalListWindow);
    this._animalListWindow.select(0);
    this.activateAnimalListWindow();
  }

  playCancelDialogue() {
    Managers.Villagers.playDialogue('Benjamin', 'benjamin_chicken_festival_no_chicken');
  }

  createCommandWindow() {
    this._commandWindow = new Window_ShopCommand();
    this._commandWindow.setHandler('race', this.onSendOk.bind(this));
    this._commandWindow.setHandler('cancel', this.onBuyCancel.bind(this));
    this._commandWindow.hide();
    this._commandWindow.deactivate();
    this._commandWindow.setMode('race');
    this.addWindow(this._commandWindow);
  }

  onSendOk() {
    const creature = this.animal();
    if (!creature) {
      Managers.Sound.playBuzzer();
      this.closeCommandWindow();
      return;
    }

    Variables.chickenRaceChickenId = creature._id;
    Variables.animalName = creature.creatureName;

    Managers.Villagers.playDialogue('Benjamin', 'start_chicken_event');
    this.popScene();
  }

  onBuyCancel() {
    this.closeCommandWindow();
  }
}

GameScenes.ChickenPicker = Scene_ChickenPicker;
module.exports = Scene_ChickenPicker;
