require('game/managers/Content');
require('game/managers/Festivals');
require('game/core/Constants');

function ChickenFestivalContent() {
}

ChickenFestivalContent.contentId = function() {
  return 'festival-chicken-race';
};

ChickenFestivalContent.startDay = function() {
  Variables.lastChickenFestivalPosition = 0;
  Switches.boughtFestivalAnimal = false;

  Managers.Content.runMethod('ChickenFestival_StartDay', []);
};

ChickenFestivalContent.setupMapEvents = function(firstOfTheDay) {
  if (!Switches.isChickenFestival) return;
  if ($gameMap._mapId !== Maps.FESTIVAL_RECEPTION) return;
  if (Managers.Time.hour >= 18 && !Switches.isInsideFestival) return;

  if (Managers.Time.hour < 10) {
    Managers.Festivals.leaveUnpreparedFestivalArea();
    return;
  }

  if (!Switches.isInsideFestival) {
    Managers.Festivals.enterFestival();
    this.roosterIndex = undefined;
    Variables.chickenRaceChickenId = '';
  }

  this.createFestivalEvents();
};

ChickenFestivalContent.prepareRoosterCreature = function() {
  if (this.roosterIndex === undefined) return false;

  var creatureType = 'rooster';
  if (this.roosterIndex > 0) {
    creatureType += (this.roosterIndex + 1);
  }

  var data = Managers.Creatures.prepareCoopCreature(creatureType);
  Managers.Achievements.checkAchievements();

  return data;
};

ChickenFestivalContent.createChickenEvent = function(spriteIndex, x, y, d, classType) {
  var chicken = $gameMap.createNormalEventAt('animals/chicken', spriteIndex, x, y, d, false, true, classType);
  chicken._hitboxX = 0.25;
  chicken._hitboxWidth = 0.5;
  chicken._hitboxY = 0.5;
  chicken._hitboxHeight = 0.5;

  return chicken;
};

ChickenFestivalContent.createFestivalEvents = function() {
  Managers.Villagers.killAllVillagerEvents();
  ChickenFestivalContent.clearEventReferences();

  //Food Icons
  $gameMap.createStaticIconEventAt(61, 6, 19, 1, true);
  $gameMap.createStaticIconEventAt(410, 7, 19, 1, true);
  $gameMap.createStaticIconEventAt(119, 8, 19, 1, true);
  $gameMap.createStaticIconEventAt(434, 6, 24, 1, true);
  $gameMap.createStaticIconEventAt(444, 7, 24, 1, true);
  $gameMap.createStaticIconEventAt(426, 8, 24, 1, true);

  $gameMap.createVillagerByNameAt('Benjamin', 18, 12, Direction.DOWN);
  $gameMap.createVillagerByNameAt('Julia', 20, 12, Direction.DOWN);

  $gameMap.createVillagerByNameAt('Brittany', 36, 17, Direction.LEFT);

  if (Managers.Time.year === 1) {
    if (this.roosterIndex === undefined) {
      this.roosterIndex = Math.randomInt(8);
      Variables.roosterIndex = this.roosterIndex;
    }

    var rooster = $gameMap.createNormalEventAt('animals/rooster', this.roosterIndex, 31, 7, Direction.DOWN, false, true);
    rooster._moveType = 4;
    rooster._moveFrequency = 5;
  }

  $gameMap.createVillagerByNameAt('Stella', 31, 10, Direction.DOWN);
  
  $gameMap.createVillagerByNameAt('Nathalia', 17, 17, Direction.UP);
  ChickenFestivalContent.createChickenEvent(4, 16, 17, Direction.UP);

  $gameMap.createVillagerByNameAt('Devin', 18, 17, Direction.UP);
  ChickenFestivalContent.createChickenEvent(1, 19, 17, Direction.UP);

  if (Managers.Relationship.isCharacterKnown('Annie')) {
    $gameMap.createVillagerByNameAt('Annie', 3, 20, Direction.RIGHT);
  }

  $gameMap.createVillagerByNameAt('Amanda', 28, 12, Direction.DOWN);

  $gameMap.createVillagerByNameAt('Viktor', 19, 21, Direction.UP);
  $gameMap.createVillagerByNameAt('Raphael', 21, 21, Direction.UP);
  ChickenFestivalContent.createChickenEvent(3, 22, 21, Direction.UP);

  $gameMap.createVillagerByNameAt('Mia', 23, 15, Direction.LEFT);
  ChickenFestivalContent.createChickenEvent(7, 22, 15, Direction.RIGHT);

  $gameMap.createVillagerByNameAt('Chloe', 35, 21, Direction.LEFT);
  $gameMap.createVillagerByNameAt('Serge', 35, 23, Direction.LEFT);

  $gameMap.createVillagerByNameAt('Ilda', 12, 28, Direction.RIGHT);
  $gameMap.createVillagerByNameAt('Gabriel', 13, 28, Direction.LEFT);

  $gameMap.createVillagerByNameAt('Lucas', 21, 33, Direction.UP);

  $gameMap.createVillagerByNameAt('Billy', 9, 13, Direction.DOWN);
  $gameMap.createNormalEventAt('animals/ducks', 3, 10, 13, Direction.DOWN, false, true);

  $gameMap.createVillagerByNameAt('Cindy', 24, 29, Direction.RIGHT);
  $gameMap.createVillagerByNameAt('Bonnie', 24, 28, Direction.RIGHT);
  if (!Switches.isFestivalEnding) {
    $gameMap.createVillagerByNameAt('Richard', 26, 29, Direction.LEFT);
    $gameMap.createVillagerByNameAt('Phi', 26, 28, Direction.LEFT);

    $gameMap.createVillagerByNameAt('Rory', 7, 13, Direction.DOWN);

    if (Managers.Tasks.getTaskStatus('find-pom') == TaskStatus.COMPLETED) {
      $gameMap.createVillagerByNameAt('Martin', 4, 15, Direction.DOWN);
      $gameMap.createVillagerByNameAt('Pom', 3, 15, Direction.DOWN);
    }
  }

  var suffix = '';
  if (Switches.isFestivalEnding) {
    suffix += '_ending';
  }

  Managers.Villagers.assignEvent('Brittany', 'brittany_chicken_festival' + suffix);
  Managers.Villagers.assignEvent('Benjamin', 'benjamin_chicken_festival' + suffix);
  Managers.Villagers.assignEvent('Julia', 'julia_chicken_festival' + suffix);
  Managers.Villagers.assignEvent('Viktor', 'viktor_chicken_festival' + suffix);
  Managers.Villagers.assignEvent('Serge', 'serge_chicken_festival' + suffix);
  Managers.Villagers.assignEvent('Chloe', 'chloe_chicken_festival' + suffix);
  Managers.Villagers.assignEvent('Gabriel', 'gabriel_chicken_festival' + suffix);
  Managers.Villagers.assignEvent('Lucas', 'lucas_chicken_festival' + suffix);

  if (Managers.Time.year === 1) {
    Managers.Villagers.assignEvent('Stella', 'stella_chicken_festival' + suffix + '_rooster');
  } else {
    Managers.Villagers.assignEvent('Stella', 'stella_chicken_festival' + suffix);
  }

  Managers.Villagers.assignEvent('Nathalia', 'nathalia_chicken_festival' + suffix);
  Managers.Villagers.assignEvent('Devin', 'devin_chicken_festival' + suffix);

  if (Managers.Relationship.isCharacterKnown('Annie')) {
    Managers.Villagers.assignEvent('Annie', 'annie_chicken_festival' + suffix);
  }

  Managers.Villagers.assignEvent('Raphael', 'raphael_chicken_festival' + suffix);
  Managers.Villagers.assignEvent('Mia', 'mia_chicken_festival' + suffix);
  Managers.Villagers.assignEvent('Bonnie', 'bonnie_chicken_festival' + suffix);
  Managers.Villagers.assignEvent('Cindy', 'cindy_chicken_festival' + suffix);
  Managers.Villagers.assignEvent('Billy', 'billy_chicken_festival' + suffix);
  Managers.Villagers.assignEvent('Amanda', 'amanda_chicken_festival' + suffix);
  Managers.Villagers.assignEvent('Ilda', 'ilda_chicken_festival' + suffix);

  if (!Switches.isFestivalEnding) {
    Managers.Villagers.assignEvent('Rory', 'rory_chicken_festival' + suffix);

    Managers.Villagers.assignEvent('Richard', 'richard_chicken_festival' + suffix);
    Managers.Villagers.assignEvent('Phi', 'phi_chicken_festival' + suffix);

    Managers.Villagers.assignEvent('Martin', 'martin_chicken_festival' + suffix);
    Managers.Villagers.assignEvent('Pom', 'pom_chicken_festival' + suffix);
  }
};

ChickenFestivalContent.startEvent = function() {
  ChickenFestivalContent.clearEventReferences();
  Switches.playerWonChickenFestival = false;
  Switches.playerLostChickenFestival = false;
  Switches.devinWonChickenFestival = false;
  Switches.miaWonChickenFestival = false;
  Switches.raphaelWonChickenFestival = false;
  Switches.nathaliaWonChickenFestival = false;
  Switches.isInsideFestivalCompetition = true;
  Switches.lockInputForFestival = true;

  Switches.hidePlayer = true;
  $gameMap.centerCameraOn(1, 9, 5);

  var playersChicken;
  Variables.chicken0Name = '';

  if (Variables.chickenRaceChickenId) {
    const animalData = Managers.Creatures.getCreatureById(Variables.chickenRaceChickenId);

    if (animalData) {
      var creatureType = animalData.getCreatureType();
      var spriteName = creatureType.getSpriteName(animalData);
      var spriteIndex = creatureType.getSpriteIndex(animalData);
      Variables.chicken0Name = animalData.creatureName;

      playersChicken = $gameMap.createNormalEventAt(spriteName, spriteIndex, 2, 8, Direction.RIGHT, false, true, Objects.ChickenFestivalRacer);
      playersChicken.id = animalData._id;
      $gameMap.createNormalEventAt($gamePlayer._characterName, $gamePlayer._characterIndex, 31, 8, Direction.LEFT, false, true);
    }
  }

  $gameMap.createVillagerByNameAt('Nathalia', 31, 9, Direction.LEFT);
  var nathaliasChicken = ChickenFestivalContent.createChickenEvent(4, 2, 9, Direction.RIGHT, Objects.ChickenFestivalRacer);

  $gameMap.createVillagerByNameAt('Devin', 31, 10, Direction.LEFT);
  var devinsChicken = ChickenFestivalContent.createChickenEvent(1, 2, 10, Direction.RIGHT, Objects.ChickenFestivalRacer);

  $gameMap.createVillagerByNameAt('Raphael', 31, 11, Direction.LEFT);
  var raphaelsChicken = ChickenFestivalContent.createChickenEvent(3, 2, 11, Direction.RIGHT, Objects.ChickenFestivalRacer);

  $gameMap.createVillagerByNameAt('Mia', 31, 12, Direction.LEFT);
  var miasChicken = ChickenFestivalContent.createChickenEvent(7, 2, 12, Direction.RIGHT, Objects.ChickenFestivalRacer);

  $gameMap.createVillagerByNameAt('Benjamin', 29, 4, Direction.DOWN);
  $gameMap.createVillagerByNameAt('Julia', 2, 4, Direction.DOWN);

  $gameMap.createVillagerByNameAt('Viktor', 6, 4, Direction.DOWN);
  $gameMap.createVillagerByNameAt('Serge', 8, 4, Direction.DOWN);

  $gameMap.createVillagerByNameAt('Chloe', 9, 4, Direction.DOWN);
  $gameMap.createVillagerByNameAt('Gabriel', 10, 4, Direction.DOWN);
  $gameMap.createVillagerByNameAt('Rory', 11, 4, Direction.DOWN);
  $gameMap.createVillagerByNameAt('Billy', 12, 4, Direction.DOWN);
  $gameMap.createNormalEventAt('animals/ducks', 3, 13, 4, Direction.DOWN, false, true);

  $gameMap.createVillagerByNameAt('Lucas', 14, 4, Direction.DOWN);
  $gameMap.createVillagerByNameAt('Brittany', 15, 4, Direction.DOWN);
  $gameMap.createVillagerByNameAt('Stella', 16, 4, Direction.DOWN);

  $gameMap.createVillagerByNameAt('Cindy', 18, 4, Direction.DOWN);
  $gameMap.createVillagerByNameAt('Bonnie', 19, 4, Direction.DOWN);

  $gameMap.createVillagerByNameAt('Richard', 21, 4, Direction.DOWN);
  $gameMap.createVillagerByNameAt('Phi', 22, 4, Direction.DOWN);

  $gameMap.createVillagerByNameAt('Annie', 25, 4, Direction.DOWN);
  

  this.chicken0 = playersChicken;
  this.chicken1 = nathaliasChicken;
  this.chicken2 = devinsChicken;
  this.chicken3 = raphaelsChicken;
  this.chicken4 = miasChicken;

  Variables.chicken1Name = t('nathalias_chicken_name');
  Variables.chicken2Name = t('devins_chicken_name');
  Variables.chicken3Name = t('raphaels_chicken_name');
  Variables.chicken4Name = t('mias_chicken_name');

  this.first = undefined;
  this.second = undefined;
  this.third = undefined;
  this.fourth = undefined;
  this.fifth = undefined;

  Managers.CommonEvent.playEvent('chicken_race_announcement');
};

ChickenFestivalContent.makeThemRun = function() {
  if (ChickenFestivalContent.chicken0) {
    ChickenFestivalContent.chicken0._moveType = 5;
    ChickenFestivalContent.chicken0._moveFrequency = 5;
  }

  ChickenFestivalContent.chicken1._moveType = 5;
  ChickenFestivalContent.chicken2._moveType = 5;
  ChickenFestivalContent.chicken3._moveType = 5;
  ChickenFestivalContent.chicken4._moveType = 5;

  ChickenFestivalContent.chicken1._moveFrequency = 5;
  ChickenFestivalContent.chicken2._moveFrequency = 5;
  ChickenFestivalContent.chicken3._moveFrequency = 5;
  ChickenFestivalContent.chicken4._moveFrequency = 5;

  this.intervalHandler = setInterval(ChickenFestivalContent.changeChickenSpeeds, 300);
  this._checkPositions = true;
};

ChickenFestivalContent.changeChickenSpeeds = function() {
  var chickens = [];

  const stats = {
    nathaliasChicken: {
      speed: 3.2,
      luck: 2
    },
    devinsChicken: {
      speed: 1.2,
      luck: 5
    },
    raphaelsChicken: {
      speed: 1.8,
      luck: 2
    },
    miasChicken: {
      speed: 3.6,
      luck: 4
    }
  };

  function calculateMoveSpeed(chickenStats, chicken) {
    const chance = Math.ceil(chickenStats.speed * 6);
    const luck = Math.ceil(chickenStats.luck / 2) + 1;

    if (chicken) {
      //The higher the luck of the chicken, the more chances it has at getting the speed boost
      let boostChances = luck;
      while (boostChances > 0) {
        chickens.push(chicken);
        boostChances--;
      }
    }

    return 3 + (luck + Math.randomInt(chance - luck)) * 0.025;
  }

  if (ChickenFestivalContent.chicken0) {
    const animalData = Managers.Items.getItemInfo('animalData');
    let speed = 1;
    let luck = 1;

    if (animalData) {
      speed = animalData._chickenSpeed;
      luck = animalData._chickenLuck;
    }

    const stats = {
      speed,
      luck
    };

    ChickenFestivalContent.chicken0._moveSpeed = calculateMoveSpeed(stats, ChickenFestivalContent.chicken0);
    ChickenFestivalContent.chicken0._boosting = false;
  }

  ChickenFestivalContent.chicken1._moveSpeed = calculateMoveSpeed(stats.nathaliasChicken, ChickenFestivalContent.chicken1);
  ChickenFestivalContent.chicken1._boosting = false;
  ChickenFestivalContent.chicken2._moveSpeed = calculateMoveSpeed(stats.devinsChicken, ChickenFestivalContent.chicken2);
  ChickenFestivalContent.chicken2._boosting = false;
  ChickenFestivalContent.chicken3._moveSpeed = calculateMoveSpeed(stats.raphaelsChicken, ChickenFestivalContent.chicken3);
  ChickenFestivalContent.chicken3._boosting = false;
  ChickenFestivalContent.chicken4._moveSpeed = calculateMoveSpeed(stats.miasChicken, ChickenFestivalContent.chicken4);
  ChickenFestivalContent.chicken4._boosting = false;

  // One random chicken gets a chance at max speed
  const idx = Math.randomInt(chickens.length);
  const newSpeed = calculateMoveSpeed({ speed: 5, luck: 5 });

  chickens[idx]._moveSpeed = Math.max(chickens[idx]._moveSpeed, newSpeed);
  chickens[idx]._boosting = true;
  // if (chickens[idx].isMoving()) {
  //   chickens[idx].requestBalloon(Balloons.DROP);
  // }
};

ChickenFestivalContent.clearEventReferences = function() {
  delete this.chicken0;
  delete this.chicken1;
  delete this.chicken2;
  delete this.chicken3;
  delete this.chicken4;
  delete this.first;
  delete this.second;
  delete this.third;
  delete this.fourth;
  delete this.fifth;

  if (this.intervalHandler !== undefined) {
    clearInterval(this.intervalHandler);
  }
};

ChickenFestivalContent.update = function() {
  if (!Switches.isChickenFestival) return;

  if (this._checkPositions) {
    this.checkPositions();
  }

  if (Switches.isInsideFestivalCompetition) {
    this.updateBackgroundSE();
  }
};

ChickenFestivalContent.updateBackgroundSE = function() {
  if (!!this._backgroundSEDelay && this._backgroundSEDelay > 0) {
    this._backgroundSEDelay--;
    return;
  }

  if (Math.randomInt(100) < 5) {
    Managers.Sound.playRandomChickenSound();
    this._backgroundSEDelay = Utils.getFrameCount(60);
  }
};

ChickenFestivalContent.checkPositions = function(){
  if (!this._checkPositions) return;

  if (!this.chicken1) return;
  if (!this.chicken2) return;
  if (!this.chicken3) return;
  if (!this.chicken4) return;

  function storeNextChicken(chicken) {
    if (!ChickenFestivalContent.first || ChickenFestivalContent.first == chicken) {
      ChickenFestivalContent.first = chicken;
      return;
    }

    if (!ChickenFestivalContent.second || ChickenFestivalContent.second == chicken) {
      ChickenFestivalContent.second = chicken;
      return;
    }

    if (!ChickenFestivalContent.third || ChickenFestivalContent.third == chicken) {
      ChickenFestivalContent.third = chicken;
      return;
    }

    if (!ChickenFestivalContent.fourth || ChickenFestivalContent.fourth == chicken) {
      ChickenFestivalContent.fourth = chicken;
      return;
    }

    ChickenFestivalContent.fifth = chicken;
  }

  if (this.chicken0) {
    if (this.chicken0._realX >= 30) {
      this.chicken0._moveType = 0;
      this.chicken0._x = this.chicken0._realX;
      storeNextChicken(this.chicken0);
    }
  }

  if (this.chicken1._realX >= 30) {
    this.chicken1._moveType = 0;
    this.chicken1._x = this.chicken1._realX;
    storeNextChicken(this.chicken1);
  }

  if (this.chicken2._realX >= 30) {
    this.chicken2._moveType = 0;
    this.chicken2._x = this.chicken2._realX;
    storeNextChicken(this.chicken2);
  }

  if (this.chicken3._realX >= 30) {
    this.chicken3._moveType = 0;
    this.chicken3._x = this.chicken3._realX;
    storeNextChicken(this.chicken3);
  }

  if (this.chicken4._realX >= 30) {
    this.chicken4._moveType = 0;
    this.chicken4._x = this.chicken4._realX;
    storeNextChicken(this.chicken4);
  }


  if (this.fifth || (!this.chicken0 && this.fourth)) {
    this._checkPositions = false;
    $gameTemp.setTimeout(ChickenFestivalContent.announceWinners, 30);
  }
};

ChickenFestivalContent.announceWinners = function() {
  var chickens = [];
  if (ChickenFestivalContent.chicken0) {
    chickens.push(ChickenFestivalContent.chicken0);
  } else {
    chickens.push('nope');
  }

  chickens.push(ChickenFestivalContent.chicken1);
  chickens.push(ChickenFestivalContent.chicken2);
  chickens.push(ChickenFestivalContent.chicken3);
  chickens.push(ChickenFestivalContent.chicken4);

  var names = [Variables.chicken0Name, Variables.chicken1Name, Variables.chicken2Name, Variables.chicken3Name, Variables.chicken4Name];

  var firstIdx = chickens.indexOf(ChickenFestivalContent.first);
  var secondIdx = chickens.indexOf(ChickenFestivalContent.second);
  var thirdIdx = chickens.indexOf(ChickenFestivalContent.third);
  var fourthIdx = chickens.indexOf(ChickenFestivalContent.fourth);
  var fifthIdx = -1;

  if (ChickenFestivalContent.fifth) {
    fifthIdx = chickens.indexOf(ChickenFestivalContent.fifth);

    Variables.lastChickenFestivalPosition = [false, ChickenFestivalContent.first, ChickenFestivalContent.second, ChickenFestivalContent.third, ChickenFestivalContent.fourth, ChickenFestivalContent.fifth].indexOf(ChickenFestivalContent.chicken0);
  } else {
    Variables.lastChickenFestivalPosition = 0;
  }

  Variables.winnerChicken = names[firstIdx];
  Variables.runnerUpChicken = names[secondIdx];
  Variables.thirdChicken = names[thirdIdx];
  Variables.fourthChicken = names[fourthIdx];
  Variables.fifthChicken = names[fifthIdx];

  Switches.playerWonChickenFestival = firstIdx === 0;
  Switches.nathaliaWonChickenFestival = firstIdx === 1;
  Switches.devinWonChickenFestival = firstIdx === 2;
  Switches.raphaelWonChickenFestival = firstIdx === 3;
  Switches.miaWonChickenFestival = firstIdx === 4;
  if (ChickenFestivalContent.chicken0) {
    Switches.playerLostChickenFestival = !Switches.playerWonChickenFestival;
  } else {
    Switches.playerLostChickenFestival = false;
  }

  if (Switches.playerWonChickenFestival) {
    Variables.chickenRaceVictories += 1;
  }

  Managers.Content.runMethod('ChickenFestival_AnnounceWinners', [chickens, ChickenFestivalContent.chicken0]);

  if (fifthIdx >= 0) {
    Managers.CommonEvent.playEvent('chicken_festival_announce_winners_with_player');
  } else {
    Managers.CommonEvent.playEvent('chicken_festival_announce_winners');
  }
};

ChickenFestivalContent.goBackToSquare = function() {
  Managers.Time.hour = 18;
  Managers.Time.updateTime();
  $gameMap.autoplay();

  Switches.isFestivalEnding = true;
  Switches.isInsideFestivalCompetition = false;
  Switches.lockInputForFestival = false;
  Switches.hidePlayer = false;

  $gamePlayer.reserveTransfer(Maps.FESTIVAL_RECEPTION, 19, 33, Direction.UP, 0, false, true);
};

ChickenFestivalContent.getPrizeLetter = function() {
  if (Managers.Time.yearDay !== Festivals.CHICKEN + 1) return;

  if (Variables.lastChickenFestivalPosition > 0) {
    switch(Variables.lastChickenFestivalPosition) {
      case 1:
        return ['chicken_festival_first_prize_letter'];
      case 2:
        return ['chicken_festival_second_prize_letter'];
      case 3:
        return ['chicken_festival_third_prize_letter'];
      default:
        return ['chicken_festival_no_prize_letter'];
    }
  }

  return false;
};

ChickenFestivalContent.getNoticeLetter = function() {
  if (Managers.Time.yearDay !== Festivals.CHICKEN - 1) return;

  return ['chicken_festival_notice_letter'];
};

ChickenFestivalContent.getLetterList = function() {
  var prizeLetter = ChickenFestivalContent.getPrizeLetter();
  if (prizeLetter) return prizeLetter;

  var noticeLetter = ChickenFestivalContent.getNoticeLetter();
  if (noticeLetter) return noticeLetter;

  return [];
};

ChickenFestivalContent.applyItemDataModifiers = function(data) {
  if (data.id == 'egg' || data.id == 'fertilized-egg') {
    data.sellPrice = Math.floor(data.sellPrice * (1 + (Variables.chickenRaceVictories / 10)));
  }

  return data;
};

ChickenFestivalContent.isFestivalPrepared = function() {
  if (Managers.Time.yearDay == Festivals.CHICKEN) {
    return Managers.Time.hour >= 10;
    // return Managers.Time.hour >= 10 && Managers.Time.hour < 18;
  }
};

ChickenFestivalContent.playCustomTvChannel = function(playFn) {
  if (Managers.Time.yearDay == Festivals.CHICKEN - 1) {
    playFn('chicken');
    return true;
  }
};

ChickenFestivalContent.getTvChannelFrameLength = function(channelName) {
  if (channelName == 'chicken') {
    return 28;
  }
};

ChickenFestivalContent.parsePluginCommand = function(parser, command, args) {
  if (command.toUpperCase() !== 'CHICKENFESTIVAL') return;

  if (parser.upperName === 'PICKCHICKEN') {
    Managers.Scenes.snapForBackground();
    Managers.Scenes.push(GameScenes.ChickenPicker);
    return true;
  }
};

Managers.Content.registerContentClass(ChickenFestivalContent);
Managers.Festivals.registerFestival('chicken', Festivals.CHICKEN, ChickenFestivalContent, 'isChickenFestival', 336, "Chicken Race");