require('game/managers/Content');

class PlayerHouseContent {
  static contentId() {
    return 'farm#playerHouse';
  }

  static winterCompatibleSpriteName(spriteName) {
    if (Managers.Time.month == Seasons.WINTER) {
      return `${ spriteName }_snow`;
    }

    return spriteName;
  }

  static setupMapEvents() {
    if ($gameMap._mapId != Maps.FARM) return;

    if (Switches.builtSecondFloor) {
      PlayerHouseContent.createHouseWithSecondFloor();
    } else if (Switches.expandedHouse) {
      PlayerHouseContent.createHouseWithKitchen();
    } else {
      PlayerHouseContent.createInitialHouse();
    }
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() === 'FARM') {
      if (parser.name.toUpperCase() === 'DOOR' && parser.nextUpperArg(true) === 'PLAYER') {
        const farmMap = Managers.Map.getClass(Maps.FARM);
        farmMap.doFarmHouseDoor();
        return true;
      }

      if (parser.upperName === 'STORAGE') {
        Managers.Items.doStorageEvent();
        return true;
      }

      if (parser.upperName === 'SHIPPING_BIN') {
        Managers.Items.doShippingBinEvent();
        return true;
      }
    }

    if (command.toUpperCase() === 'SAVE_SLEEP') {
      if ($gameTemp.getLoadedGamePath()) {
        $gameTemp.requestAutoSaveLoadedSlot();
      } else {
        Managers.Scenes.push(GameScenes.SaveGame);
      }

      return true;
    }

    if (command.toUpperCase() === 'SAVE_MENU') {
      Managers.Scenes.push(GameScenes.SaveGame);
      return true;
    }
  }

  static createInitialHouse() {
    const x = 34;
    const y = 8;

    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/player/initial/$$$ground'), x, y + 1, 0);
    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/player/initial/$$$house'), x, y, 1);

    $gameMap.createDoorEvent('houses/doors', 0, 5, x, y, 'Player', 0, 0, 'farm');
    $gameMap.createCollisionArea(x - 2, y - 2.5, 5, 3.5);
  }

  static createHouseWithKitchen() {
    const x = 34;
    const y = 8;

    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/player/kitchen/$$$ground'), x - 2, y + 1, 0, 16);
    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/player/kitchen/$$$house'), x - 2, y, 1, 16);

    $gameMap.createDoorEvent('houses/doors', 0, 5, x, y, 'Player', 0, 0, 'farm');
    $gameMap.createCollisionArea(x - 5, y - 2.5, 8, 3.5);
  }

  static createHouseWithSecondFloor() {
    const x = 34;
    const y = 8;

    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/player/second-floor/$$$ground'), x - 2, y + 1, 0, 16);
    $gameMap.createSingleSpriteEventAt(this.winterCompatibleSpriteName('houses/player/second-floor/$$$house'), x - 2, y, 1, 16);

    $gameMap.createDoorEvent('houses/doors', 0, 5, x, y, 'Player', 0, 0, 'farm');
    $gameMap.createCollisionArea(x - 5, y - 2.5, 8, 3.5);
  }

  static processNewDay() {
    if (Switches.hiredRaphael) {
      if (Managers.Weather.isBadWeather()) {
        Switches.isExpandingHouse = false;
      } else {
        Switches.isExpandingHouse = true;
        Variables.daysRaphaelWorked++;
      }


      if (Switches.expandedHouse) {
        if (Variables.daysRaphaelWorked >= 5) {
          Switches.builtSecondFloor = true;
          Switches.hiredRaphael = false;
          Switches.isExpandingHouse = false;
          Switches.playerNeedsToKnowAboutExpansion = true;

          Managers.Creatures.moveMapCreatures(Maps.HOME_2, Maps.HOME_3);
          Managers.FarmObjects.moveMapContent(Maps.HOME_2, Maps.HOME_3);
          // #ToDo: Move to the second floor
          $gamePlayer.reserveTransfer(Maps.HOME_3B, 16, 5, 2, 0, true);
        }
      } else {
        if (Variables.daysRaphaelWorked >= 3) {
          Switches.expandedHouse = true;
          Switches.hiredRaphael = false;
          Switches.isExpandingHouse = false;
          Switches.playerNeedsToKnowAboutExpansion = true;

          Managers.Creatures.moveMapCreatures(Maps.HOME, Maps.HOME_2);
          Managers.FarmObjects.moveMapContent(Maps.HOME, Maps.HOME_2);
          $gamePlayer.reserveTransfer(Maps.HOME_2, $gamePlayer.x, $gamePlayer.y, $gamePlayer._direction, 0, true);
        }
      }
    }
  }

  static getCurrentSchedule(villagerName) {
    if (villagerName.toLowerCase() != 'raphael') return;
    if (Switches.isExpandingHouse) return 'working';
  }

  static checkCutscenes(mapId) {
    if (!Switches.playerNeedsToKnowAboutExpansion) return false;
    if (mapId != Maps.FARM) return false;
    if (!$gameMap.isHome()) return false;

    $gameTemp.reserveCutscene('raphael_telling_about_house_expansion_complete');
  }
}

Managers.Content.registerContentClass(PlayerHouseContent);