require('game/managers/Content');

class FarmContent {
  static contentId() {
    return 'farm';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'FARM') {
      return;
    }

    if (parser.upperName === 'COOP') {
      const coopMap = Managers.Map.getClass(Maps.COOP);

      if (parser.nextUpperArg() === 'FEED') {
        coopMap.checkFeedingBin();
        return true;
      }
    }

    if (parser.upperName === 'BARN') {
      const barnMap = Managers.Map.getClass(Maps.BARN);
      if (parser.nextUpperArg() === 'FEED') {
        barnMap.checkHayPile();
        return true;
      }
    }

    if (parser.upperName === 'ANIMAL') {
      // const creature = Variables.creatureData;
      if (parser.nextUpperArg() === 'MOUNT') {
        $gamePlayer.mountOnAnimalEvent(Variables.creatureEvent);
        return true;
      }
    }
  }

  static parseConditionCommand(parser, command, args) {
    if (command.toUpperCase() !== 'FARM') {
      return;
    }

    if (parser.upperName === 'ANIMAL') {
      const creature = Variables.creatureData;
      let value;

      switch(parser.nextUpperArg(true)) {
        case 'AGE':
          value = creature.age;
          break;
        case 'UPSETLEVEL':
          value = creature.upsetLevel;
          break;
        case 'MILKED':
          return Boolean(creature.milked);
        case 'SHEARED':
          return Boolean(creature.sheared);
        case 'HASMILK':
          return Boolean(creature.hasMilk);
        case 'HASWOOL':
          return Boolean(creature.hasWool);
        case 'SPOKENTO':
          return Boolean(creature.spokenTo);
      }

      const operation = parser.nextArgMaybeVariable(true);
      const newValue = parser.remainingLineMaybeVariable(true);
      return Utils.compareValues(value, newValue, operation);
    }
  }
}

Managers.Content.registerContentClass(FarmContent);