require('game/managers/Content');
require('game/core/Constants');

(function(){
  const shadows = [
    {
      id: 'mountain_top_emerald',
      mapId: Maps.MOUNTAIN_TOP,
      x : 56,
      y : 14,
      triggerItemId : 'blackberry',
      rewardItemId : 'emerald',
      jumpDistance : 2
    },
    {
      id: 'mountain_top_golden_orange',
      mapId: Maps.MOUNTAIN_TOP,
      x : 65,
      y : 4,
      triggerItemId : 'orange',
      rewardItemId : 'golden-orange',
      jumpDistance : 2
    },
    {
      id: 'mountain_north_white_crystal',
      mapId: Maps.MOUNTAIN,
      x : 24,
      y : 3,
      triggerItemId : 'watermelon',
      rewardItemId : 'white-crystal',
      jumpDistance : 2
    },
    {
      id: 'forest_emerald',
      mapId: Maps.FOREST,
      x : 19,
      y : 64,
      triggerItemId : 'frog-legs',
      rewardItemId : 'emerald',
      jumpDistance : 1
    }
  ];

  const statuses = {};
  const events = {};

  function clearShadowStatuses() {
    for (var key in statuses) {
      delete statuses[key];
    }
  }

  function clearEvents() {
    for (var key in events) {
      delete events[key];
    }
  }

  function getShadowStatus(cloudId) {
    return statuses[cloudId] || false;
  }

  function setShadowStatus(cloudId, status) {
    statuses[cloudId] = status;
  }

  //Magic thunder will display a thunder animation on the event and then change the shadow status
  function performMagicThunder(shadowData) {
    var shadowId = shadowData.id;
    var x = shadowData.x;
    var y = shadowData.y;
    var triggerItemId = shadowData.triggerItemId;

    var itemEvents = $gameMap.farmObjectsXy(x, y);
    var oldEvent = false;

    for (var i = 0; i < itemEvents.length; i++) {
      if (!itemEvents[i]) continue;
      if (itemEvents[i]._erased) continue;

      var data = itemEvents[i]._farmObjectData;
      if (!data) continue;
      if (data.itemName != triggerItemId) continue;

      oldEvent = itemEvents[i];
      break;
    }

    if (oldEvent) {
      if (events[shadowId]) {
        events[shadowId].erase();
      }

      oldEvent._farmObjectData.clear();
      // $gamePlayer.jumpBack(shadowData.jumpDistance);
      oldEvent.erase();

      events[shadowId] = null;

      var oldItemData = Managers.Items.getItemData(triggerItemId);
      var iconIndex = oldItemData ? oldItemData.iconIndex : 0;

      var thunderEvent = $gameMap.createStaticIconEventAt(iconIndex, x, y, 0, true, undefined, true);

      $gameTemp.setTimeout(() => {
        thunderEvent.requestAnimation(Constants.TELEPORT_ANIMATION);
        $gameTemp.setTimeout(() => {
          thunderEvent.erase();

          setShadowStatus(shadowId, true);
          Managers.FarmObjects.createItemAt($gameMap._mapId, x, y, shadowData.rewardItemId, 1);
        }, 6);
      }, 15);
    }
  }

  //////////////////////////////
  // Content Class
  //////////////////////////////
  function DwarfCloudsContent() {
  }

  DwarfCloudsContent.contentId = function() {
    return 'dwarf-clouds';
  };

  DwarfCloudsContent.onLoadModManager = function() {
    // Managers.Mods.addInternalModTranslationFile('updates', 'brazilian', 'brazilian.json');
  };

  DwarfCloudsContent.setupMapEvents = function(firstOfTheDay) {
    if (!Managers.Weather.isRaining()) return;

    clearEvents();
    shadows.forEach(function(shadow){
      if (shadow.mapId != $gameMap._mapId) return;

      const status = getShadowStatus(shadow.id);
      if (status !== false) return;

      events[shadow.id] = $gameMap.createShadowEventAt(shadow.x, shadow.y);
    });
  };

  DwarfCloudsContent.checkSpecialItemDrop = function(targetX, targetY) {
    if (!Managers.Items.selectedItem) return;
    if (Managers.Items.specialItem) return;

    var createdAny = false;

    shadows.forEach(function(shadow) {
      if (createdAny) return;
      if (shadow.mapId != $gameMap._mapId) return;
      if (shadow.x != targetX) return;
      if (shadow.y != targetY) return;

      var event = events[shadow.id];
      if (!event) return;

      const status = getShadowStatus(shadow.id);
      if (status !== false) {
        return;
      }

      var farmObjects = $gameMap.farmObjectsXy(targetX, targetY);
      if (farmObjects.length > 0) return;

      var itemId = Managers.Items.selectedItem.id;

      Managers.FarmObjects.createItemAt($gameMap._mapId, targetX, targetY, itemId, 1);
      Managers.Items.loseUnitOfSelectedItem();
      createdAny = true;

      Managers.Items._onDropItem(targetX, targetY, itemId, 1, false, true);
    });

    if (createdAny) return true;
  };

  DwarfCloudsContent.onDropItem = function(x, y, id, amount) {
    shadows.forEach(function(shadow){
      if (shadow.mapId != $gameMap._mapId) return;
      if (shadow.x != x) return;
      if (shadow.y != y) return;
      if (shadow.triggerItemId != id) return;

      const status = getShadowStatus(shadow.id);
      if (status !== false) return;

      var event = events[shadow.id];
      if (!event) return;

      performMagicThunder(shadow);
    });
  };

  DwarfCloudsContent.makeSaveContents = function(contents) {
    contents.dwarfClouds = statuses;
  };

  DwarfCloudsContent.extractSaveContents = function(contents) {
    clearShadowStatuses();
    if (contents.dwarfClouds) {
      shadows.forEach(function(shadow){
        if (contents.dwarfClouds[shadow.id]) {
          setShadowStatus(shadow.id, contents.dwarfClouds[shadow.id]);
        }
      });
    }
  };

  DwarfCloudsContent.setupNewGame = function() {
    clearShadowStatuses();
  };

  Managers.Content.registerContentClass(DwarfCloudsContent);
})();
