const dropCompanion = () => {
  if ($gameParty.hasCompanion()) {
    $gameParty.dropCompanion();
  }
};

const setCompanion = (name) => {
  if (!$gameParty.isVillagerOnParty(name)) {
    dropCompanion();
    $gameParty.addVillager(name);
  }
};

const dropRide = () => {
  if ($gamePlayer.isRiding()) {
    $gameMessage.addText('Jump off your animal before activating this cutscene.');
  }
};

const forgetFriend = (name) => {
  if (Managers.Relationship.isCharacterKnown(name)) {
    Managers.Relationship.data.knownVillagers = Managers.Relationship.data.knownVillagers.filter((item) => {
      return item !== name;
    });
  }
};

const setHearts = (name, hearts) => {
  if (Managers.Relationship.getHeartsNum(name) < hearts) {
    Managers.Relationship.data.friendship[name] = Managers.Relationship.getFriendshipLevels()[hearts * 2 - 1] + 1;
  }
};

// #ToDo: Move this to a YAML file and use the file when triggering too (similtar to visitors.yaml)

// #ToDo: add dates
// #ToDo: add visitors
const cutscenes = [
  {
    name: 'raphael_tutorial',
    method: () => {
      if (Managers.Time.day < 3) {
        Managers.Time.day = 3;
      }

      Managers.Time.hour = 6;
      Switches.playedRaphaelTutorial = false;

      if (!Managers.Items.canGainItemId('coop')) {
        $gameMessage.addText('Clear an item slot and then leave your house to trigger the cutscene.');
      } else {
        $gameMessage.addText('Leave your house to trigger the cutscene.');
      }
    }
  },
  {
    name: 'raphael_telling_about_house_expansion_complete',
    method: () => {
      Switches.playerNeedsToKnowAboutExpansion = true;
      $gameMessage.addText('Leave your house to trigger the cutscene.');
    }
  },
  {
    name: 'amanda_tell_about_flower_festival',
    method: () => {
      Managers.Time.month = 1;
      Managers.Time.day = Festivals.FLOWER;
      Managers.Time.hour = 6;

      Switches.amandaToldAboutFlowerFestival = false;
      $gameMessage.addText('Leave your house to trigger the cutscene.');
    }
  },
  {
    name: 'chloe_food_ruined',
    method: () => {
      dropCompanion();

      Switches.playedChloesFoodBurntEvent = false;
      Switches.canShowChloeFoodBurntEvent = true;
      Managers.Time.hour = 10;

      Managers.Relationship.markCharacterAsKnown('Chloe');
      $gameMessage.addText('Enter the restaurant through the main door to trigger this cutscene.');
    }
  },
  {
    name: 'saci_introduction',
    method: () => {
      dropCompanion();

      Switches.playedChloesFoodBurntEvent = true;
      Switches.playedSaciIntroduction = false;
      Managers.Time.hour = 6;
      $gameMessage.addText('Enter the mountain from the town to trigger this cutscene.');
    }
  },
  {
    name: 'julia_story_explanation',
    method: () => {
      Switches.playedStoryExplanation = false;
      Variables.itemsShipped += 1;
      if (Managers.Time.day < 5) {
        Managers.Time.day = 5;
      }

      Managers.Time.hour = 6;
      $gameMessage.addText('Leave your house to trigger the cutscene.');
    }
  },
  {
    name: 'julia_story_first_idea',
    method: () => {
      Switches.playedStoryExplanation = true;
      Switches.playedStoryFirstIdea = false;
      if (Managers.Time.day < 10) {
        Managers.Time.day = 10;
      }
      Managers.Time.hour = 6;
      $gameMessage.addText('Leave your house to trigger the cutscene.');
    }
  },
  {
    name: 'annie_introduction_scene',
    method: () => {
      Switches.playedAnnieIntroduction = false;
      dropRide();
      dropCompanion();
      forgetFriend('Annie');
      $gameMessage.addText('Enter the forest center to trigger the cutscene');
    }
  },
  {
    name: 'annie_heart_event_zero',
    method: () => {
      Switches.playedAnnieZeroHearts = false;
      dropCompanion();
      dropRide();
      Managers.Time.hour = 10;
      Managers.Weather.currentWeather = 0;
      $gameMessage.addText('Enter Orange Town to trigger the cutscene');
    }
  },
  {
    name: 'annie_heart_event_one',
    method: () => {
      Switches.playedAnnieFirstHeart = false;
      Switches.playedAnnieZeroHearts = true;
      dropCompanion();
      dropRide();
      Managers.Time.hour = 13;
      $gameMessage.addText('Enter the restaurant through the main door to trigger the cutscene.');
    }
  },
  {
    name: 'benjamin_offer_to_make_hay',
    method: () => {
      dropRide();
      Managers.Relationship.markCharacterAsKnown('Benjamin');
      Managers.Time.hour = 6;

      if (Managers.Time.yearDay < 10) {
        Managers.Time.day = 10;
      }
      Switches.unlockedBenjiHayTask = true;
      Managers.Tasks.setTaskStatus('benjamin-making-hay', 0);
      $gameMessage.addText('Leave your house to trigger the cutscene');
    }
  },
  {
    name: 'benjamin_heart_event_0',
    method: () => {
      dropRide();
      Managers.Relationship.markCharacterAsKnown('Benjamin');
      Managers.Time.hour = 11;
      Switches.benjaminOpenedUp = true;
      Switches.unlockedNathaliaEvents = true;
      Switches.playedBenjaminHeartEvent0 = false;
      dropCompanion();
      $gameMessage.addText('Enter the restaurant to trigger the cutscene');
    }
  },
  {
    name: 'cindy_events_0_hearts',
    method:() => {
      dropRide();
      Managers.Relationship.markCharacterAsKnown('Cindy');
      Switches.burnedBridgesWithCindy = false;
      dropCompanion();
      Switches.playedCindyHeartEvent0 = false;
      Managers.Relationship.markCharacterAsKnown('Rory');
      Managers.Relationship.markCharacterAsKnown('Raphael');
      Switches.unlockedCindyEvents = true;

      $gameMessage.addText('Enter Rory farm to trigger the cutscene');
    }
  },
  {
    name: 'cindy_events_1_heart',
    method: () => {
      dropRide();
      Switches.playedCindyHeartEvent1 = false;
      Switches.playedCindyHeartEvent0 = true;
      Switches.burnedBridgesWithCindy = false;
      Managers.Relationship.markCharacterAsKnown('Cindy');
      Managers.Relationship.markCharacterAsKnown('Rory');
      Managers.Relationship.markCharacterAsKnown('Raphael');
      Managers.Relationship.markCharacterAsKnown('Viktor');
      setHearts('Cindy', 1);

      $gameMessage.addText('Enter Rory farm to trigger the cutscene');
    }
  },
  {
    name: 'cindy_new_shop',
    method: () => {
      dropRide();
      Switches.burnedBridgesWithCindy = false;
      Managers.Relationship.markCharacterAsKnown('Cindy');
      Switches.cindyWorkingWithRaphael = false;
      Switches.cindyMovedOut = true;
      $gameMessage.addText('Enter Raphael house to trigger the cutscene.');
    }
  },
  {
    name: 'raphael_talk_about_forest',
    method: () => {
      Switches.raphaelTalkedAboutForest = false;
      Managers.Time.hour = 6;
      Managers.Time.minute = 3;
      Managers.Relationship.markCharacterAsKnown('Raphael');
      Managers.Relationship.markCharacterAsKnown('Annie');
      Managers.Relationship.markCharacterAsKnown('Chloe');

      if (Managers.Time.totalDays < 70) {
        setHearts('Raphael', 0.5);
        setHearts('Annie', 0.5);
        setHearts('Chloe', 0.5);
      }

      $gameMessage.addText('Leave your house to trigger the cutscene');
    }
  },
  {
    name: 'raphael_investigating_forest',
    method: () => {
      Switches.playedRaphaelForestInvestigation = false;
      Switches.raphaelTalkedAboutForest = true;
      dropRide();
      setCompanion('Raphael');
      Managers.Time.hour = 6;
      Managers.Time.minute = 3;
      $gameMessage.addText('Enter the forest center to trigger the cutscene');
    }
  },
  {
    name: 'raphael_investigating_forest_2',
    method: () => {
      Switches.talkedToCurupira = false;
      Switches.talkedToBenjaminAboutCurupira = true;
      dropRide();
      setCompanion('Raphael');
      Managers.Time.hour = 6;
      Managers.Time.minute = 3;
      $gameMessage.addText('Enter the forest center to trigger the cutscene');
    }
  },
  {
    name: 'devin_finds_magic_book',
    method: () => {
      Managers.Relationship.markCharacterAsKnown('Devin');
      dropRide();
      dropCompanion();

      Switches.playedDevinFindingMagicBook = false;
      Switches.devinOnAProject = false;
      Managers.Time.hour = 16;

      Managers.Relationship.markCharacterAsKnown('Annie');
      $gameMessage.addText('Enter the library to trigger the cutscene');
    }
  },
  {
    name: 'devin_studies_magic',
    method: () => {
      Managers.Relationship.markCharacterAsKnown('Devin');
      dropRide();
      dropCompanion();
      Switches.playedDevinKnowsMagic = false;
      Switches.devinOnAProject = false;
      Switches.unlockedSprinklers = true;
      Switches.playedAnnieZeroHearts = true;
      Variables.sprinklersMade = 10;
      Managers.History.registerItemShipped('big-blue-crystal');
      Managers.Time.hour = 16;
      $gameMessage.addText('Enter the library to trigger the cutscene');
    }
  },
  {
    name: 'devin_events_gift_1',
    method: () => {
      Managers.Relationship.markCharacterAsKnown('Devin');
      dropRide();
      dropCompanion();
      Switches.playedDevinHeartEvent0 = false;
      Managers.Time.hour = 18;
      Managers.Time.minute = 3;
      Managers.Time.seconds = 0;
      Managers.Relationship.markCharacterAsKnown('Nathalia');
      Managers.Weather.currentWeather = 0;

      if (!Managers.Items.canGainItemId('sandwich') || !Managers.Items.canGainItemId('chocolate-icecream'))  {
        $gameMessage.add('Clear an item slot and enter Orange Town to trigger the cutscene.');
      } else {
        $gameMessage.add('Enter Orange Town to trigger the cutscene');
      }

    }
  },
  {
    name: 'devin_events_gift_2',
    method: () => {
      Managers.Relationship.markCharacterAsKnown('Devin');
      dropRide();
      dropCompanion();
      Switches.playedDevinHeartEvent0B = false;
      Switches.playedDevinHeartEvent0 = true;
      Managers.Time.hour = 10;
      Managers.Relationship.markCharacterAsKnown('Serge');
      $gameMessage.add('Enter Orange Town to trigger the cutscene');
    }
  },
  {
    name: 'devin_events_gift_3',
    method: () => {
      Managers.Relationship.markCharacterAsKnown('Devin');
      dropRide();
      dropCompanion();

      Switches.playedDevinHeartEvent0C = false;
      Switches.playedDevinHeartEvent0B = true;
      Managers.Time.hour = 16;
      Managers.Time.minute = 0;
      Managers.Time.seconds = 0;

      Managers.Relationship.markCharacterAsKnown('Benjamin');
      Managers.Relationship.markCharacterAsKnown('Chloe');
      $gameMessage.add('Enter the restaurant to trigger the cutscene');
    }
  },
  {
    name: 'devin_events_gift_4',
    method: () => {
      Managers.Relationship.markCharacterAsKnown('Devin');
      dropRide();
      dropCompanion();

      Switches.playedDevinHeartEvent0D = false;
      Switches.playedDevinHeartEvent0C = true;
      Managers.Time.hour = 19;
      Managers.Time.minute = 0;
      Managers.Time.seconds = 0;
      Managers.Relationship.markCharacterAsKnown('Julia');
      Managers.Weather.currentWeather = 0;
      $gameMessage.add('Enter Orange Town to trigger the cutscene');
    }
  },
  {
    name: 'devin_heart_event_one',
    method: () => {
      dropRide();
      dropCompanion();

      Switches.playedDevinEventRichardQuestions = false;
      Switches.playedDevinHeartEvent0D = true;
      Managers.Relationship.markCharacterAsKnown('Devin');
      Managers.Relationship.markCharacterAsKnown('Richard');
      setHearts('Devin', 1);

      $gameMessage.addText('Enter the general store to trigger the cutscene.');
    }
  },
  {
    name: 'duke_introduction_scene',
    method: () => {
      dropRide();
      dropCompanion();
      forgetFriend('Duke');
      if (Managers.Time.yearDay < Constants.DUKE_MIN_DAY || Managers.Time.yearDay > Constants.DUKE_MAX_DAY) {
        Managers.Time.month = 1;
        Managers.Time.day = Constants.DUKE_MIN_DAY;
      }

      Managers.Time.hour = 6;
      $gameMessage.addText('Enter the town from your farm to trigger the cutscene');
    }
  },
  {
    name: 'gary_introduction_scene',
    method: () => {
      dropRide();
      dropCompanion();
      forgetFriend('Gary');
      Managers.Time.year = 1;
      Managers.Time.month = 1;
      Managers.Time.day = 4;

      Managers.Time.hour = 8;
      $gameMessage.addText('Enter the beach to trigger the cutscene');
    }
  },
  {
    name: 'lucas_fishing_rod',
    method: () => {
      dropRide();
      dropCompanion();
      Managers.Relationship.markCharacterAsKnown('Lucas');
      Switches.hasFishingRod = false;
      Switches.lucasOpenedUp = true;
      if (Managers.Time.totalDays < 12) {
        Managers.Time.day = 12;
      }

      $gameMessage.addText('Leave your house to trigger the cutscene.');
    }
  },
  {
    name: 'raphael_tells_devin_about_wanting_a_girlfriend_scene',
    method: () => {
      dropRide();
      dropCompanion();
      Managers.Relationship.markCharacterAsKnown('Raphael');
      Managers.Relationship.markCharacterAsKnown('Devin');
      Switches.playedRaphaelWantingGirlfriend = false;
      Managers.Time.hour = 9;
      Managers.Time.minute = 1;
      Switches.unlockedRaphaelEvents = true;
      $gameMessage.addText('Leave your farm and enter the town to trigger this cutscene.');
    }
  },
  {
    name: 'prince_offer_*',
    method: () => {
      Switches.salesmanVisitedToday = false;

      Managers.Time.hour = 6;
      Switches.expandedHouse = true;

      if (Switches.hasKitchenKnife && Switches.hasKitchenPot && Switches.hasKitchenPan && Switches.hasKitchenOven && Switches.hasKitchenMixer && Switches.hasKitchenBlender) {
        if (Switches.gotSalesmanGoldenOrange) {
          Switches.hasKitchenKnife = false;
          Switches.hasKitchenPot = false;
          Switches.hasKitchenPan = false;
          Switches.hasKitchenOven = false;
          Switches.hasKitchenMixer = false;
          Switches.hasKitchenBlender = false;
          Switches.gotSalesmanGoldenOrange = false;
        } else {
          // move to the first week
          if (Managers.Time.day > 7 && Managers.Time.weekDay != Days.SATURDAY) {
            Managers.Time.day = 1;
          }
        }
      }

      while (Managers.Time.weekDay != Days.SATURDAY) {
        Managers.Time.day++;
        Managers.Time.updateTime(false);
      }

      $gameMessage.addText('Leave your house to get an offer from the salesman.');
    }
  }
];

const dates = [
  {
    name: 'annie_first_date',
    method: () => {
      Switches.playedAnnieFirstDate = false;
      Switches.playedAnnieFirstHeart = true;

      dropRide();
      setCompanion('Annie');
      Managers.Time.hour = 10;
      Managers.Time.minute = 0;
      setHearts('Annie', 2);
      $gameMessage.addText('Enter the mountain from orange town to trigger the date');
    }
  },
  {
    name: 'annie_second_date',
    method: () => {
      Switches.playedAnnieFirstDate = true;
      Switches.playedAnnieSecondDate = false;

      dropRide();
      setCompanion('Annie');
      Managers.Time.hour = 13;
      Managers.Time.minute = 0;
      setHearts('Annie', 3);
      $gameMessage.addText('Enter the forest from orange town to trigger the date');
    }
  },

  {
    name: 'benjamin_first_date',
    method: () => {
      Switches.playedBenjaminFirstDate = false;
      Switches.playedBenjaminHeartEvent0 = true;
      Switches.benjaminOpenedUp = true;

      dropRide();
      setCompanion('Benjamin');
      Managers.Time.hour = 10;
      Managers.Time.minute = 0;
      setHearts('Benjamin', 2);
      $gameMessage.addText('Enter the mountain from orange town to trigger the date');
    }
  },
  {
    name: 'benjamin_second_date',
    method: () => {
      Switches.playedBenjaminFirstDate = true;
      Switches.playedBenjaminSecondDate = false;
      Switches.playedBenjaminHeartEvent0 = true;
      Switches.benjaminOpenedUp = true;

      dropRide();
      setCompanion('Benjamin');
      Managers.Time.hour = 13;
      Managers.Time.minute = 0;
      setHearts('Benjamin', 3);
      $gameMessage.addText('Enter the forest from orange town to trigger the date');
    }
  },

  {
    name: 'brittany_first_date',
    method: () => {
      Switches.playedBrittanyFirstDate = false;

      dropRide();
      setCompanion('Brittany');
      Managers.Time.hour = 17;
      Managers.Time.minute = 0;
      setHearts('Brittany', 2);
      $gameMessage.addText('Enter the restaurant on a friday/saturday to trigger the date');
    }
  },
  {
    name: 'brittany_second_date',
    method: () => {
      Switches.playedBrittanyFirstDate = true;
      Switches.playedBrittanySecondDate = false;

      dropRide();
      setCompanion('Brittany');
      Managers.Time.hour = 13;
      Managers.Time.minute = 0;
      setHearts('Brittany', 3);
      $gameMessage.addText('Enter the forest from orange town to trigger the date');
    }
  },

  
  {
    name: 'cindy_first_date',
    method: () => {
      Switches.playedCindyFirstDate = false;
      Switches.playedCindyHeartEvent0 = true;
      Switches.playedCindyHeartEvent1 = true;
      Switches.unlockedCindyEvents = true;

      dropRide();
      setCompanion('Cindy');
      Managers.Time.hour = 10;
      Managers.Time.minute = 0;
      setHearts('Cindy', 2);
      $gameMessage.addText('Enter the mountain from orange town to trigger the date');
    }
  },
  {
    name: 'cindy_second_date',
    method: () => {
      Switches.playedCindyFirstDate = true;
      Switches.playedCindySecondDate = false;
      Switches.playedCindyHeartEvent0 = true;
      Switches.playedCindyHeartEvent1 = true;
      Switches.unlockedCindyEvents = true;

      dropRide();
      setCompanion('Cindy');
      Managers.Time.hour = 20;
      Managers.Time.minute = 0;
      setHearts('Cindy', 3);
      $gameMessage.addText('Enter the beach to trigger the date');
    }
  },

  {
    name: 'devin_first_date',
    method: () => {
      Switches.playedDevinFirstDate = false;
      Switches.playedDevinEventRichardQuestions = true;

      dropRide();
      setCompanion('Devin');
      Managers.Time.hour = 10;
      Managers.Time.minute = 0;
      setHearts('Devin', 2);
      $gameMessage.addText('Enter the mountain from orange town to trigger the date');
    }
  },
  {
    name: 'devin_second_date',
    method: () => {
      Switches.playedDevinFirstDate = true;
      Switches.playedDevinSecondDate = false;
      Switches.playedDevinEventRichardQuestions = true;

      dropRide();
      setCompanion('Devin');
      Managers.Time.hour = 20;
      Managers.Time.minute = 0;
      setHearts('Devin', 3);
      $gameMessage.addText('Enter the beach to trigger the date');
    }
  },

  {
    name: 'lucas_first_date',
    method: () => {
      Switches.playedLucasFirstDate = false;
      Switches.lucasOpenedUp = true;

      dropRide();
      setCompanion('Lucas');
      Managers.Time.hour = 10;
      Managers.Time.minute = 0;
      setHearts('Lucas', 2);
      $gameMessage.addText('Enter the mountain from orange town to trigger the date');
    }
  },
  {
    name: 'lucas_second_date',
    method: () => {
      Switches.playedLucasFirstDate = true;
      Switches.playedLucasSecondDate = false;
      Switches.lucasOpenedUp = true;

      dropRide();
      setCompanion('Lucas');
      Managers.Time.hour = 20;
      Managers.Time.minute = 0;
      setHearts('Lucas', 3);
      $gameMessage.addText('Enter the beach to trigger the date');
    }
  },

  {
    name: 'nathalia_first_date',
    method: () => {
      Switches.playedNathaliaFirstDate = false;
      Switches.unlockedNathaliaEvents = true;

      dropRide();
      setCompanion('Nathalia');
      Managers.Time.hour = 17;
      Managers.Time.minute = 0;
      setHearts('Nathalia', 2);
      $gameMessage.addText('Enter the restaurant on a friday/saturday to trigger the date');
    }
  },
  {
    name: 'nathalia_second_date',
    method: () => {
      Switches.playedNathaliaFirstDate = true;
      Switches.playedNathaliaSecondDate = false;
      Switches.unlockedNathaliaEvents = true;

      dropRide();
      setCompanion('Nathalia');
      Managers.Time.hour = 13;
      Managers.Time.minute = 0;
      setHearts('Nathalia', 3);
      $gameMessage.addText('Enter the forest from orange town to trigger the date');
    }
  },

  {
    name: 'raphael_first_date',
    method: () => {
      Switches.playedRaphaelFirstDate = false;
      Switches.playedRaphaelWantingGirlfriend = true;
      Switches.unlockedRaphaelEvents = true;

      dropRide();
      setCompanion('Raphael');
      Managers.Time.hour = 9;
      Managers.Time.minute = 0;
      setHearts('Raphael', 2);
      $gameMessage.addText('Enter the mountain from orange town to trigger the date');
    }
  },
  {
    name: 'raphael_second_date',
    method: () => {
      Switches.playedRaphaelFirstDate = true;
      Switches.playedRaphaelSecondDate = false;
      Switches.unlockedRaphaelEvents = true;

      dropRide();
      setCompanion('Raphael');
      Managers.Time.hour = 9;
      Managers.Time.minute = 0;
      setHearts('Raphael', 3);
      $gameMessage.addText('Enter the forest from orange town to trigger the date');
    }
  },

  {
    name: 'stella_first_date',
    method: () => {
      Switches.playedStellaFirstDate = false;
      Switches.unlockedStellaEvents = true;

      dropRide();
      setCompanion('Stella');
      Managers.Time.hour = 17;
      Managers.Time.minute = 0;
      setHearts('Stella', 2);
      $gameMessage.addText('Enter the restaurant on a friday/saturday to trigger the date');
    }
  },
  {
    name: 'stella_second_date',
    method: () => {
      Switches.playedStellaFirstDate = true;
      Switches.playedStellaSecondDate = false;
      Switches.unlockedStellaEvents = true;

      dropRide();
      setCompanion('Stella');
      Managers.Time.hour = 18;
      Managers.Time.minute = 0;
      setHearts('Stella', 3);
      $gameMessage.addText('Enter the beach to trigger the date');
    }
  },

  {
    name: 'viktor_first_date',
    method: () => {
      Switches.playedViktorFirstDate = false;

      dropRide();
      setCompanion('Viktor');
      Managers.Time.hour = 17;
      Managers.Time.minute = 0;
      setHearts('Viktor', 2);
      $gameMessage.addText('Enter the restaurant on a friday/saturday to trigger the date');
    }
  },
  {
    name: 'viktor_second_date',
    method: () => {
      Switches.playedViktorFirstDate = true;
      Switches.playedViktorSecondDate = false;
      Switches.unlockedViktorEvents = true;

      dropRide();
      setCompanion('Viktor');
      Managers.Time.hour = 17;
      Managers.Time.minute = 0;
      setHearts('Viktor', 3);
      $gameMessage.addText('Enter the restaurant on a friday/saturday to trigger the date');
    }
  },
];


function enableCutscene(name) {
  if (!name || typeof name !== 'string') {
    return;
  }

  const cutscene = name.toUpperCase();

  for (const config of cutscenes) {
    if (config.name.toUpperCase() === cutscene) {
      return config.method();
    }
  }
}

function enableDate(name) {
  if (!name || typeof name !== 'string') {
    return;
  }

  const date = name.toUpperCase();

  for (const config of dates) {
    if (config.name.toUpperCase() === date) {
      return config.method();
    }
  }
}


class DebugContent {
  static contentId() {
    return 'debug';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'DEBUG') {
      return;
    }

    const name = parser.name.toUpperCase();
    if (name === 'CUTSCENES') {
      parser.interpreter.clearReservedChoices();
      for (const config of cutscenes) {
        parser.interpreter.addChoice(config.name);
      }
      
      if (window.response) {
        delete window.response;
      }
      parser.interpreter.executeChoicesCommand('Player', '("Using this command can cause unexpected results on your game progress. \\nPick the cutscene you want to test.", "Cancel", "Cancel")');
      const handler = setInterval(() => {
        if (window.response) {
          clearInterval(handler);

          enableCutscene(window.response);
        }
      }, 400);
      return true;
    }

    if (name === 'DATES') {
      parser.interpreter.clearReservedChoices();
      for (const config of dates) {
        parser.interpreter.addChoice(config.name);
      }
      if (window.response) {
        delete window.response;
      }

      parser.interpreter.executeChoicesCommand('Player', '("Using this command can cause unexpected results on your game progress. \\nPick the date you want to test.", "Cancel", "Cancel")');
      const handler = setInterval(() => {
        if (window.response) {
          clearInterval(handler);

          enableDate(window.response);
        }
      }, 400);
      return true;
    }

    if (name === 'FESTIVALS') {
      parser.interpreter.clearReservedChoices();
      parser.interpreter.addChoice("Flower Festival");
      parser.interpreter.addChoice("Chicken Race");
      parser.interpreter.addChoice("Tomato War");
      parser.interpreter.addChoice("Candy Day");

      if (window.response) {
        delete window.response;
      }
      parser.interpreter.executeChoicesCommand('Player', '("Using this command will change your calendar. \\nPick the festival you want to test.", "Cancel", "Cancel")');
      const handler = setInterval(() => {
        if (window.response) {
          clearInterval(handler);

          let day = 9;
          let month = 1;

          switch (window.response) {
            case 'Flower Festival':
              month = 1;
              day = 9;
              break;
            case 'Tomato War':
              month = 2;
              day = 28;
              break;
            case 'Chicken Race':
              day = 18;
              break;
            case 'Candy Day':
              month = 4;
              break;
          }

          Managers.Time.month = month;
          Managers.Time.day = day;
          Managers.Time.hour = 10;
          Managers.Time.updateTime(true, true);
          $gamePlayer.requestMapReload();
          $gamePlayer.quickTransfer($gameMap._mapId, $gamePlayer._x, $gamePlayer._y, $gamePlayer._direction, 0, false, false);
          Managers.Villagers.killAllVillagerEvents();
          $gameMap.refreshTilemap();

        }

      }, 400);
      return true;
    }

    if (name === 'ENABLE') {
      const cutscene = parser.nextArg();
      enableCutscene(cutscene);
      return true;
    }

    if (name === 'REQUESTS') {
      const autoTasks = Managers.Content.findContentClass('auto-tasks');
      if (!autoTasks) {
        return;
      }

      const list = autoTasks.autoTasks;
      if (!list || !list.length) {
        return;
      }

      parser.interpreter.clearReservedChoices();
      for (const request of list) {
        parser.interpreter.addChoice(request.id);
      }

      if (window.response) {
        delete window.response;
      }
      parser.interpreter.executeChoicesCommand('Player', '("Select the Request you want to activate", "Cancel", "Cancel")');
      const handler = setInterval(() => {
        if (window.response) {
          clearInterval(handler);
        }

        for (const request of list) {
          if (request.id === window.response) {
            request.generatorFn.call(autoTasks);
            return;
          }
        }
      }, 400);
      return true;
    }
  }
}

Managers.Content.registerContentClass(DebugContent);
module.exports = DebugContent;