require('game/models/Crop');

Models.FarmCrop = class BushCrop extends Models.Crop {
  static shouldGrowToday(gameObject, withinRangeOfSprinkler) {
    if (gameObject.watered || withinRangeOfSprinkler) {
      return true;
    }

    if (Managers.Weather.wasRaining()) {
      if (InsideFarmMaps.indexOf(gameObject.mapId) < 0) {
        return true;
      }
    }

    return false;
  }

  static getWateredDeathChance() {
    return 0;
  }

  static isFlower() {
    return false;
  }

  static processGameObjectNewDay(gameObject) {
    // To make sure we don't kill crops from the save file that are no longer accessible due to the map change,
    // let's ignore all crops from maps that are not initialized
    if (!$gameSystem.isMapInitialized(gameObject.mapId)) return;

    const stage = this.stage(gameObject);
    const withinRange = Managers.FarmObjects.isTileWithinRangeOfASprinkler(gameObject.mapId, gameObject.x, gameObject.y);

    if (this.shouldGrowToday(gameObject, withinRange)) {
      gameObject.watered = false;

      if (stage > 0 && gameObject.age > this.getMinDeathAge() && Math.randomInt(100) < this.getWateredDeathChance()) {
        gameObject.lastFruit = true;
      } else {
        this.increasePoints(gameObject);
      }
    } else if (gameObject.age > this.getMinDeathAge() && Math.randomInt(100) < this.getDryDeathChance()) {
      gameObject.lastFruit = true;
    }

    if (Managers.Weather.isRaining()) {
      if (InsideFarmMaps.indexOf(gameObject.mapId) < 0) {
        gameObject.watered = true;
      }
    }

    if (withinRange) {
      gameObject.watered = true;
    }
  }
};
