require('game/models/Crop');

Models.CaveCrop = class CaveCrop extends Models.Crop {
  static get cropName() {
    return '';
  }

  static processGameObjectNewDay(gameObject) {
    const withinRange = Managers.FarmObjects.isTileWithinRangeOfASprinkler(gameObject.mapId, gameObject.x, gameObject.y);

    if (Managers.Map.mapIsCaveFarm(gameObject.mapId)) {
      const stageCaps = this.getStageCaps();

      if (gameObject.watered || withinRange) {
        gameObject.increasePoints(stageCaps);
      }

      gameObject.increasePoints(stageCaps);
      gameObject.watered = withinRange;
      return;
    }

    gameObject.watered = false;
    if (Managers.Weather.isRaining()) {
      if (InsideFarmMaps.indexOf(gameObject.mapId) < 0) {
        gameObject.watered = true;
      }
    }

    if (withinRange) {
      gameObject.watered = true;
    }
  }

  static isFlower() {
    return false;
  }
};
