require('game/managers/Content');

class CropsContent {
  static contentId() {
    return 'crops';
  }

  static onLoadModManager() {
    Managers.Packages.loadYamlFile('crops', 'data/flowers.yaml', (flowers) => {
      for (const modelName in flowers) {
        const data = flowers[modelName];
        const flowerModel = class extends Models.FlowerCrop {
          static get cropName() {
            return modelName;
          }
          static getStageCaps() {
            return data.stageCaps;
          }
          static getDryDeathChance() {
            return 0;
          }
          static getRegularSpriteName() {
            return data.spriteName;
          }
          static getDeadSpriteName() {
            return data.deadSpriteName;
          }
          static getCropSpriteIndex() {
            return data.spriteIndex;
          }
          static getCropDirection() {
            return data.direction;
          }
          static regrows() {
            return false;
          }
        };

        Models[`flower-${ modelName}`] = flowerModel;
        Managers.FarmObjects.registerModel(flowerModel);
      }
    });

    Managers.Packages.loadYamlFile('crops', 'data/crops.yaml', (crops) => {
      for (const modelName in crops) {
        const data = crops[modelName];
        const cropModel = class extends Models.FarmCrop {
          static get cropName() {
            return modelName;
          }
          static getStageCaps() {
            return data.stageCaps;
          }
          static getWateredDeathChance() {
            return data.wateredDeathChance;
          }
          static getDryDeathChance() {
            return data.dryDeathChance;
          }
          static getRegularSpriteName() {
            return data.spriteName;
          }
          static getDeadSpriteName() {
            return data.deadSpriteName;
          }
          static getCropSpriteIndex() {
            return data.spriteIndex;
          }
          static getCropDirection() {
            return data.direction;
          }
          static regrows() {
            return data.regrows;
          }
        };

        Models[`farm-crop-${ modelName}`] = cropModel;
        Managers.FarmObjects.registerModel(cropModel);
      }
    });

    Managers.Packages.loadYamlFile('crops', 'data/cave-crops.yaml', (caveCrops) => {
      for (const modelName in caveCrops) {
        const data = caveCrops[modelName];
        const cropModel = class extends Models.CaveCrop {
          static get cropName() {
            return modelName;
          }
          static getStageCaps() {
            return data.stageCaps;
          }
          static getWateredDeathChance() {
            return data.wateredDeathChance;
          }
          static getDryDeathChance() {
            return data.dryDeathChance;
          }
          static getRegularSpriteName() {
            return data.spriteName;
          }
          static getDeadSpriteName() {
            return data.deadSpriteName;
          }
          static getCropSpriteIndex() {
            return data.spriteIndex;
          }
          static getCropDirection() {
            return data.direction;
          }
          static regrows() {
            return data.regrows;
          }
        };

        Models[`cave-crop-${ modelName}`] = cropModel;
        Managers.FarmObjects.registerModel(cropModel);
      }
    });
  }


}

Managers.Content.registerContentClass(CropsContent);