require('game/tools/SimpleTool');

Tools.WolfCostume = class WolfCostume extends Tools.SimpleTool {
  static get toolName() {
    return 'wolf-costume';
  }

  static doToolEffect(level) {
    Managers.Player.changeCostumeName('wolf');

    if (Managers.Items.isHoldingItem('wolf-costume')) {
      Managers.Items._itemIndex = -1;
    }
    Managers.Tools.setTool('empty');
    Managers.Items.requestHudRefresh();
  }
};

function findCreatures() {
  let minX = $gamePlayer.x;
  let maxX = $gamePlayer.x;
  let minY = $gamePlayer.y;
  let maxY = $gamePlayer.y;

  switch ($gamePlayer._direction) {
    case Direction.LEFT:
      minX = Math.floor(minX - 2);
      maxX = Math.ceil(maxX);
      minY = Math.floor(minY - 1);
      maxY = Math.ceil(maxY + 1);
      break;
    case Direction.RIGHT:
      minX = Math.floor(minX);
      maxX = Math.ceil(maxX + 2);
      minY = Math.floor(minY - 1);
      maxY = Math.ceil(maxY + 1);
      break;
    case Direction.UP:
      minY = Math.floor(minY - 2);
      maxY = Math.ceil(maxY);
      minX = Math.floor(minX - 1);
      maxX = Math.ceil(maxX + 1);
      break;
    case Direction.DOWN:
      minY = Math.floor(minY);
      maxY = Math.ceil(maxY + 2);
      minX = Math.floor(minX - 1);
      maxX = Math.ceil(maxX + 1);
      break;
  }

  return $gameMap.filteredCreatures((event) => {
    if (!event || event._erased || event._hidden) return false;

    return event.realPosIn(minX, minY, maxX, maxY);
  });
}

Tools.ScareSkill = class ScareSkill extends Tools.SimpleTool {
  static get toolName() {
    return 'wolf-scare';
  }

  static doToolEffect(level) {
    Managers.CommonEvent.playEvent('use_wolf_scare');
  }

  static scareAnimals() {
    const creatures = findCreatures();

    for (const creature of creatures) {
      creature.runAwayFromPlayer(12);
    }
  }
};

Managers.Tools.registerTool(Tools.ScareSkill);
Managers.Tools.registerTool(Tools.WolfCostume);