require('game/managers/Content');

//////////////////////////////
// Content Class
//////////////////////////////

function isWearingWolfCostume() {
  return Managers.Player.costumeName == 'wolf';
}

let wolfCostumeIconIndex;

class WolfCostumeContent {
  static contentId() {
    return 'wolf-costume';
  }

  static onLoadModManager() {
    const iconIndex = Managers.Mods.addIcon(undefined, 'icons', 'wolf-costume.png');

    Managers.Mods.addObjectData({
      id : 'wolf-costume',
      type : 'tool-item',
      category: 'tools',
      disabled: false,
      available: true,
      iconIndex
    });

    wolfCostumeIconIndex = iconIndex;
  }

  static generatePlayerSpriteName() {
    if (!isWearingWolfCostume()) {
      return;
    }
    
    return 'costumes/wolf';
  }

  static vetoToolList(tools) {
    if (!isWearingWolfCostume()) return;

    tools.splice(0, tools.length);
  }

  static vetoSkillList(skills) {
    if (!isWearingWolfCostume()) return;

    skills.splice(0, skills.length);

    skills.push({
      type : 'tool',
      id : 'wolf-scare',
      // #ToDo: replace with an exclusive icon
      iconIndex : wolfCostumeIconIndex,
      hotkey: 1
    });

    skills.push({
      type : 'tool',
      id : 'wolf-costume',
      iconIndex : wolfCostumeIconIndex,
      hotkey: 0
    });
  }

  static canRideAnimal(animalData) {
    if (!isWearingWolfCostume()) return;

    return false;
  }
}

Managers.Content.registerContentClass(WolfCostumeContent);
module.exports = WolfCostumeContent;