require('game/managers/Content');

//////////////////////////////
// Content Class
//////////////////////////////

function isWearingBeeKeeperCostume() {
  return Managers.Player.costumeName == 'beekeeper';
}

let beeKeeperIconIndex;

class BeeKeeperCostumeContent {
  static contentId() {
    return 'beekeeper-costume';
  }

  static onLoadModManager() {
    const iconIndex = Managers.Mods.addIcon(undefined, 'icons', 'beekeeper-costume.png');

    Managers.Mods.addObjectData({
      id : 'beekeeper-costume',
      type : 'tool-item',
      category: 'tools',
      disabled: false,
      available: true,
      iconIndex
    });

    beeKeeperIconIndex = iconIndex;
  }

  static generatePlayerSpriteName() {
    if (!isWearingBeeKeeperCostume()) {
      return;
    }
    
    return 'costumes/beekeeper';
  }

  static vetoToolList(tools) {
    if (!isWearingBeeKeeperCostume()) return;

    tools.splice(0, tools.length);
  }

  static vetoSkillList(skills) {
    if (!isWearingBeeKeeperCostume()) return;

    skills.splice(0, skills.length);

    skills.push({
      type : 'tool',
      id : 'beekeeper-costume',
      iconIndex : beeKeeperIconIndex,
      hotkey: 0
    });
  }

  static canRideAnimal(animalData) {
    if (!isWearingBeeKeeperCostume()) return;

    return false;
  }
}

Managers.Content.registerContentClass(BeeKeeperCostumeContent);
module.exports = BeeKeeperCostumeContent;