require('game/managers/Content');

//////////////////////////////
// Content Class
//////////////////////////////

class CookingSystemContent {
  static contentId() {
    return 'cooking';
  }

  static onLoadModManager() {
    Managers.CommonEvent.redirectEvent('library_book_11', 'library_cooking_book');
    Managers.CommonEvent.redirectEvent('library_book_12', 'library_cake_book');
  }

  static getCustomDatabaseSummaryLines() {
    return [{
      weight: 20,
      title: t("Recipes Learnt"),
      dataFn: function() {
        const data = Managers.Cooking.getRecipeStatistics();
        const recipesLearned = data[0].length;
        const totalRecipes = data[1].length;

        return [recipesLearned, totalRecipes];
      }
    }];
  }

  static getStampValue(stampId) {
    if (stampId == 'recipes') {
      const data = Managers.Cooking.getRecipeStatistics();
      return data[0].length;
    }
  }

  static getMaxStampValue(stampId) {
    if (stampId == 'recipes') {
      const data = Managers.Cooking.getRecipeStatistics();
      return data[1].length;
    }
  }

  static isStampEnabled(stampId) {
    if (stampId == 'recipes') {
      const data = Managers.Cooking.getRecipeStatistics();
      return data[0].length == data[1].length;
    }
  }
}

Managers.Content.registerContentClass(CookingSystemContent);
module.exports = CookingSystemContent;