require('game/managers/Content');

function doCropsNewDay() {
  Managers.Mine.processNewDay();
  $gameSystem.clearDailyStuff();
  Managers.FarmObjects.processNewDay();

  $gamePlayer.requestMapReload();
  $gamePlayer.quickTransfer($gameMap._mapId, $gamePlayer._x, $gamePlayer._y, $gamePlayer._direction, 0, false, false);
  Managers.Villagers.killAllVillagerEvents();
  $gameMap.refreshTilemap();
}

class CheatCodesContent {
  static contentId() {
    return 'cheat';
  }

  static triggerCheat() {
    if (!Engine.Input.isPressed('shift')) {
      return;
    }

    const cheat = ['up', 'up', 'down', 'down', 'left', 'right', 'left', 'right'];

    if (Engine.Input.isSequencePressed(cheat)) {
      Engine.Input.clearSequence();
      this.callCommandCode();
      return true;
    }
  }

  static callCommandCode() {
    Managers.CommonEvent.playEvent('call_command_code');

    Variables.cheatCode = '';
    Managers.Scenes.push(GameScenes.StringVariable);
    Managers.Scenes.prepareNextScene('cheatCode', 70);
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'CHEAT') {
      return;
    }

    const cheat = parser.name.toUpperCase();

    switch (cheat) {
      case 'ANIMALS':
        Managers.Creatures.processNewDay();
        return true;
      case 'CROPS':
        doCropsNewDay();
        return true;
      case 'GROW':
        {
          const objects = Managers.FarmObjects._farmObjects[$gameMap._mapId];
          if (objects) {
            objects.forEach((o) => {
              if (o && o.points !== undefined) {
                o.points = 200;
              }
            });
          }

          doCropsNewDay();
        }

        return true;
      case 'CHANGE':
        if (parser.nextUpperArg() === 'WEATHER') {
          parser.skipArg();
          let isTomorrow = false;
          if (parser.nextUpperArg() === 'TOMORROW') {
            isTomorrow = true;
            parser.skipArg();
          }

          if (isTomorrow) {
            Managers.CommonEvent.playEvent('cheat_change_tomorrow_weather');
          } else {
            Managers.CommonEvent.playEvent('cheat_change_weather');
          }
        }

        if (parser.nextUpperArg() === 'HOUR') {
          parser.skipArg();
          const hour = parser.nextArgAsFloat() || 0;
          Managers.Time.hour = hour;
          return true;
        }

        if (parser.nextUpperArg() === 'TIME') {
          Managers.CommonEvent.playEvent('cheat_change_time');
          return true;
        }

        return true;
      case 'SKIP':
        if (parser.nextUpperArg() === 'DAY') {
          Managers.CommonEvent.runCommand('home sleep');
          return true;
        }

        if (parser.nextUpperArg() === 'MONTH') {
          Managers.Time.month++;
          Managers.Time.day = 1;
          Managers.Time.updateTime();
          $gameMap.refreshWholeMap();
          return true;
        }

        return true;
    }
  }
}

Managers.Content.registerContentClass(CheatCodesContent);