require('game/managers/Content');
require('game/managers/Festivals');
require('game/core/Constants');

class CandyFestivalContent {
  static contentId() {
    return 'candy-day';
  }

  static startDay() {
    Switches.gaveCandyToPhi = false;
    Switches.gaveCandyToRichard = false;
    Switches.gaveCandyToNathalia = false;
  }

  static playCustomTvChannel(playFn) {
    if (Managers.Time.yearDay == Festivals.CANDY - 1) {
      playFn('candy');
      return true;
    }
  }

  static getTvChannelFrameLength(channelName) {
    if (channelName == 'candy') {
      return 31;
    }
  }
}

Managers.Content.registerContentClass(CandyFestivalContent);
Managers.Festivals.registerFestival('candy', Festivals.CANDY, CandyFestivalContent, 'isCandyFestival', 92, "Candy Day");