require('game/objects/Object');
const Sprite_Bell = require('../sprites/BellSprite');

class BellObject extends Objects.Object {
  useBell() {
    $gameTemp.lastBell = this;
    Managers.CommonEvent.playEvent('use_bell_on_farm');
    // if ($gameMap.isFarm()) {
    //   Managers.CommonEvent.playEvent('use_bell_on_farm');
    // } else {
    //   Managers.CommonEvent.playEvent('use_bell_outside_farm');
    // }
  }

  getSpriteClass() {
    return Sprite_Bell;
  }

  start(activatedByMouse) {
    if (activatedByMouse && !TouchInput.isTriggered()) {
      return false;
    }

    super.start(activatedByMouse);

    if (this.stopBellTimeout) {
      clearTimeout(this.stopBellTimeout);
    }

    // If the object was removed, don't run the event
    if (!this._farmObjectData || !this._farmObjectData.modelName) {
      return;
    }

    this.useBell();
    return true;
  }

  animate() {
    this._stepAnime = true;
    this._lockPattern = false;
    this._moveSpeed = 5;
    this._moveFrequency = 5;

    this.stopBellTimeout = setTimeout(() => {
      this._stepAnime = false;
      this._lockPattern = true;
      this._pattern = 1;

      this.stopBellTimeout = false;
    }, 2000);
  }

  pickUp() {
    if (this._farmObjectData) {
      if (Managers.Items.pickItemId(this._farmObjectData.modelName)) {
        this._farmObjectData.clear();
        this.erase();
        Managers.FarmObjects.clearEmptyItems();
        return;
      }
    }
  }

  updateAnimation() {
    super.updateAnimation();
  }
}

Objects.Bell = BellObject;
module.exports = BellObject;