require('game/managers/Content');
require('game/tools/Tool');

const BellObject = require('./objects/BellObject');

const bells = [
  'iron-bell',
  'wooden-bell'
];

class BellsContent {
  static contentId() {
    return 'bells';
  }

  static checkSpecialItemDrop(targetX, targetY) {
    if (!Managers.Items.selectedItem) return;

    const itemId = Managers.Items.selectedItem.id;

    if (bells.indexOf(itemId) >= 0) {
      return Managers.Items.useSelectedItem(targetX, targetY);
    }
  }

  static getObjectClassType(object) {
    if (bells.includes(object.modelName)) {
      return BellObject;
    }
  }

  static hasAnythingToRun(event, farmObjectData, activatedByMouse) {
    if (bells.includes(farmObjectData.modelName)) {
      return true;
    }
  }

  static pickBoughtItem(item) {
    switch(item.id) {
      case 'iron-bell':
        Managers.Villagers.playDialogue('Viktor', 'trigger_iron_bell_craft');
        return true;
      case 'wooden-bell':
        Managers.Villagers.playDialogue('Viktor', 'trigger_wooden_bell_craft');
        return true;
    }
  }

  static makeBlacksmithProductList(container) {
    container.gainItemId('wooden-bell');
    container.gainItemId('iron-bell');
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'BELL') {
      return;
    }

    const name = parser.name.toUpperCase();

    switch (name) {
      case 'MOVE':
        {
          const moveType = parser.nextUpperArg(true);

          if (moveType === 'INSIDE') {
            Managers.Creatures.moveAnimalsInside();
          } else {
            Managers.Creatures.moveAnimalsOutside();
          }
        }
        break;
      case 'RIDE':
        if (parser.nextUpperArg() === 'SUMMON') {
          this.summonRide();
        } else {
          this.sendRideHome();
        }
        break;
      case 'ANIMATE':
        if ($gameTemp.lastBell) {
          $gameTemp.lastBell.animate();
          return;
        }
        break;
      case 'PICK':
        if ($gameTemp.lastBell) {
          $gameTemp.lastBell.pickUp();
          return;
        }
        break;
    }
  }

  static summonRide() {

  }

  static sendRideHome() {

  }
}

Managers.Content.registerContentClass(BellsContent);