require('game/creatures/Animal');
require('game/managers/Creature');
require('engine/core/MVCommons');

Creatures.Shiba = MVC.deepClone(Creatures.Animal);

(function($){
  $.creatureName = 'shiba';
  $.creatureKindName = 'shiba';
  $.creatureKindEnabled = true;

  $._spriteName = 'animals/shiba';
  $._spriteIndex = 0;

  // $._hitboxX = 0;
  // $._hitboxY = 0;
  // $._hitboxWidth = 48;
  // $._hitboxHeight = 48;

  $.processCreatureNewDay = function(creature) {
    if (creature.mapId == Maps.FARM) {
      creature.x = 35;
      creature.y = 9;
    } else if (creature.mapId == Maps.HOME_2 || creature.mapId == Maps.HOME || creature.mapId == Maps.HOME_3) {
      creature.x = 16;
      creature.y = 5;
    } else if (creature.mapId == Maps.HOME_3B) {
      creature.x = 20;
      creature.y = 5;
    } else if (creature.mapId == creature.homeMapId) {
      creature.x = creature.homeX;
      creature.y = creature.homeY;
    }

    if (creature.mapId == $gameMap._mapId) {
      if (!Managers.Items.isHoldingCreature(creature.id)) {
        creature.updateEvents(true);
      }
    }
  };
})(Creatures.Shiba);

Managers.Creatures.registerCreature(Creatures.Shiba);